***Robustness

use "$projdir/est/irf_rrshock_nl_2_2.dta", clear
merge 1:1 hor using "$projdir/est/irf_rrshock_nl_4_4.dta", nogenerate
merge 1:1 hor using "$projdir/est/irf_rrshock_nl_6_6.dta", nogenerate
merge 1:1 hor using "$projdir/est/irf_rrshock_nl_8_8.dta", nogenerate
merge 1:1 hor using "$projdir/est/irf_rrshock_nl_10_10.dta", nogenerate
merge 1:1 hor using "$projdir/est/irf_rrshock_nl_12_12.dta", nogenerate

local yvars "lindpro lcpiaucsl unrate fedfunds"
local lp_hor = 36

* plot IRFs
local graphs ""
local graphs_int ""

foreach yvar in `yvars'{
	
	if "`yvar'"=="lindpro"{
		local title "Industrial Production"
	}
	if "`yvar'"=="lcpiaucsl"{
		local title "Consumer Price Index"
	}
	if "`yvar'"=="unrate"{
		local title "Unemployment Rate"
	}
	if "`yvar'"=="fedfunds"{
		local title "Federal Funds Rate"
	}
	
	label var irf_`yvar'_2_2 "2 Lags"
	label var irf_`yvar'_4_4 "4 Lags"
	label var irf_`yvar'_6_6 "6 Lags"
	label var irf_`yvar'_8_8 "8 Lags"
	label var irf_`yvar'_10_10 "10 Lags"
	label var irf_`yvar'_12_12 "12 Lags (Baseline)"

	tw (line irf_`yvar'_2_2 hor, clc(black ) clp(l ) ) ///
	(line irf_`yvar'_4_4 hor, clc(black ) clp(dot ) ) ///
	(line irf_`yvar'_6_6 hor, clc(black ) clp(dash )) ///
	(line irf_`yvar'_8_8 hor, clc(black ) clp(dash_dot ) ) ///
	(line irf_`yvar'_10_10 hor, clc(black ) clp(longdash ) ) ///
	(line irf_`yvar'_12_12 hor, clc(black ) clp(shortdash ) ) ///
	if hor<=`lp_hor' ///
	, nodraw name(lp_rrshock_`yvar', replace) yline(0) xlabel(0(6)36) xscale(range(0 36)) legend(off) title("`title'") ytitle("Percent") xtitle("Months") legend(rows(2))

	local newgraph "lp_rrshock_`yvar'"
	local graphs "`graphs' `newgraph'"	
	
	label var irf_`yvar'_int_2_2 "2 Lags "
	label var irf_`yvar'_int_4_4 "4 Lags"
	label var irf_`yvar'_int_6_6 "6 Lags"
	label var irf_`yvar'_int_8_8 "8 Lags"
	label var irf_`yvar'_int_10_10 "10 Lags"
	label var irf_`yvar'_int_12_12 "12 Lags (Baseline)"

	tw (line irf_`yvar'_int_2_2 hor, clc(black ) clp(l ) ) ///
	(line irf_`yvar'_int_4_4 hor, clc(black ) clp(dot ) ) ///
	(line irf_`yvar'_int_6_6 hor, clc(black ) clp(dash )) ///
	(line irf_`yvar'_int_8_8 hor, clc(black ) clp(dash_dot ) ) ///
	(line irf_`yvar'_int_10_10 hor, clc(black ) clp(longdash ) ) ///
	(line irf_`yvar'_int_12_12 hor, clc(black ) clp(shortdash ) ) ///
	if hor<=`lp_hor' ///
	, nodraw name(lp_rrshock_nl_`yvar', replace) yline(0) xlabel(0(6)36) xscale(range(0 36)) legend(off) title("`title'") ytitle("Percent") xtitle("Months") legend(rows(2))

	local newgraph "lp_rrshock_nl_`yvar'"
	local graphs_nl "`graphs_nl' `newgraph'"	
		
}

***combine IRFs
qui{

	grc1leg `graphs', name(irf_rrshock_robust, replace) legendfrom(lp_rrshock_lindpro) xcommon imargin(0 0 -2 -2)  
	graph export "$projdir/out/irf_rrshock_nl_robust.pdf", replace
	
	grc1leg `graphs_nl', name(irf_rrshock_nl_robust, replace) legendfrom(lp_rrshock_nl_lindpro) xcommon imargin(0 0 -2 -2)  
	graph export "$projdir/out/irf_rrshock_nl_ints_robust.pdf", replace

}