/* This program produces figures plotting the measures of publicly held private debt and monetary policy shocks used in the main text*/

*** load data
{ 

	use "$projdir/dta/cln/data.dta", clear
	
	tsset date
	
	*generate normalized debt measure
	gen debt_gdp = 100*(privmrkval/1000000000)/mngdp
	egen debtnorm = std(debt_gdp) if inrange(date,ym(1969,3),ym(2007,12))==1
	
	*rescale debt_ip
	replace privmrkval = privmrkval/1000000000000

}

tsline privmrkval if inrange(date,ym(1969,3),ym(2007,12))==1, tlabel(1968m1(120)2008m1) clc(black) name(debt, replace) yline(0) legend(off) ytitle("Trillions of Dollars") xtitle("") 
graph export "$projdir/out/debt_plot.pdf", replace
tsline debt_gdp if inrange(date,ym(1969,3),ym(2007,12))==1, tlabel(1968m1(120)2008m1) clc(black) name(debt_gdp, replace) yline(0) legend(off) ytitle("Percent") xtitle("") 
graph export "$projdir/out/debt_gdp_plot.pdf", replace

tsline resid_full if inrange(date,ym(1969,3),ym(2007,12))==1, tlabel(1968m1(120)2008m1) clc(black) name(rrshock, replace) yline(0) legend(off) ytitle("") xtitle("") 
graph export "$projdir/out/rrshock_plot.pdf", replace
tsline MM_IV1 if inrange(date,ym(1991,1),ym(2009,12))==1, clc(black) name(mrshock, replace) yline(0) legend(off) ytitle("") xtitle("") 
graph export "$projdir/out/mrshock_plot.pdf", replace