/* This program generates impulse responses of macro variables to updated Romer-Romer(2004) monetary policy shocks using Jorda (2005) local projections including privately held public debt*/

*** LP settings
{

	global sample "inrange(date,ym(1969,3),ym(2007,12))" // Wieland RR sample

	local lp_hor = 36
	local lp_lags = $lp_lags
	local shock_lags = $shock_lags
	local debtvar "privmrkval"
	local shock "resid_full"
	local yvars "lindpro lcpiaucsl unrate fedfunds"
	local xvars "lindpro lcpiaucsl lppiaco fedfunds"
	 
}

*** load data
{ 

	use "$projdir/dta/cln/data.dta", clear
	
	tsset date

	gen sample = $sample
	keep if sample==1

}

*** process data
{	
	
	gen hor = _n-1
	
	gen debt_gdp = l.`debtvar'/l.mngdp
	
	*generate normalized debt measure
	egen debtnorm = std(debt_gdp) if sample==1
	drop debt_gdp
	
	*rescale shock to 1SD
	summ `shock'
	replace `shock' = `shock'/r(sd)

	gen lindpro = 100*log(indpro)
	gen lcpiaucsl = 100*log(cpiaucsl)
	gen lppiaco = 100*log(ppiaco)
	
	local graphs ""	
	local graphs2 ""
	
	replace `shock'=0 if `shock'==.

	  *demean x variables (required for Kitagawa-Oaxaca-Blinder IRF) and create RHS
     foreach var in `xvars'{

		qui summ `var'
		replace  `var' = `var'-r(mean)

     }

}

*** estimate IRFs
foreach var in `yvars'{
	
	if "`var'"=="lindpro"{
		local title "Industrial Production"
	}
	if "`var'"=="lcpiaucsl"{
		local title "Consumer Price Index"
	}
	if "`var'"=="unrate"{
		local title "Unemployment Rate"
	}
	if "`var'"=="fedfunds"{
		local title "Federal Funds Rate"
	}
	if "`var'"=="gs1"{
		local title "One-Year Treasury"
	}

	*initialize IRFs
	gen irf_`var' = .
	gen upper_`var' = .
	gen lower_`var' = .
	
	gen irf_`var'_1sd = .
	gen upper_`var'_1sd = .
	gen lower_`var'_1sd = .	
	
	gen irf_`var'_int = .
	gen upper_`var'_int = .
	gen lower_`var'_int = .	

	local start = 0
	
	forvalues i = 0/`lp_hor'{
		
		*Generate LHS variable
		gen ydiff_h`i' = F`i'.`var' - L.`var'
		
		*Run regressions
		ivreg2 ydiff_h`i' c.`shock'##c.debtnorm L(0/`shock_lags')(`shock') L(1/`lp_lags')(`xvars' debtnorm), robust bw(12)
		
		drop ydiff*
		
		replace irf_`var' = _b[`shock'] if hor==`i'
		replace lower_`var' = _b[`shock']-_se[`shock'] if hor==`i'
		replace upper_`var' = _b[`shock']+_se[`shock'] if hor==`i'
		
		replace irf_`var'_1sd = _b[`shock']+_b[c.`shock'#c.debtnorm] if hor==`i'
		replace lower_`var'_1sd = _b[`shock']+_b[c.`shock'#c.debtnorm] - sqrt(_se[`shock']^2+_se[c.`shock'#c.debtnorm]^2 + 2*e(V)["`shock'","c.`shock'#c.debtnorm"]) if hor==`i'
		replace upper_`var'_1sd = _b[`shock']+_b[c.`shock'#c.debtnorm] + sqrt(_se[`shock']^2+_se[c.`shock'#c.debtnorm]^2 + 2*e(V)["`shock'","c.`shock'#c.debtnorm"]) if hor==`i'
		
		replace irf_`var'_int = _b[c.`shock'#c.debtnorm] if hor==`i'
		replace lower_`var'_int = _b[c.`shock'#c.debtnorm]-_se[c.`shock'#c.debtnorm] if hor==`i'
		replace upper_`var'_int = _b[c.`shock'#c.debtnorm]+_se[c.`shock'#c.debtnorm] if hor==`i'
		
	}		
}

preserve

foreach var in lindpro lcpiaucsl unrate fedfunds{
    gen irf_`var'_`lp_lags'_`shock_lags' = irf_`var'
	gen irf_`var'_int_`lp_lags'_`shock_lags' = irf_`var'_int
}
			
keep hor irf*
save "$projdir/est/irf_rrshock_nl_`lp_lags'_`shock_lags'.dta", replace	

restore