clear all

local eis =1
local kappa = 0.01
local rho = -ln(0.99)

range rho 0 1 1000
gen rho_l_rho = - (rho - (rho^2 + 4*`eis'*`kappa')^(1/2))/2
gen up = 1
gen down = 0

tw (rarea up rho_l_rho rho, fcolor(gs12%50) lwidth(none)), ytitle({&rho}{sub:L}) xtitle({&rho}) name(rho, replace) plotregion(margin(zero)) ylabel(, angle(horizontal)) // legend(label(1 {&part}{sup:2}c{sub:0}/{&part}u{sub:0}{&part}{&sigmaf}{sub:d}>0))
graph export "$projdir/out/rho_plot.pdf", replace

range kappa 0 1 1000
replace up = 1
gen rho_l_kappa = - (`rho' - (`rho'^2 + 4*`eis'*kappa)^(1/2))/2

tw (rarea up rho_l_kappa kappa, fcolor(gs12%50) lwidth(none)), ytitle({&rho}{sub:L}) xtitle({&kappa}) name(kappa, replace) plotregion(margin(zero)) ylabel(, angle(horizontal)) yscale(titlegap(*-20)) 
graph export "$projdir/out/kappa_plot.pdf", replace
