/* Fetches and cleans data */

tempfile 1 2 3 4 5

/* Macro data from FRED */
set fredkey , perm

import fred INDPRO CPIAUCSL PPIACO UNRATE POPTHM BAA AAA TB3MS GS1 GS5 CSUSHPISA T10Y2YM FEDFUNDS GS10 TB6MS MICH USREC, nosumm clear

rename BAA AAA TB3MS GS1 GS5 CSUSHPISA T10Y2YM FEDFUNDS GS10 PPIACO UNRATE INDPRO CPIAUCSL POPTHM TB6MS MICH USREC, lower

gen date = mofd(daten)
format date %tm
tsset date
order date, first
drop daten datestr

save `1', replace

/* U.S. debt 1776-2019 data from Hall and Sargent */

import delimited using "$projdir/dta/src/US_Treasury_Debt_1776-2019.csv", rowrange(4:) colrange(:9) numericcols(_all) asdouble varnames(nonames) clear

drop v3 v4 v5 v6 v7 v8

rename (v1 v2 v9)(year month privmrkval)

gen date = ym(year,month)
format date %tm 
order date, first
drop year month
tsset date

save `2', replace

/* Gilchrist-Zakrajsek monthly credit spread data (updated to August 2016), found at http://people.bu.edu/sgilchri/Data/data.htm */

import delimited using $projdir/dta/src/gz_monthly.csv, clear

gen datenew = monthly(date,"YM")
drop date
rename (datenew gzspr)(date gz_spr)
format date %tm
order date, first
tsset date

label variable ebp_oa "Gilchrist-Zakrajšek (2012) excess bond premium"
label variable gz_spr "Gilchrist-Zakrajšek (2012) credit spread"

save `3', replace

/* Stock and Watson monthly GDP */

import excel using $projdir/dta/src/SWMGDP.xlsx, clear cellrange(A3)

rename (A B C)(monthly mngdp mrgdp)

gen month = real(substr(monthly,-2,2))
gen year = real(substr(monthly,1,4))
gen date = ym(year,month)
drop monthly month year
format date %tm
order date, first
tsset date

label variable mngdp "Stock and Watson Monthly NGDP"
label variable mrgdp "Stock and Watson Monthly RGDP"

save `4', replace

* Miranda-Agrippino-Ricco 2021 monetary policy instrument

import excel using "$projdir/dta/src/Instruments_web.xlsx", sheet("Monthly") firstrow clear

gen year = floor(time/100)
gen mon = (time-year*100)
drop time

gen date = ym(year,mon)
format date %tm
drop year mon
order date, first
tsset date

drop isFOMCmonth MM_IV5

save `5', replace

/* Merge data */

use `1'
merge 1:1 date using `2', nogen
merge 1:1 date using `3', nogen
merge 1:1 date using `4', nogen
merge 1:1 date using "$projdir/dta/src/RR_monetary_shock_monthly.dta", nogen
merge 1:1 date using `5', nogen

drop resid resid_romer

save "$projdir/dta/cln/data.dta", replace
export delimited using "$projdir/dta/cln/data.csv", replace