function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = IRF_as_no_policy_eA_robust.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(31, 1);
lhs = y(35);
rhs = y(18)-params(4)*exp(y(13))^(1+params(5))/(1+params(5))+params(1)*y(45);
residual(1) = lhs - rhs;
lhs = exp(y(6));
rhs = T(5)*(y(41)+exp(y(44))*exp(y(43))*exp(y(36)))+T(7)+T(9);
residual(2) = lhs - rhs;
lhs = exp(y(5));
rhs = exp(y(6))*y(9);
residual(3) = lhs - rhs;
lhs = y(30);
rhs = T(11)/(T(11)+exp(y(27)));
residual(4) = lhs - rhs;
lhs = y(7);
rhs = 1/exp(y(6));
residual(5) = lhs - rhs;
lhs = y(8);
rhs = 1/exp(y(5));
residual(6) = lhs - rhs;
lhs = exp(y(10));
rhs = T(5);
residual(7) = lhs - rhs;
lhs = exp(y(11));
rhs = T(12)*T(13);
residual(8) = lhs - rhs;
lhs = y(14);
rhs = exp(y(11))*params(2)/exp(y(1));
residual(9) = lhs - rhs;
lhs = y(15);
rhs = exp(y(11))*(1-params(2))/exp(y(13));
residual(10) = lhs - rhs;
lhs = y(16);
rhs = 1/exp(y(10));
residual(11) = lhs - rhs;
lhs = exp(y(17));
rhs = T(15)+T(16);
residual(12) = lhs - rhs;
lhs = exp(y(12));
rhs = (1-params(8))*exp(y(1))+T(15)*T(17)+T(16)*y(8)/(1-params(9));
residual(13) = lhs - rhs;
lhs = y(15);
rhs = T(18);
residual(14) = lhs - rhs;
lhs = exp(y(17))+exp(y(18));
rhs = exp(y(11))+exp(y(10))*exp(params(14))-exp(params(14))-(1-y(9))*y(31)*exp(y(25));
residual(15) = lhs - rhs;
lhs = y(20);
rhs = exp(y(18))^(-1);
residual(16) = lhs - rhs;
lhs = y(19);
rhs = exp(params(14))/exp(y(11));
residual(17) = lhs - rhs;
lhs = y(21);
rhs = (y(41)+(1-params(8))*exp(y(37)))/exp(y(6));
residual(18) = lhs - rhs;
lhs = y(22);
rhs = y(21)-y(16);
residual(19) = lhs - rhs;
lhs = y(23);
rhs = exp(y(28))*T(20)/(1-params(8)+exp(y(27)));
residual(20) = lhs - rhs;
lhs = exp(y(26));
rhs = (T(11)+exp(y(27)))*exp(y(1));
residual(21) = lhs - rhs;
lhs = exp(y(25));
rhs = exp(y(5))*exp(y(26));
residual(22) = lhs - rhs;
lhs = y(31);
rhs = T(21)^(-params(12))-1;
residual(23) = lhs - rhs;
lhs = y(29);
rhs = 1-y(9);
residual(24) = lhs - rhs;
lhs = y(9);
rhs = y(30)/T(23);
residual(25) = lhs - rhs;
lhs = y(24);
rhs = params(30)*y(2)-x(it_, 1);
residual(26) = lhs - rhs;
lhs = y(27);
rhs = params(31)*y(3)+(1-params(31))*log(params(6))+x(it_, 2);
residual(27) = lhs - rhs;
lhs = y(28);
rhs = params(32)*y(4)+(1-params(32))*log(params(29))-x(it_, 3);
residual(28) = lhs - rhs;
lhs = exp(y(32));
rhs = T(5)*(y(41)+(1-params(8))*exp(y(37)));
residual(29) = lhs - rhs;
lhs = y(33);
rhs = (1-params(8))*T(27)*T(28)-T(29)*exp(y(36)-y(6));
residual(30) = lhs - rhs;
lhs = y(34);
rhs = exp(y(36)-y(6))*T(8)*T(29)+T(28)*T(8)*(1-params(8))*T(2)*T(4)*T(24)-T(28)*(1-params(8))*T(8)*T(27);
residual(31) = lhs - rhs;

end
