function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = IRF_as_no_policy_old_calibration_eO.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(31, 48);
g1(1,13)=params(4)*exp(y(13))*getPowerDeriv(exp(y(13)),1+params(5),1)/(1+params(5));
g1(1,18)=(-1);
g1(1,35)=1;
g1(1,45)=(-params(1));
g1(2,36)=(-(T(5)*exp(y(44))*exp(y(43))*exp(y(36))));
g1(2,6)=exp(y(6));
g1(2,37)=(-(T(7)+T(8)));
g1(2,38)=(-((y(41)+exp(y(44))*exp(y(43))*exp(y(36)))*T(31)));
g1(2,39)=(-(exp(y(37))*(1-params(8))*exp(y(44))*T(1)*T(2)*T(28)*getPowerDeriv(y(39)/params(10),T(3),1)));
g1(2,41)=(-T(5));
g1(2,20)=(-((y(41)+exp(y(44))*exp(y(43))*exp(y(36)))*(1+T(2)*T(4))*T(34)+exp(y(37))*(1-params(8))*exp(y(44))*T(6)*T(34)+exp(y(37))*(1-params(8))*(1-exp(y(44)))*T(34)));
g1(2,42)=(-((y(41)+exp(y(44))*exp(y(43))*exp(y(36)))*T(36)+exp(y(37))*(1-params(8))*exp(y(44))*T(6)*params(1)*1/y(20)+exp(y(37))*(1-params(8))*(1-exp(y(44)))*params(1)*1/y(20)));
g1(2,43)=(-(T(5)*exp(y(44))*exp(y(43))*exp(y(36))));
g1(2,44)=(-(T(7)+T(5)*exp(y(44))*exp(y(43))*exp(y(36))+exp(y(37))*(1-params(8))*T(1)*(-exp(y(44)))));
g1(3,5)=exp(y(5));
g1(3,6)=(-(exp(y(6))*y(9)));
g1(3,9)=(-exp(y(6)));
g1(4,8)=(-(((T(10)+exp(y(27)))*T(33)-T(10)*T(33))/((T(10)+exp(y(27)))*(T(10)+exp(y(27))))));
g1(4,27)=(-((-(T(10)*exp(y(27))))/((T(10)+exp(y(27)))*(T(10)+exp(y(27))))));
g1(4,30)=1;
g1(5,6)=(-((-exp(y(6)))/(exp(y(6))*exp(y(6)))));
g1(5,7)=1;
g1(6,5)=(-((-exp(y(5)))/(exp(y(5))*exp(y(5)))));
g1(6,8)=1;
g1(7,38)=(-T(31));
g1(7,10)=exp(y(10));
g1(7,20)=(-((1+T(2)*T(4))*T(34)));
g1(7,42)=(-T(36));
g1(8,11)=exp(y(11));
g1(8,1)=(-(T(12)*exp(y(24))*exp(y(1))*getPowerDeriv(exp(y(1)),params(2),1)));
g1(8,13)=(-(T(11)*exp(y(13))*getPowerDeriv(exp(y(13)),1-params(2),1)));
g1(8,24)=(-(T(11)*T(12)));
g1(9,11)=(-(exp(y(11))*params(2)/exp(y(1))));
g1(9,1)=(-((-(exp(y(1))*exp(y(11))*params(2)))/(exp(y(1))*exp(y(1)))));
g1(9,14)=1;
g1(10,11)=(-(exp(y(11))*(1-params(2))/exp(y(13))));
g1(10,13)=(-((-(exp(y(13))*exp(y(11))*(1-params(2))))/(exp(y(13))*exp(y(13)))));
g1(10,15)=1;
g1(11,10)=(-((-exp(y(10)))/(exp(y(10))*exp(y(10)))));
g1(11,16)=1;
g1(12,5)=(-(T(15)+exp(y(1))*exp(y(5))*exp(y(27))*exp(y(28))*T(13)));
g1(12,7)=(-T(29));
g1(12,8)=(-(exp(y(1))*exp(y(5))*(1-params(8))*exp(y(28))*T(32)));
g1(12,1)=(-(T(15)+T(13)*(exp(y(1))*y(14)+exp(y(1))*exp(y(5))*exp(y(27))*exp(y(28)))));
g1(12,14)=(-(exp(y(1))*T(13)));
g1(12,17)=exp(y(17));
g1(12,27)=(-(exp(y(1))*exp(y(5))*exp(y(27))*exp(y(28))*T(13)));
g1(12,28)=(-(T(15)+exp(y(1))*exp(y(5))*exp(y(27))*exp(y(28))*T(13)));
g1(13,5)=T(27);
g1(13,7)=(-(T(16)*T(29)+T(14)*1/(1-params(9))));
g1(13,8)=(-(y(8)/(1-params(9))*exp(y(1))*exp(y(5))*(1-params(8))*exp(y(28))*T(32)+T(15)*1/(1-params(9))));
g1(13,1)=(-(T(15)*y(8)/(1-params(9))+(1-params(8))*exp(y(1))+T(16)*T(13)*(exp(y(1))*y(14)+exp(y(1))*exp(y(5))*exp(y(27))*exp(y(28)))));
g1(13,12)=exp(y(12));
g1(13,14)=(-(T(16)*exp(y(1))*T(13)));
g1(13,27)=(-(T(16)*exp(y(1))*exp(y(5))*exp(y(27))*exp(y(28))*T(13)));
g1(13,28)=T(27);
g1(14,13)=(-(exp(y(18))*params(4)*exp(y(13))*getPowerDeriv(exp(y(13)),params(5),1)));
g1(14,15)=1;
g1(14,18)=(-T(17));
g1(15,9)=exp(y(25))*(-y(31));
g1(15,10)=(-(exp(y(10))*exp(params(14))));
g1(15,11)=(-exp(y(11)));
g1(15,17)=exp(y(17));
g1(15,18)=exp(y(18));
g1(15,25)=(1-y(9))*y(31)*exp(y(25));
g1(15,31)=(1-y(9))*exp(y(25));
g1(16,18)=(-(exp(y(18))*getPowerDeriv(exp(y(18)),(-1),1)));
g1(16,20)=1;
g1(17,11)=(-((-(exp(y(11))*exp(params(14))))/(exp(y(11))*exp(y(11)))));
g1(17,19)=1;
g1(18,6)=(-((-(exp(y(6))*(y(41)+(1-params(8))*exp(y(37)))))/(exp(y(6))*exp(y(6)))));
g1(18,37)=(-((1-params(8))*exp(y(37))/exp(y(6))));
g1(18,41)=(-(1/exp(y(6))));
g1(18,21)=1;
g1(19,16)=1;
g1(19,21)=(-1);
g1(19,22)=1;
g1(20,9)=(-(exp(y(28))*(1-params(8))*getPowerDeriv(y(9),T(18),1)/(1-params(8)+exp(y(27)))));
g1(20,23)=1;
g1(20,27)=(-(exp(y(28))*(exp(y(27))*(1-params(8)+exp(y(27)))-exp(y(27))*T(19))/((1-params(8)+exp(y(27)))*(1-params(8)+exp(y(27))))));
g1(20,28)=(-(exp(y(28))*T(19)/(1-params(8)+exp(y(27)))));
g1(21,8)=(-(exp(y(1))*T(33)));
g1(21,1)=(-((T(10)+exp(y(27)))*exp(y(1))));
g1(21,26)=exp(y(26));
g1(21,27)=(-(exp(y(27))*exp(y(1))));
g1(22,5)=(-(exp(y(5))*exp(y(26))));
g1(22,25)=exp(y(25));
g1(22,26)=(-(exp(y(5))*exp(y(26))));
g1(23,25)=(-(T(20)*getPowerDeriv(T(20),(-params(12)),1)));
g1(23,31)=1;
g1(24,9)=1;
g1(24,29)=1;
g1(25,9)=1;
g1(25,30)=(-((T(22)-y(30)*y(31)/(T(21)+T(21)))/(T(22)*T(22))));
g1(25,31)=(-((-(y(30)*((y(30)+(1-y(31))*(-0.5))/(T(21)+T(21))-0.5)))/(T(22)*T(22))));
g1(26,2)=(-params(30));
g1(26,24)=1;
g1(26,46)=1;
g1(27,3)=(-params(31));
g1(27,27)=1;
g1(27,47)=(-1);
g1(28,4)=(-params(32));
g1(28,28)=1;
g1(28,48)=1;
g1(29,37)=(-(T(5)*(1-params(8))*exp(y(37))));
g1(29,38)=(-((y(41)+(1-params(8))*exp(y(37)))*T(31)));
g1(29,41)=(-T(5));
g1(29,20)=(-((y(41)+(1-params(8))*exp(y(37)))*(1+T(2)*T(4))*T(34)));
g1(29,42)=(-((y(41)+(1-params(8))*exp(y(37)))*T(36)));
g1(29,32)=exp(y(32));
g1(30,36)=exp(y(43))*exp(y(44))*(1+T(2)*T(4))*T(23)*exp(y(36)-y(6));
g1(30,6)=(-(T(26)*(-exp(y(37)-y(6)))-exp(y(43))*exp(y(44))*(1+T(2)*T(4))*T(23)*(-exp(y(36)-y(6)))));
g1(30,37)=(-(T(26)*exp(y(37)-y(6))));
g1(30,38)=(-(exp(y(37)-y(6))*exp(y(44))*(1-params(8))*T(25)*T(30)-exp(y(36)-y(6))*exp(y(43))*exp(y(44))*T(23)*T(2)*T(30)));
g1(30,40)=(-(exp(y(37)-y(6))*exp(y(44))*(1-params(8))*T(4)*T(2)*T(23)*(-(getPowerDeriv(y(40),T(18),1)))));
g1(30,16)=(-(exp(y(37)-y(6))*exp(y(44))*(1-params(8))*T(4)*T(2)*T(24)*y(42)/y(20)*params(1)*100-exp(y(36)-y(6))*exp(y(43))*exp(y(44))*(1+T(2)*T(4))*y(42)/y(20)*params(1)*100));
g1(30,20)=(-(exp(y(37)-y(6))*exp(y(44))*(1-params(8))*T(4)*T(2)*T(24)*T(35)-exp(y(36)-y(6))*exp(y(43))*exp(y(44))*(1+T(2)*T(4))*T(35)));
g1(30,42)=(-(exp(y(37)-y(6))*exp(y(44))*(1-params(8))*T(4)*T(2)*T(24)*T(37)-exp(y(36)-y(6))*exp(y(43))*exp(y(44))*(1+T(2)*T(4))*T(37)));
g1(30,43)=exp(y(43))*exp(y(44))*(1+T(2)*T(4))*T(23)*exp(y(36)-y(6));
g1(30,44)=(-(T(26)*exp(y(37)-y(6))-exp(y(43))*exp(y(44))*(1+T(2)*T(4))*T(23)*exp(y(36)-y(6))));
g1(30,33)=1;
g1(31,6)=(-((1-exp(y(44)))*(1-params(8))*T(2)*T(4)*T(23)*(-exp(y(37)-y(6)))));
g1(31,37)=(-(exp(y(37)-y(6))*(1-exp(y(44)))*(1-params(8))*T(2)*T(4)*T(23)));
g1(31,38)=(-(exp(y(37)-y(6))*(1-exp(y(44)))*(1-params(8))*T(23)*T(2)*T(30)));
g1(31,16)=(-(exp(y(37)-y(6))*(1-exp(y(44)))*(1-params(8))*T(2)*T(4)*y(42)/y(20)*params(1)*100));
g1(31,20)=(-(exp(y(37)-y(6))*(1-exp(y(44)))*(1-params(8))*T(2)*T(4)*T(35)));
g1(31,42)=(-(exp(y(37)-y(6))*(1-exp(y(44)))*(1-params(8))*T(2)*T(4)*T(37)));
g1(31,44)=(-(exp(y(37)-y(6))*(1-params(8))*T(2)*T(4)*T(23)*(-exp(y(44)))));
g1(31,34)=1;

end
