function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 26);

T(1) = params(1)*y(42)/y(20);
T(2) = params(9)/(1-params(9));
T(3) = (-1)/params(9);
T(4) = (y(38)/params(10))^T(3);
T(5) = T(1)*(1+T(2)*T(4));
T(6) = 1+T(2)*(y(39)/params(10))^T(3);
T(7) = y(44)*T(1)*T(6)*(1-params(8))*exp(y(37));
T(8) = (y(8)/params(10))^T(3);
T(9) = (1-params(8))*T(8);
T(10) = exp(y(24))*exp(y(1))^params(2);
T(11) = exp(y(13))^(1-params(2));
T(12) = (y(7)/params(10))^T(3);
T(13) = (exp(params(14))+exp(y(1))*y(14)+exp(y(1))*exp(y(5))*y(27)*y(28))*T(12);
T(14) = T(8)*exp(y(1))*exp(y(5))*(1-params(8))*y(28);
T(15) = y(7)/(1-params(9));
T(16) = T(14)*y(8)/(1-params(9));
T(17) = params(4)*exp(y(13))^params(5)*exp(y(18));
T(18) = 1/params(9);
T(19) = y(27)+(1-params(8))*y(9)^T(18);
T(20) = exp(y(25))/exp(params(18));
T(21) = sqrt(((1-y(31))/2)^2+y(30)*y(31));
T(22) = (1-y(31))/2+T(21);
T(23) = y(42)/y(20)*params(1)*y(16)*100;
T(24) = 1-y(40)^T(18);
T(25) = T(2)*T(23)*T(24);
T(26) = y(44)*(1-params(8))*T(4)*T(25);

end
