function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 42);

T = IRF_as_no_policy_old_calibration_robust.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(30) = (-(T(16)*y(8)/(1-params(9))+T(17)*exp(y(1))*exp(y(5))*exp(y(27))*exp(y(28))*T(14)));
T(31) = 1/params(10);
T(32) = (exp(params(14))+exp(y(1))*y(14)+exp(y(1))*exp(y(5))*exp(y(27))*exp(y(28)))*T(31)*getPowerDeriv(y(7)/params(10),T(3),1);
T(33) = T(31)*getPowerDeriv(y(38)/params(10),T(3),1);
T(34) = T(1)*T(2)*T(33);
T(35) = T(31)*getPowerDeriv(y(8)/params(10),T(3),1);
T(36) = (1-params(8))*T(35);
T(37) = T(4)*T(2)*T(24)*(-(getPowerDeriv(y(40),T(19),1)));
T(38) = params(1)*(-y(42))/(y(20)*y(20));
T(39) = params(1)*y(16)*100*(-y(42))/(y(20)*y(20));
T(40) = exp(y(43))*(1+T(2)*T(4))*T(39);
T(41) = (1+T(2)*T(4))*params(1)*1/y(20);
T(42) = params(1)*y(16)*100*1/y(20);

end
