function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = IRF_as_policy.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(30, 49);
g1(1,15)=params(4)*T(50)/(1+params(5));
g1(1,20)=(-1);
g1(1,36)=1;
g1(1,45)=(-params(1));
g1(2,37)=(-(T(5)*y(44)*y(43)*exp(y(37))));
g1(2,8)=exp(y(8));
g1(2,38)=(-(T(9)+T(8)*(1-params(8))*T(1)*(1-y(44))));
g1(2,39)=(-(T(6)*T(35)));
g1(2,40)=T(41);
g1(2,41)=(-T(5));
g1(2,22)=(-(T(6)*T(4)*T(55)+T(8)*(1-params(8))*y(44)*T(7)*T(55)+T(8)*(1-params(8))*(1-y(44))*T(55)));
g1(2,42)=(-(T(6)*T(4)*T(56)+T(8)*(1-params(8))*y(44)*T(7)*T(56)+T(8)*(1-params(8))*(1-y(44))*T(56)));
g1(2,43)=(-(T(5)*y(44)*exp(y(37))));
g1(2,44)=(-(T(5)*y(43)*exp(y(37))+T(8)*T(1)*T(7)*(1-params(8))+T(8)*(1-params(8))*(-T(1))));
g1(3,7)=T(10);
g1(3,8)=(-(exp(y(8))*y(11)));
g1(3,11)=(-exp(y(8)));
g1(4,10)=(-(((T(12)+y(30))*T(37)-T(12)*T(37))/((T(12)+y(30))*(T(12)+y(30)))));
g1(4,30)=(-((-T(12))/((T(12)+y(30))*(T(12)+y(30)))));
g1(4,34)=1;
g1(5,8)=(-((-exp(y(8)))/(exp(y(8))*exp(y(8)))));
g1(5,9)=1;
g1(6,7)=(-((-T(10))/(T(10)*T(10))));
g1(6,10)=1;
g1(7,39)=(-T(35));
g1(7,12)=exp(y(12));
g1(7,22)=(-(T(4)*T(55)));
g1(7,42)=(-(T(4)*T(56)));
g1(8,13)=exp(y(13));
g1(8,1)=(-(T(15)*exp(y(27))*T(48)));
g1(8,15)=(-(T(14)*T(51)));
g1(8,27)=(-(T(14)*T(15)));
g1(9,13)=(-(exp(y(13))*params(2)/T(13)));
g1(9,1)=T(49);
g1(9,16)=1;
g1(10,13)=(-(exp(y(13))*(1-params(2))/exp(y(15))));
g1(10,15)=T(52);
g1(10,17)=1;
g1(11,12)=(-((-exp(y(12)))/T(43)));
g1(11,18)=1;
g1(12,7)=(-(T(18)+T(13)*T(10)*y(30)*y(31)*T(16)));
g1(12,9)=(-T(32));
g1(12,10)=(-(T(13)*T(10)*(1-params(8))*y(31)*T(36)));
g1(12,1)=(-(T(18)+T(16)*(T(13)*y(16)+T(13)*T(10)*y(30)*y(31))));
g1(12,16)=(-(T(13)*T(16)));
g1(12,19)=exp(y(19));
g1(12,2)=(-(exp(y(2))*T(16)));
g1(12,30)=(-(T(16)*T(13)*T(10)*y(31)));
g1(12,31)=(-(T(16)*T(13)*T(10)*y(30)+T(11)*T(13)*(1-params(8))*T(10)));
g1(13,7)=(-(T(21)+T(19)*T(13)*T(10)*y(30)*y(31)*T(16)));
g1(13,9)=(-(T(19)*T(32)+T(17)*T(33)));
g1(13,10)=T(38);
g1(13,1)=(-(T(21)+(1-params(8))*T(13)+T(19)*T(16)*(T(13)*y(16)+T(13)*T(10)*y(30)*y(31))));
g1(13,14)=exp(y(14));
g1(13,16)=(-(T(19)*T(13)*T(16)));
g1(13,2)=(-(T(19)*exp(y(2))*T(16)));
g1(13,30)=(-(T(19)*T(16)*T(13)*T(10)*y(31)));
g1(13,31)=T(59);
g1(14,15)=(-(exp(y(20))*params(4)*T(53)));
g1(14,17)=1;
g1(14,20)=(-T(22));
g1(15,11)=exp(y(28))*(-y(35));
g1(15,12)=(-(exp(y(12))*exp(y(25))));
g1(15,13)=(-exp(y(13)));
g1(15,19)=exp(y(19));
g1(15,20)=exp(y(20));
g1(15,2)=exp(y(2));
g1(15,25)=(-(exp(y(12))*exp(y(25))));
g1(15,28)=(1-y(11))*y(35)*exp(y(28));
g1(15,35)=(1-y(11))*exp(y(28));
g1(16,20)=(-T(54));
g1(16,22)=1;
g1(17,13)=T(47);
g1(17,21)=1;
g1(17,2)=(-(exp(y(2))/exp(y(13))));
g1(18,7)=(-((-(T(10)*(y(41)+exp(y(37))*y(43)*y(31))))/(T(10)*T(10))+(-(T(10)*T(23)))/(T(10)*T(10))+T(29)/(T(10)*T(10))));
g1(18,37)=(-(exp(y(37))*y(43)*y(31)/T(10)));
g1(18,38)=(-(T(23)/T(10)+T(24)));
g1(18,10)=T(39);
g1(18,12)=T(46);
g1(18,41)=(-(1/T(10)));
g1(18,23)=1;
g1(18,43)=(-(exp(y(37))*y(31)/T(10)));
g1(18,31)=(-(y(43)*exp(y(37))/T(10)+T(60)+T(61)));
g1(19,18)=1;
g1(19,23)=(-1);
g1(19,24)=1;
g1(20,11)=(-(y(31)*T(42)/(1-params(8)+y(30))));
g1(20,26)=1;
g1(20,30)=(-(y(31)*(1-params(8)+y(30)-T(25))/((1-params(8)+y(30))*(1-params(8)+y(30)))));
g1(20,31)=(-(T(25)/(1-params(8)+y(30))));
g1(21,10)=(-(y(31)*T(13)*T(37)));
g1(21,1)=(-(y(31)*(T(12)+y(30))*T(13)));
g1(21,29)=exp(y(29));
g1(21,30)=(-(T(13)*y(31)));
g1(21,31)=(-((T(12)+y(30))*T(13)));
g1(22,7)=(-(T(10)*exp(y(29))));
g1(22,28)=exp(y(28));
g1(22,29)=(-(T(10)*exp(y(29))));
g1(23,25)=exp(y(25));
g1(23,28)=(-(exp(params(14))*T(57)));
g1(23,32)=(-1);
g1(24,28)=(-(T(58)*(T(26)>0)));
g1(24,35)=1;
g1(25,11)=1;
g1(25,33)=1;
g1(26,11)=1;
g1(26,34)=(-((T(28)-y(34)*T(62))/(T(28)*T(28))));
g1(26,35)=(-((-(y(34)*(T(63)-0.5)))/(T(28)*T(28))));
g1(27,3)=(-params(31));
g1(27,27)=1;
g1(27,46)=1;
g1(28,4)=(-params(32));
g1(28,30)=1;
g1(28,47)=(-1);
g1(29,5)=(-params(33));
g1(29,31)=1;
g1(29,48)=1;
g1(30,6)=(-params(34));
g1(30,32)=1;
g1(30,49)=1;

end
