function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 63);

T = IRF_as_policy.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(29) = (-(T(10)*T(8)*(1-params(8))*1/exp(y(12))*(1-y(31))));
T(30) = 1/params(10);
T(31) = T(30)*getPowerDeriv(y(9)/params(10),T(3),1);
T(32) = (exp(y(2))+T(13)*y(16)+T(13)*T(10)*y(30)*y(31))*T(31);
T(33) = 1/(1-params(9));
T(34) = T(2)*T(30)*getPowerDeriv(y(39)/params(10),T(3),1);
T(35) = T(1)*T(34);
T(36) = T(30)*getPowerDeriv(y(10)/params(10),T(3),1);
T(37) = (1-params(8))*T(36);
T(38) = (-(T(20)*T(13)*T(10)*(1-params(8))*y(31)*T(36)+T(18)*T(33)));
T(39) = (-(T(8)*y(31)*(1-params(8))*T(2)*T(36)/exp(y(12))/T(10)));
T(40) = T(2)*T(30)*getPowerDeriv(y(40)/params(10),T(3),1);
T(41) = (-(T(8)*(1-params(8))*y(44)*T(1)*T(40)));
T(42) = (1-params(8))*getPowerDeriv(y(11),1/params(9),1);
T(43) = exp(y(12))*exp(y(12));
T(44) = T(8)*y(31)*(1-params(8))*(-(exp(y(12))*(1+T(2)*T(11))))/T(43);
T(45) = T(8)*(1-y(31))*(1-params(8))*(-exp(y(12)))/T(43);
T(46) = (-(T(44)/T(10)+T(45)/T(10)));
T(47) = (-((-(exp(y(13))*exp(y(2))))/(exp(y(13))*exp(y(13)))));
T(48) = T(13)*getPowerDeriv(T(13),params(2),1);
T(49) = (-((-(T(13)*exp(y(13))*params(2)))/(T(13)*T(13))));
T(50) = exp(y(15))*getPowerDeriv(exp(y(15)),1+params(5),1);
T(51) = exp(y(15))*getPowerDeriv(exp(y(15)),1-params(2),1);
T(52) = (-((-(exp(y(15))*exp(y(13))*(1-params(2))))/(exp(y(15))*exp(y(15)))));
T(53) = exp(y(15))*getPowerDeriv(exp(y(15)),params(5),1);
T(54) = exp(y(20))*getPowerDeriv(exp(y(20)),(-1),1);
T(55) = params(1)*(-y(42))/(y(22)*y(22));
T(56) = params(1)*1/y(22);
T(57) = exp(y(28)-params(18))*getPowerDeriv(exp(y(28)-params(18)),(-params(35)),1);
T(58) = exp(y(28)-params(18))*getPowerDeriv(exp(y(28)-params(18)),(-params(12)),1);
T(59) = (-(T(19)*T(16)*T(13)*T(10)*y(30)+T(20)*T(11)*T(13)*(1-params(8))*T(10)));
T(60) = T(8)*(1-params(8))*(1+T(2)*T(11))/exp(y(12))/T(10);
T(61) = T(8)*(-((1-params(8))*1/exp(y(12))))/T(10);
T(62) = y(35)/(T(27)+T(27));
T(63) = (y(34)+(1-y(35))*(-0.5))/(T(27)+T(27));

end
