function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 69);

T = IRF_as_policy.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(64) = T(1)*T(2)*T(30)*T(30)*getPowerDeriv(y(39)/params(10),T(3),2);
T(65) = params(1)*(-((-y(42))*(y(22)+y(22))))/(y(22)*y(22)*y(22)*y(22));
T(66) = T(30)*T(30)*getPowerDeriv(y(10)/params(10),T(3),2);
T(67) = (1-params(8))*T(66);
T(68) = ((-exp(y(12)))*T(43)-(-exp(y(12)))*(T(43)+T(43)))/(T(43)*T(43));
T(69) = (exp(y(2))+T(13)*y(16)+T(13)*T(10)*y(30)*y(31))*T(30)*T(30)*getPowerDeriv(y(9)/params(10),T(3),2);

end
