function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = IRF_as_policy.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(30, 1);
lhs = y(36);
rhs = y(20)-params(4)*exp(y(15))^(1+params(5))/(1+params(5))+params(1)*y(45);
residual(1) = lhs - rhs;
lhs = exp(y(8));
rhs = T(5)*T(6)+T(9)+T(8)*(1-params(8))*T(1)*(1-y(44));
residual(2) = lhs - rhs;
lhs = T(10);
rhs = exp(y(8))*y(11);
residual(3) = lhs - rhs;
lhs = y(34);
rhs = T(12)/(T(12)+y(30));
residual(4) = lhs - rhs;
lhs = y(9);
rhs = 1/exp(y(8));
residual(5) = lhs - rhs;
lhs = y(10);
rhs = 1/T(10);
residual(6) = lhs - rhs;
lhs = exp(y(12));
rhs = T(5);
residual(7) = lhs - rhs;
lhs = exp(y(13));
rhs = T(14)*T(15);
residual(8) = lhs - rhs;
lhs = y(16);
rhs = exp(y(13))*params(2)/T(13);
residual(9) = lhs - rhs;
lhs = y(17);
rhs = exp(y(13))*(1-params(2))/exp(y(15));
residual(10) = lhs - rhs;
lhs = y(18);
rhs = 1/exp(y(12));
residual(11) = lhs - rhs;
lhs = exp(y(19));
rhs = T(17)+T(18);
residual(12) = lhs - rhs;
lhs = exp(y(14));
rhs = (1-params(8))*T(13)+T(17)*T(19)+T(21);
residual(13) = lhs - rhs;
lhs = y(17);
rhs = T(22);
residual(14) = lhs - rhs;
lhs = exp(y(19))+exp(y(20));
rhs = exp(y(13))+exp(y(12))*exp(y(25))-exp(y(2))-(1-y(11))*y(35)*exp(y(28));
residual(15) = lhs - rhs;
lhs = y(22);
rhs = exp(y(20))^(-1);
residual(16) = lhs - rhs;
lhs = y(21);
rhs = exp(y(2))/exp(y(13));
residual(17) = lhs - rhs;
lhs = y(23);
rhs = (y(41)+exp(y(37))*y(43)*y(31))/T(10)+T(23)/T(10)+T(24);
residual(18) = lhs - rhs;
lhs = y(24);
rhs = y(23)-y(18);
residual(19) = lhs - rhs;
lhs = y(26);
rhs = y(31)*T(25)/(1-params(8)+y(30));
residual(20) = lhs - rhs;
lhs = exp(y(29));
rhs = y(31)*(T(12)+y(30))*T(13);
residual(21) = lhs - rhs;
lhs = exp(y(28));
rhs = T(10)*exp(y(29));
residual(22) = lhs - rhs;
lhs = exp(y(25));
rhs = exp(params(14))*exp(y(28)-params(18))^(-params(35))+y(32);
residual(23) = lhs - rhs;
lhs = y(35);
rhs = max(T(26),0);
residual(24) = lhs - rhs;
lhs = y(33);
rhs = 1-y(11);
residual(25) = lhs - rhs;
lhs = y(11);
rhs = y(34)/T(28);
residual(26) = lhs - rhs;
lhs = y(27);
rhs = params(31)*y(3)-x(it_, 1);
residual(27) = lhs - rhs;
lhs = y(30);
rhs = params(32)*y(4)+(1-params(32))*params(6)+x(it_, 2);
residual(28) = lhs - rhs;
lhs = y(31);
rhs = params(33)*y(5)+(1-params(33))*params(30)-x(it_, 3);
residual(29) = lhs - rhs;
lhs = y(32);
rhs = params(34)*y(6)-x(it_, 4);
residual(30) = lhs - rhs;

end
