function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 28);

T(1) = params(1)*y(42)/y(22);
T(2) = params(9)/(1-params(9));
T(3) = (-1)/params(9);
T(4) = 1+T(2)*(y(39)/params(10))^T(3);
T(5) = T(1)*T(4);
T(6) = y(41)+y(44)*y(43)*exp(y(37));
T(7) = 1+T(2)*(y(40)/params(10))^T(3);
T(8) = exp(y(38));
T(9) = y(44)*T(1)*T(7)*(1-params(8))*T(8);
T(10) = exp(y(7));
T(11) = (y(10)/params(10))^T(3);
T(12) = (1-params(8))*T(11);
T(13) = exp(y(1));
T(14) = exp(y(27))*T(13)^params(2);
T(15) = exp(y(15))^(1-params(2));
T(16) = (y(9)/params(10))^T(3);
T(17) = (exp(y(2))+T(13)*y(16)+T(13)*T(10)*y(30)*y(31))*T(16);
T(18) = T(11)*T(13)*T(10)*(1-params(8))*y(31);
T(19) = y(9)/(1-params(9));
T(20) = y(10)/(1-params(9));
T(21) = T(18)*T(20);
T(22) = params(4)*exp(y(15))^params(5)*exp(y(20));
T(23) = T(8)*y(31)*(1-params(8))*(1+T(2)*T(11))/exp(y(12));
T(24) = T(8)*(1-params(8))*1/exp(y(12))*(1-y(31))/T(10);
T(25) = y(30)+(1-params(8))*y(11)^(1/params(9));
T(26) = exp(y(28)-params(18))^(-params(12))-1;
T(27) = sqrt(((1-y(35))/2)^2+y(34)*y(35));
T(28) = (1-y(35))/2+T(27);

end
