function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = IRF_as_policy_unconventional_Wen.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(32, 52);
g1(1,16)=params(6)*T(41)/(1+params(7));
g1(1,21)=(-1);
g1(1,39)=1;
g1(1,48)=(-params(3));
g1(2,40)=(-(T(5)*y(47)*y(46)*exp(y(40))));
g1(2,9)=exp(y(9));
g1(2,41)=(-(T(8)+exp(y(41))*(1-params(10))*T(1)*(1-y(47))));
g1(2,42)=(-(T(6)*T(31)));
g1(2,43)=T(36);
g1(2,44)=(-T(5));
g1(2,23)=(-(T(6)*T(4)*T(46)+exp(y(41))*(1-params(10))*y(47)*T(7)*T(46)+exp(y(41))*(1-params(10))*(1-y(47))*T(46)));
g1(2,45)=(-(T(6)*T(4)*T(47)+exp(y(41))*(1-params(10))*y(47)*T(7)*T(47)+exp(y(41))*(1-params(10))*(1-y(47))*T(47)));
g1(2,46)=(-(T(5)*y(47)*exp(y(40))));
g1(2,47)=(-(T(5)*y(46)*exp(y(40))+exp(y(41))*T(1)*T(7)*(1-params(10))+exp(y(41))*(1-params(10))*(-T(1))));
g1(3,8)=exp(y(8));
g1(3,9)=(-(exp(y(9))*y(12)));
g1(3,12)=(-exp(y(9)));
g1(4,11)=(-((T(13)*T(33)-T(12)*T(33))/(T(13)*T(13))));
g1(4,1)=(-((T(13)*T(39)-T(12)*T(39))/(T(13)*T(13))));
g1(4,31)=(-((-T(12))/(T(13)*T(13))));
g1(4,32)=(-((T(51)-T(12)*T(50))/(T(13)*T(13))));
g1(4,35)=1;
g1(4,7)=(-((T(54)-T(12)*T(53))/(T(13)*T(13))));
g1(5,9)=(-((-exp(y(9)))/T(25)));
g1(5,10)=1;
g1(6,8)=(-((-exp(y(8)))/(exp(y(8))*exp(y(8)))));
g1(6,11)=1;
g1(7,42)=(-T(31));
g1(7,13)=exp(y(13));
g1(7,23)=(-(T(4)*T(46)));
g1(7,45)=(-(T(4)*T(47)));
g1(8,14)=exp(y(14));
g1(8,1)=(-(T(15)*exp(y(28))*T(40)));
g1(8,16)=(-(T(14)*T(42)));
g1(8,28)=(-(T(14)*T(15)));
g1(9,14)=(-(exp(y(14))*params(4)/T(11)));
g1(9,1)=(-((-(T(11)*exp(y(14))*params(4)))/(T(11)*T(11))));
g1(9,17)=1;
g1(10,14)=(-(exp(y(14))*(1-params(4))/exp(y(16))));
g1(10,16)=T(43);
g1(10,18)=1;
g1(11,13)=(-((-exp(y(13)))/(exp(y(13))*exp(y(13)))));
g1(11,19)=1;
g1(12,8)=(-(T(18)+T(11)*exp(y(8))*y(32)*y(31)*T(16)));
g1(12,10)=(-T(28));
g1(12,11)=(-(T(11)*exp(y(8))*(1-params(10))*y(32)*T(32)));
g1(12,1)=(-(T(18)+T(16)*(T(11)*y(17)+T(11)*exp(y(8))*y(32)*y(31))));
g1(12,17)=(-(T(11)*T(16)));
g1(12,20)=exp(y(20));
g1(12,2)=(-(exp(y(2))*T(16)));
g1(12,31)=(-(T(16)*T(11)*exp(y(8))*y(32)));
g1(12,32)=(-(T(16)*T(11)*exp(y(8))*y(31)+T(9)*T(11)*(1-params(10))*exp(y(8))));
g1(13,8)=(-(T(21)+T(19)*T(11)*exp(y(8))*y(32)*y(31)*T(16)));
g1(13,10)=(-(T(19)*T(28)+T(17)*T(29)));
g1(13,11)=T(34);
g1(13,1)=(-(T(21)+(1-params(10))*T(11)+T(19)*T(16)*(T(11)*y(17)+T(11)*exp(y(8))*y(32)*y(31))));
g1(13,15)=exp(y(15));
g1(13,17)=(-(T(19)*T(11)*T(16)));
g1(13,2)=(-(T(19)*exp(y(2))*T(16)));
g1(13,31)=(-(T(19)*T(16)*T(11)*exp(y(8))*y(32)));
g1(13,32)=T(52);
g1(14,16)=(-(exp(y(21))*params(6)*T(44)));
g1(14,18)=1;
g1(14,21)=(-T(22));
g1(15,8)=(-(exp(y(8))*y(32)*y(7)-exp(y(8))*y(38)));
g1(15,13)=(-(exp(y(13))*exp(y(26))));
g1(15,14)=(-exp(y(14)));
g1(15,20)=exp(y(20));
g1(15,21)=exp(y(21));
g1(15,2)=exp(y(2));
g1(15,26)=(-(exp(y(13))*exp(y(26))));
g1(15,32)=(-(exp(y(8))*y(7)));
g1(15,7)=(-(exp(y(8))*y(32)));
g1(15,38)=exp(y(8));
g1(16,21)=(-T(45));
g1(16,23)=1;
g1(17,14)=T(38);
g1(17,22)=1;
g1(17,2)=(-(exp(y(2))/exp(y(14))));
g1(18,9)=(-((-(exp(y(9))*(y(44)+(1-params(10))*exp(y(41)))))/T(25)));
g1(18,41)=(-((1-params(10))*exp(y(41))/exp(y(9))));
g1(18,44)=(-(1/exp(y(9))));
g1(18,24)=1;
g1(19,19)=1;
g1(19,24)=(-1);
g1(19,25)=1;
g1(20,12)=(-(y(32)*T(37)/(1-params(10)+y(31))));
g1(20,27)=1;
g1(20,31)=(-(y(32)*(1-params(10)+y(31)-T(23))/((1-params(10)+y(31))*(1-params(10)+y(31)))));
g1(20,32)=(-(T(23)/(1-params(10)+y(31))));
g1(21,11)=(-(y(32)*T(11)*T(33)));
g1(21,1)=(-(y(32)*T(11)*(T(10)+y(31))));
g1(21,30)=exp(y(30));
g1(21,31)=(-(y(32)*T(11)));
g1(21,32)=(-(T(11)*(T(10)+y(31))));
g1(22,8)=(-(exp(y(8))*exp(y(30))));
g1(22,29)=exp(y(29));
g1(22,30)=(-(exp(y(8))*exp(y(30))));
g1(23,26)=exp(y(26));
g1(23,29)=(-(exp(params(16))*T(48)));
g1(23,33)=(-1);
g1(24,29)=(-T(49));
g1(24,36)=1;
g1(25,30)=(-(exp(y(30))*y(36)));
g1(25,36)=(-exp(y(30)));
g1(25,38)=1;
g1(26,12)=(-(exp(y(30))*y(36)));
g1(26,30)=(-(exp(y(30))*y(12)*y(36)));
g1(26,32)=y(7);
g1(26,36)=(-(y(12)*exp(y(30))));
g1(26,7)=(-(1-y(32)));
g1(26,37)=1;
g1(27,12)=1;
g1(27,34)=1;
g1(28,12)=1;
g1(28,35)=(-1);
g1(29,3)=(-params(32));
g1(29,28)=1;
g1(29,49)=1;
g1(30,4)=(-params(33));
g1(30,31)=1;
g1(30,50)=(-1);
g1(31,5)=(-params(34));
g1(31,32)=1;
g1(31,51)=1;
g1(32,6)=(-params(35));
g1(32,33)=1;
g1(32,52)=1;

end
