function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 54);

T = IRF_as_policy_unconventional_Wen.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(25) = exp(y(9))*exp(y(9));
T(26) = 1/params(12);
T(27) = T(26)*getPowerDeriv(y(10)/params(12),T(3),1);
T(28) = (exp(y(2))+T(11)*y(17)+T(11)*exp(y(8))*y(32)*y(31))*T(27);
T(29) = 1/(1-params(11));
T(30) = T(2)*T(26)*getPowerDeriv(y(42)/params(12),T(3),1);
T(31) = T(1)*T(30);
T(32) = T(26)*getPowerDeriv(y(11)/params(12),T(3),1);
T(33) = (1-params(10))*T(32);
T(34) = (-(T(20)*T(11)*exp(y(8))*(1-params(10))*y(32)*T(32)+T(18)*T(29)));
T(35) = T(2)*T(26)*getPowerDeriv(y(43)/params(12),T(3),1);
T(36) = (-(exp(y(41))*(1-params(10))*y(47)*T(1)*T(35)));
T(37) = (1-params(10))*getPowerDeriv(y(12),1/params(11),1);
T(38) = (-((-(exp(y(14))*exp(y(2))))/(exp(y(14))*exp(y(14)))));
T(39) = (-(y(32)*y(7)*T(11)))/(T(11)*T(11));
T(40) = T(11)*getPowerDeriv(T(11),params(4),1);
T(41) = exp(y(16))*getPowerDeriv(exp(y(16)),1+params(7),1);
T(42) = exp(y(16))*getPowerDeriv(exp(y(16)),1-params(4),1);
T(43) = (-((-(exp(y(16))*exp(y(14))*(1-params(4))))/(exp(y(16))*exp(y(16)))));
T(44) = exp(y(16))*getPowerDeriv(exp(y(16)),params(7),1);
T(45) = exp(y(21))*getPowerDeriv(exp(y(21)),(-1),1);
T(46) = params(3)*(-y(45))/(y(23)*y(23));
T(47) = params(3)*1/y(23);
T(48) = T(24)*getPowerDeriv(T(24),(-params(36)),1);
T(49) = T(24)*getPowerDeriv(T(24),(-params(14)),1);
T(50) = y(7)/T(11);
T(51) = T(13)*T(50);
T(52) = (-(T(19)*T(16)*T(11)*exp(y(8))*y(31)+T(20)*T(9)*T(11)*(1-params(10))*exp(y(8))));
T(53) = y(32)/T(11);
T(54) = T(13)*T(53);

end
