function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 61);

T = IRF_as_policy_unconventional_Wen.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(55) = T(1)*T(2)*T(26)*T(26)*getPowerDeriv(y(42)/params(12),T(3),2);
T(56) = params(3)*(-((-y(45))*(y(23)+y(23))))/(y(23)*y(23)*y(23)*y(23));
T(57) = T(26)*T(26)*getPowerDeriv(y(11)/params(12),T(3),2);
T(58) = (1-params(10))*T(57);
T(59) = T(13)*T(13)*T(13)*T(13);
T(60) = ((-(y(32)*y(7)*T(11)))*T(11)*T(11)-(-(y(32)*y(7)*T(11)))*(T(11)*T(11)+T(11)*T(11)))/(T(11)*T(11)*T(11)*T(11));
T(61) = (exp(y(2))+T(11)*y(17)+T(11)*exp(y(8))*y(32)*y(31))*T(26)*T(26)*getPowerDeriv(y(10)/params(12),T(3),2);

end
