function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = IRF_as_policy_unconventional_Wen.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(32, 1);
lhs = y(39);
rhs = y(21)-params(6)*exp(y(16))^(1+params(7))/(1+params(7))+params(3)*y(48);
residual(1) = lhs - rhs;
lhs = exp(y(9));
rhs = T(5)*T(6)+T(8)+exp(y(41))*(1-params(10))*T(1)*(1-y(47));
residual(2) = lhs - rhs;
lhs = exp(y(8));
rhs = exp(y(9))*y(12);
residual(3) = lhs - rhs;
lhs = y(35);
rhs = T(12)/T(13);
residual(4) = lhs - rhs;
lhs = y(10);
rhs = 1/exp(y(9));
residual(5) = lhs - rhs;
lhs = y(11);
rhs = 1/exp(y(8));
residual(6) = lhs - rhs;
lhs = exp(y(13));
rhs = T(5);
residual(7) = lhs - rhs;
lhs = exp(y(14));
rhs = T(14)*T(15);
residual(8) = lhs - rhs;
lhs = y(17);
rhs = exp(y(14))*params(4)/T(11);
residual(9) = lhs - rhs;
lhs = y(18);
rhs = exp(y(14))*(1-params(4))/exp(y(16));
residual(10) = lhs - rhs;
lhs = y(19);
rhs = 1/exp(y(13));
residual(11) = lhs - rhs;
lhs = exp(y(20));
rhs = T(17)+T(18);
residual(12) = lhs - rhs;
lhs = exp(y(15));
rhs = (1-params(10))*T(11)+T(17)*T(19)+T(21);
residual(13) = lhs - rhs;
lhs = y(18);
rhs = T(22);
residual(14) = lhs - rhs;
lhs = exp(y(20))+exp(y(21));
rhs = exp(y(14))+exp(y(13))*exp(y(26))-exp(y(2))+exp(y(8))*y(32)*y(7)-exp(y(8))*y(38);
residual(15) = lhs - rhs;
lhs = y(23);
rhs = exp(y(21))^(-1);
residual(16) = lhs - rhs;
lhs = y(22);
rhs = exp(y(2))/exp(y(14));
residual(17) = lhs - rhs;
lhs = y(24);
rhs = (y(44)+(1-params(10))*exp(y(41)))/exp(y(9));
residual(18) = lhs - rhs;
lhs = y(25);
rhs = y(24)-y(19);
residual(19) = lhs - rhs;
lhs = y(27);
rhs = y(32)*T(23)/(1-params(10)+y(31));
residual(20) = lhs - rhs;
lhs = exp(y(30));
rhs = y(32)*T(11)*(T(10)+y(31));
residual(21) = lhs - rhs;
lhs = exp(y(29));
rhs = exp(y(8))*exp(y(30));
residual(22) = lhs - rhs;
lhs = exp(y(26));
rhs = exp(params(16))*T(24)^(-params(36))+y(33);
residual(23) = lhs - rhs;
lhs = y(36);
rhs = T(24)^(-params(14))-1;
residual(24) = lhs - rhs;
lhs = y(38);
rhs = exp(y(30))*y(36);
residual(25) = lhs - rhs;
lhs = y(37);
rhs = y(7)*(1-y(32))+exp(y(30))*y(12)*y(36);
residual(26) = lhs - rhs;
lhs = y(34);
rhs = 1-y(12);
residual(27) = lhs - rhs;
lhs = y(12);
rhs = y(35);
residual(28) = lhs - rhs;
lhs = y(28);
rhs = params(32)*y(3)-x(it_, 1);
residual(29) = lhs - rhs;
lhs = y(31);
rhs = params(33)*y(4)+(1-params(33))*params(8)+x(it_, 2);
residual(30) = lhs - rhs;
lhs = y(32);
rhs = params(34)*y(5)+(1-params(34))*params(31)-x(it_, 3);
residual(31) = lhs - rhs;
lhs = y(33);
rhs = params(35)*y(6)-x(it_, 4);
residual(32) = lhs - rhs;

end
