function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 24);

T(1) = params(3)*y(45)/y(23);
T(2) = params(11)/(1-params(11));
T(3) = (-1)/params(11);
T(4) = 1+T(2)*(y(42)/params(12))^T(3);
T(5) = T(1)*T(4);
T(6) = y(44)+y(47)*y(46)*exp(y(40));
T(7) = 1+T(2)*(y(43)/params(12))^T(3);
T(8) = y(47)*T(1)*T(7)*(1-params(10))*exp(y(41));
T(9) = (y(11)/params(12))^T(3);
T(10) = (1-params(10))*T(9);
T(11) = exp(y(1));
T(12) = T(10)+y(32)*y(7)/T(11);
T(13) = y(32)*y(7)/T(11)+T(10)+y(31);
T(14) = exp(y(28))*T(11)^params(4);
T(15) = exp(y(16))^(1-params(4));
T(16) = (y(10)/params(12))^T(3);
T(17) = (exp(y(2))+T(11)*y(17)+T(11)*exp(y(8))*y(32)*y(31))*T(16);
T(18) = T(9)*T(11)*exp(y(8))*(1-params(10))*y(32);
T(19) = y(10)/(1-params(11));
T(20) = y(11)/(1-params(11));
T(21) = T(18)*T(20);
T(22) = params(6)*exp(y(16))^params(7)*exp(y(21));
T(23) = y(31)+(1-params(10))*y(12)^(1/params(11));
T(24) = exp(y(29))/exp(params(20));

end
