function residual = static_resid(T, y, x, params, T_flag)
% function residual = static_resid(T, y, x, params, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T         [#temp variables by 1]  double   vector of temporary terms to be filled by function
%   y         [M_.endo_nbr by 1]      double   vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1]       double   vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1]     double   vector of parameter values in declaration order
%                                              to evaluate the model
%   T_flag    boolean                 boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = IRF_as_policy_unconventional_Wen.static_resid_tt(T, y, x, params);
end
residual = zeros(32, 1);
lhs = y(32);
rhs = y(14)-params(6)*exp(y(9))^(1+params(7))/(1+params(7))+y(32)*params(3);
residual(1) = lhs - rhs;
lhs = exp(y(2));
rhs = T(4)*(y(10)+y(25)*y(24)*exp(y(1)))+T(6)+exp(y(2))*(1-params(10))*params(3)*(1-y(25));
residual(2) = lhs - rhs;
lhs = exp(y(1));
rhs = exp(y(2))*y(5);
residual(3) = lhs - rhs;
lhs = y(28);
rhs = T(8)/T(9);
residual(4) = lhs - rhs;
lhs = y(3);
rhs = 1/exp(y(2));
residual(5) = lhs - rhs;
lhs = y(4);
rhs = 1/exp(y(1));
residual(6) = lhs - rhs;
lhs = exp(y(6));
rhs = T(4);
residual(7) = lhs - rhs;
lhs = exp(y(7));
rhs = T(10)*T(11);
residual(8) = lhs - rhs;
lhs = y(10);
rhs = exp(y(7))*params(4)/T(7);
residual(9) = lhs - rhs;
lhs = y(11);
rhs = exp(y(7))*(1-params(4))/exp(y(9));
residual(10) = lhs - rhs;
lhs = y(12);
rhs = 1/exp(y(6));
residual(11) = lhs - rhs;
lhs = exp(y(13));
rhs = T(12)+T(13);
residual(12) = lhs - rhs;
lhs = T(7);
rhs = (1-params(10))*T(7)+T(12)*T(14)+T(15);
residual(13) = lhs - rhs;
lhs = y(11);
rhs = T(16);
residual(14) = lhs - rhs;
lhs = exp(y(13))+exp(y(14));
rhs = exp(y(7))+exp(y(6))*exp(y(19))-exp(y(19))+exp(y(1))*y(25)*y(30)-exp(y(1))*y(31);
residual(15) = lhs - rhs;
lhs = y(16);
rhs = exp(y(14))^(-1);
residual(16) = lhs - rhs;
lhs = y(15);
rhs = exp(y(19))/exp(y(7));
residual(17) = lhs - rhs;
lhs = y(17);
rhs = (y(10)+exp(y(2))*(1-params(10)))/exp(y(2));
residual(18) = lhs - rhs;
lhs = y(18);
rhs = y(17)-y(12);
residual(19) = lhs - rhs;
lhs = y(20);
rhs = y(25)*T(17)/(y(24)+1-params(10));
residual(20) = lhs - rhs;
lhs = exp(y(23));
rhs = y(25)*T(7)*(y(24)+T(5)*(1-params(10)));
residual(21) = lhs - rhs;
lhs = exp(y(22));
rhs = exp(y(1))*exp(y(23));
residual(22) = lhs - rhs;
lhs = exp(y(19));
rhs = exp(params(16))*T(18)^(-params(36))+y(26);
residual(23) = lhs - rhs;
lhs = y(29);
rhs = T(18)^(-params(14))-1;
residual(24) = lhs - rhs;
lhs = y(31);
rhs = exp(y(23))*y(29);
residual(25) = lhs - rhs;
lhs = y(30);
rhs = (1-y(25))*y(30)+exp(y(23))*y(5)*y(29);
residual(26) = lhs - rhs;
lhs = y(27);
rhs = 1-y(5);
residual(27) = lhs - rhs;
lhs = y(5);
rhs = y(28);
residual(28) = lhs - rhs;
lhs = y(21);
rhs = y(21)*params(32)-x(1);
residual(29) = lhs - rhs;
lhs = y(24);
rhs = y(24)*params(33)+(1-params(33))*params(8)+x(2);
residual(30) = lhs - rhs;
lhs = y(25);
rhs = y(25)*params(34)+(1-params(34))*params(31)-x(3);
residual(31) = lhs - rhs;
lhs = y(26);
rhs = y(26)*params(35)-x(4);
residual(32) = lhs - rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
end
