
% dynare IRF_as_no_policy_old_calibration.mod

% update with decomposition of LIQUIDITY and QUALITY


% The Scenario with Adverse Selection

% shocks to:
% (1) aggregate productivity (At)
% (2) uncertainty (asset quality) (ppit)
% (3) resaleability shock (omgt)

% to generate IRF after shocks to ppit


var qk Phi_k eps1 eps2 theta  qb  Y  K   N   rk   w   Rb   I   C   BY    Lambda  Rk    spread   omegat   At    L     S   ppit  omgt  haircut theta_original lambda  Phi_k_tilde l_ppi l_omega   V;

%  [ 1    2    3   4     5     6  7  8   9   10  11   12  13   14  15      16    17      18       19     20    21    22   23     24     25         26         27        28       29      30      31 ]





% oo_.steady_state()

% qk: price of capital asset
% Phi_K: shadow value of high quality assets
% eps1: cut-off value for investment
% eps2: cut-off value for selling assets
% theta: proportion of high-quality assets in markets
% qb: bond price
% Y: output
% K: capital
% N: labor
% rk: marginal product of capital
% w: wage rate
% Rb: bond return
% I: investment
% C: consumption
% BY: B/Y
% Lambda: marginal utility of consumption
% Rk: asset return
% Bt: B_{t+1} in the model, the supply of government bond;
% A_t: aggregate productivity

% V: welfare of the representative household
% L: private liquidity
% S: total supply of private assets
% gammat: (1-ppit)*gammat = 1-delta; 



%% SHOCKS

varexo eA eP eO;

% shocks to:
% (1) aggregate productivity (At)
% (2) uncertainty (asset quality) (ppit)
% (3) resaleability shock (omgt)
% (4) fiscal shock (for B_t)


%% PARAMETERS

parameters beta alpha A_ss chi ksi ppi gamma delta eta eps_min S_ss pphi theta_ss B_ss eps1_ss qk_ss qb_ss L_ss Rb_ss rk_ss K_ss N_ss Y_ss w_ss I_ss C_ss Rk_ss Lambda_ss omega_bar rho_a rho_ppi rho_omega rho_b phi stdA stdP stdO stdB Phi_k_tilde_ss l_omega_ss l_ppi_ss;

% beta: discount factor
% alpha: share of capital revenue
% sigma: coefficient of risk aversion
% A_ss: aggregate productivity shock
% chi: disutility coefficient of labor supply
% ksi: inverse Frisch elasticity
% ppi: probability of being lemon
% gamma: discount of non-lemon assets
% delta: effective depreciation rate of capital
% eta: coefficient of the Pareto distribution
% eps_min: lower bound of the distribution of investment efficiency (epsilon)
% rho: persistence coefficient of the AR(1) process of the shock
% B: log of the government bond;



% load data_pam
load data_pam_haoning_robust

%pam = [beta delta alpha A omega_bar chi ksi eta sigma eps_min ppi gamma B rho_a rho_ppi rho_omega rho_b phi stdA stdP stdO stdB pphi];
%it seems that under log utility, the parameter sigma is useless, and the parameter 1/eta corresponds to parameter sigma in the paper

beta = pam(1);
delta = pam(2);
alpha = pam(3);
A_ss = log(pam(4));
omega_bar = pam(5);
chi = pam(6);
ksi = pam(7);
eta = pam(8);
sigma = pam(9);
eps_min = pam(10);
ppi = pam(11);
gamma = pam(12);
B_ss = log(pam(13));
%rho_a = pam(14);
rho_a = 0.9;
rho_ppi = pam(15);
rho_omega = pam(16);
rho_b = pam(17);
phi = pam(18);  % the elasticity of B_{t+1} to private liquidity (L_pri = qk*S, where S denotes trading volume)
stdA = pam(19);
stdP = stdA;
stdO = stdA;
stdB = pam(22);
pphi = pam(23);


load data_steady_state_as_haoning_robust


qk_ss = log(steady_state_as(1));
Phi_k_ss = log(steady_state_as(2));
eps1_ss = steady_state_as(3);
eps2_ss = steady_state_as(4);
theta_ss = steady_state_as(5);
qb_ss = log(steady_state_as(6));
Rb_ss = steady_state_as(7);
rk_ss = steady_state_as(8);
K_ss = log(steady_state_as(9));
N_ss = log(steady_state_as(10));
Y_ss = log(steady_state_as(11));
w_ss = steady_state_as(12);
I_ss = log(steady_state_as(13));
C_ss = log(steady_state_as(14));
omegat_ss = steady_state_as(15);
BY_ss = steady_state_as(16);
Rk_ss = steady_state_as(17);

Phi_k_tilde_ss = log(beta*(1+(eta/(1-eta))*((eps1_ss/eps_min)^(-1/eta)))*(rk_ss+(1-delta)*exp(Phi_k_ss)));

l_ppi_ss = 100*Rb_ss*beta*(1-theta_ss^(1/eta))*(eta/(1-eta))*((eps1_ss/eps_min)^(-1/eta))*(1-delta)-100*Rb_ss*beta*(1+(eta/(1-eta))*((eps1_ss/eps_min)^(-1/eta)))*ppi*exp(qk_ss-Phi_k_ss);
l_omega_ss = 100*Rb_ss*beta*(1+(eta/(1-eta))*((eps1_ss/eps_min)^(-1/eta)))*ppi*(1-omega_bar)*exp(qk_ss-Phi_k_ss)+100*Rb_ss*beta*((eta/(1-eta))*((eps1_ss/eps_min)^(-1/eta)))*(1-delta)*(1-omega_bar)-100*Rb_ss*beta*(1-theta_ss^(1/eta))*(eta/(1-eta))*((eps1_ss/eps_min)^(-1/eta))*(1-omega_bar)*(1-delta);


S_ss = (ppi+(1-delta)*((eps2_ss/eps_min)^(-1/eta)))*exp(K_ss);
L_ss = qk_ss+S_ss; % log of (Private Liquidity)
Lambda_ss = 1/exp(C_ss);
spread_ss = Rk_ss-Rb_ss;
V_ss = (C_ss-chi*((exp(N_ss))^(1+ksi))/(1+ksi))/(1-beta);
haircut_ss = 1-theta_ss;


% omegat_ss = (ppi+(1-delta)*((eps2_ss/eps_min)^(-1/eta)))*omega_bar;

model;


% discount factor: beta*(Lambda(+1)/Lambda)

% (1+(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)))

% (1-delta)*((eps2/eps_min)^(-1/eta))

% 1. Utility

V = C-chi*((exp(N))^(1+ksi))/(1+ksi)+beta*V(+1);

% 2. Euler equation for the Shadow Value of High-quality Asset Phi_k

exp(Phi_k) = beta*(Lambda(+1)/Lambda)*(1+(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)))*(rk(+1)+exp(omgt(+1))*exp(ppit(+1))*exp(qk(+1)))+beta*(Lambda(+1)/Lambda)*(1+(eta/(1-eta))*((eps2(+1)/eps_min)^(-1/eta)))*exp(omgt(+1))*(1-delta)*exp(Phi_k(+1))+beta*(Lambda(+1)/Lambda)*(1-exp(omgt(+1)))*(1-delta)*exp(Phi_k(+1));

% 3. Relationship between Asset Price qk and Its Shadow Value Phi_k

exp(qk) = theta*exp(Phi_k);

% 4. theta_original

theta_original = ((1-delta)*((eps2/eps_min)^(-1/eta)))/(((1-delta)*((eps2/eps_min)^(-1/eta)))+exp(ppit));

% 5. Cut-off Value for Investment

eps1 = 1/(exp(Phi_k));

% 6. Cut-off Value for Selling High-quality Asset

eps2 = 1/(exp(qk));

% 7. Bond Price qb

exp(qb) = beta*(Lambda(+1)/Lambda)*(1+(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)));

% 8. Aggregate Ouput Y

exp(Y) = exp(At)*(exp(K(-1))^alpha)*(exp(N)^(1-alpha));

% 9. Marginal Product of Capital (MPK)

rk = alpha*exp(Y)/exp(K(-1));

% 10. Wage Rate (MPL)

w = (1-alpha)*exp(Y)/exp(N);

% 11. Bond Yield

Rb = 1/exp(qb);

% 12. Aggregate Investment

exp(I) = (exp(B_ss)+rk*exp(K(-1))+exp(omgt)*exp(ppit)*exp(qk)*exp(K(-1)))*((eps1/eps_min)^(-1/eta))+(1-delta)*exp(omgt)*exp(qk)*exp(K(-1))*((eps2/eps_min)^(-1/eta));

% 13. Law of Motion for Aggregate Capital

exp(K) = (1-delta)*exp(K(-1))+(exp(B_ss)+rk*exp(K(-1))+exp(omgt)*exp(ppit)*exp(qk)*exp(K(-1)))*((eps1/eps_min)^(-1/eta))*(eps1/(1-eta))+ (1-delta)*exp(omgt)*exp(qk)*exp(K(-1))*((eps2/eps_min)^(-1/eta))*(eps2/(1-eta));

% 14. FOC for labor supply

w = chi*((exp(N))^ksi)*exp(C);

% 15. Resources Constraint

exp(C)+exp(I) = exp(Y)+exp(qb)*exp(B_ss)-exp(B_ss)-(1-theta)*lambda*exp(L);
% here (1-theta)*lambda*exp(L) denotes the government purchase of bad asset under unconventional policy, under the parameter set, pphi=0 so this term is zero

% 16. Lanrangean Multiplier

Lambda = (exp(C))^(-1);

% 17. Debt-to-GDP Ratio

BY = exp(B_ss)/exp(Y);

% 18. Return of Holding (Risky) Assets
%Rk = (rk(+1)+(ppi+1-delta)*exp(qk(+1))*(omegat+(1-omegat)/theta))/exp(qk);
%Rk = Rb/theta;
%Rk = (rk(+1)+omgt*exp(ppit(+1))*exp(qk(+1)))/exp(qk)+((1+(eta/(1-eta))*((eps2/eps_min)^(-1/eta)))/exp(qb))*(1-delta)*omgt*exp(Phi_k(+1))/exp(qk)+(1/exp(qb))*(1-delta)*(1-omgt)*exp(Phi_k(+1))/exp(qk);
Rk = (rk(+1)+(1-delta)*exp(Phi_k(+1)))/exp(Phi_k);

% 19. Liquidity Premium

spread = Rk-Rb;

% 20. Endogenous Resaleability

omegat = ((exp(ppit)+(1-delta)*(theta^(1/eta)))/(exp(ppit)+(1-delta)))*exp(omgt);


% 21. Totoal Supply of Private Assets; Trading Volume

exp(S) = (exp(ppit)+(1-delta)*((eps2/eps_min)^(-1/eta)))*exp(K(-1));


% 22. Private Liquidity

exp(L) = exp(qk)*exp(S);


% 23. Liquidity Policy (Conventional)
%exp(B_ss) = exp(B_ss)*((exp(L)/exp(L_ss))^(-1*phi))+bbt;


% with phi>=0, i.e., leaning against the wind

% alternative setup: 
% (1) exp(B_ss) = exp(B_ss)*((exp(qk)/exp(qk_ss))^phi);
% (2) exp(Lpub) = exp(Lpub_ss)*((exp(Lpri)/exp(Lpri_ss))^(-1*phi_q));
%exp(B_ss) = exp(B_ss)*((exp(qk)/exp(qk_ss))^(-1*phi))+bbt;


% 24. Liquidity Policy (Unconventional)
lambda = (exp(L)/exp(L_ss))^(-1*pphi)-1;


% 25: Haircut
haircut = 1-theta;

% 26: theta and theta-original

theta = theta_original/((1-lambda)/2+sqrt(((1-lambda)/2)^2+lambda*theta_original));

% 27 - 30: Shocks

At = rho_a*At(-1)-eA;  % TFP shock
ppit = rho_ppi*ppit(-1)+(1-rho_ppi)*log(ppi)+eP;   % uncertainty shock to asset quality (mean preserving spread)
omgt = rho_omega*omgt(-1)+(1-rho_omega)*log(omega_bar)-eO;  % resaleability (redeployability) shock 
%bbt = rho_b*bB_ss-eB;  % fiscal shock

% 31: Phi_k_tilde: Asset Pricing under perfect case, when omgt=1 and ppit = 0
exp(Phi_k_tilde) = beta*(Lambda(+1)/Lambda)*(1+(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)))*(rk(+1)+(1-delta)*exp(Phi_k(+1)));

% 32: qualiaty (safety) premium
l_ppi = 100*Rb*beta*(Lambda(+1)/Lambda)*(1-(theta(+1))^(1/eta))*(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta))*(1-delta)*exp(Phi_k(+1)-Phi_k)-100*Rb*beta*(Lambda(+1)/Lambda)*(1+(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)))*exp(ppit(+1))*exp(qk(+1)-Phi_k);
%l_ppi = (Phi_k_tilde-Phi_k-l_omega)*100;

% 33: resaleability (liquidity) premium
l_omega = 100*Rb*beta*(Lambda(+1)/Lambda)*(1+(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)))*exp(ppit(+1))*(1-exp(omgt(+1)))*exp(qk(+1)-Phi_k)+100*Rb*beta*(Lambda(+1)/Lambda)*((eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)))*(1-delta)*(1-exp(omgt(+1)))*exp(Phi_k(+1)-Phi_k)-100*Rb*beta*(Lambda(+1)/Lambda)*(1-(theta(+1))^(1/eta))*(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta))*(1-exp(omgt(+1)))*(1-delta)*exp(Phi_k(+1)-Phi_k);

%rb = (Rb-1)*100;


end;




% % 32: qualiaty (safety) premium
% l_ppi = beta*(Lambda(+1)/Lambda)*(1-(theta(+1))^(1/eta))*(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta))*(1-delta)*omgt(+1)*exp(Phi_k(+1)-Phi_k_tilde)-beta*(Lambda(+1)/Lambda)*(1+(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)))*ppit(+1)*exp(qk(+1)-Phi_k_tilde(+1));
% 
% 
% % 33: resaleability (liquidity) premium
% l_omega = beta*(Lambda(+1)/Lambda)*((eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)))*(1-delta)*(1-omgt(+1))*exp(Phi_k(+1)-Phi_k_tilde);





initval;

%var qk Phi_k eps1 eps2 theta  qb  Y  K   N   rk   w   Rb   I   C   BY    Lambda  Rk     spread   Bt   omegat  At    L     S  ppit  omgt   bbt  haircut theta_original lambda  V ;

%%  [ 1    2    3   4     5     6  7  8   9   10  11   12  13   14  15      16    17      18      19     20    21    22   23   24    25    26     27          28         29    30]

qk = qk_ss;
Phi_k = Phi_k_ss;
eps1 = eps1_ss;
eps2 = eps2_ss;
theta = theta_ss;
qb = qb_ss;
Y = Y_ss;
K = K_ss;
N = N_ss;
rk = rk_ss;
w = w_ss;
Rb = Rb_ss;
I = I_ss;
C = C_ss;
BY = BY_ss;
Lambda = Lambda_ss;
Rk = Rk_ss;
spread = spread_ss;
%Bt = B_ss;
omegat = omegat_ss;
At = A_ss;
V = V_ss;
L = L_ss;
S = S_ss;
ppit = log(ppi);
omgt = log(omega_bar);
haircut = haircut_ss;
theta_original = theta_ss;
Phi_k_tilde = Phi_k_tilde_ss;
l_omega = l_omega_ss;
l_ppi = l_ppi_ss;
lambda = 0;
%bbt = 0;
eA = 0;
eP = 0;
eO = 0;
%eB = 0;

end;



shocks;

% var eA; stderr stdA;
var eP; stderr stdP;
% var eO; stderr stdO;
%var eB; stderr stdB;


end;


steady (maxit = 100, solve_algo = 2);

check;

%stoch_simul(noprint,nograph,periods=0);
%stoch_simul(nograph, periods=0);

%stoch_simul(periods=0,order=1,hp_filter=1600,nograph,irf=20) K Y l_ppi l_omega Rb;
stoch_simul(periods=0,order=1,hp_filter=1600,nograph,irf=20);
impluse_as_eP =[I_eP K_eP Y_eP C_eP qk_eP eps1_eP eps2_eP Rb_eP omegat_eP spread_eP S_eP haircut_eP N_eP Phi_k_tilde_eP l_ppi_eP l_omega_eP];
save data_impluse_as_eP_robust_haoning impluse_as_eP;


%delete *dynamic.m
delete *variables.m
delete *static.m
delete *asv
%delete *log