
% dynare IRF_as_policy_unconventional_2.mod


% The Scenario with Adverse Selection

% shocks to:
% (1) aggregate productivity (At)
% (2) uncertainty (asset quality) (ppit)
% (3) resaleability shock (omgt)
% (4) fiscal shock (for B_t)


var qk Phi_k eps1 eps2 theta  qb  Y  K   N   rk   w   Rb   I   C   BY    Lambda  Rk     spread   Bt   omegat  At    L     S  ppit  omgt   bbt  haircut theta_original lambda  Kg  Ig  V ;

%  [ 1    2    3   4     5     6  7  8   9   10  11   12  13   14  15      16    17      18      19     20    21    22   23   24    25    26     27          28         29    30  31  32]

% oo_.steady_state()


% qk: price of capital asset
% Phi_K: shadow value of high quality assets
% eps1: cut-off value for investment
% eps2: cut-off value for selling assets
% theta: proportion of high-quality assets in markets
% qb: bond price
% Y: output
% K: capital
% N: labor
% rk: marginal product of capital
% w: wage rate
% Rb: bond return
% I: investment
% C: consumption
% BY: B/Y
% Lambda: marginal utility of consumption
% Rk: asset return
% Bt: B_{t+1} in the model, the supply of government bond;
% A_t: aggregate productivity

% V: welfare of the representative household
% L: private liquidity
% S: total supply of private assets
% gammat: (1-ppit)*gammat = 1-delta; 



%% SHOCKS

varexo eA eP eO eB;

% shocks to:
% (1) aggregate productivity (At)
% (2) uncertainty (asset quality) (ppit)
% (3) resaleability shock (omgt)
% (4) fiscal shock (for B_t)


%% PARAMETERS

parameters Kg_ss omegat_ss beta alpha A_ss chi ksi ppi gamma delta eta eps_min S_ss pphi theta_ss B_ss eps1_ss qk_ss qb_ss L_ss Rb_ss rk_ss K_ss N_ss Y_ss w_ss I_ss C_ss Rk_ss Lambda_ss omega_bar rho_a rho_ppi rho_omega rho_b phi stdA stdP stdO stdB;

% beta: discount factor
% alpha: share of capital revenue
% sigma: coefficient of risk aversion
% A_ss: aggregate productivity shock
% chi: disutility coefficient of labor supply
% ksi: inverse Frisch elasticity
% ppi: probability of being lemon
% gamma: discount of non-lemon assets
% delta: effective depreciation rate of capital
% eta: coefficient of the Pareto distribution
% eps_min: lower bound of the distribution of investment efficiency (epsilon)
% rho: persistence coefficient of the AR(1) process of the shock
% B: log of the government bond;


Kg_ss = 0.01;

load data_pam_policy_unconventional

%pam_policy_unconventional = [beta delta alpha A omega_bar chi ksi eta sigma eps_min ppi gamma B rho_a rho_ppi rho_omega rho_b phi stdA stdP stdO stdB pphi];
 
beta = pam_policy_unconventional(1);
delta = pam_policy_unconventional(2);
alpha = pam_policy_unconventional(3);
A_ss = log(pam_policy_unconventional(4));
omega_bar = pam_policy_unconventional(5);
chi = pam_policy_unconventional(6);
ksi = pam_policy_unconventional(7);
eta = pam_policy_unconventional(8);
sigma = pam_policy_unconventional(9);
eps_min = pam_policy_unconventional(10);
ppi = pam_policy_unconventional(11);
gamma = pam_policy_unconventional(12);
B_ss = log(pam_policy_unconventional(13));
rho_a = pam_policy_unconventional(14);
rho_ppi = pam_policy_unconventional(15);
rho_omega = pam_policy_unconventional(16);
rho_b = pam_policy_unconventional(17);
phi = pam_policy_unconventional(18);  % the elasticity of B_{t+1} to private liquidity (L_pri = qk*S, where S denotes trading volume)
stdA = pam_policy_unconventional(19);
stdP = pam_policy_unconventional(20);
stdO = pam_policy_unconventional(21);
stdB = pam_policy_unconventional(22);
pphi = pam_policy_unconventional(23);



% % calibration values
% 
% beta = 0.9855;
% delta = 0.025;
% alpha = 0.36;
% A = 1;
% omega_bar = 0.82;
% chi = 6.43;
% ksi = 0.5;
% eta = 0.14; 
% sigma = 1/eta;
% eps_min = 1-eta;
% ppi = 0.003;
% gamma = (1-delta)/(1-ppi);
% B = 0.64;
% rho_a = 0.9;  % persistence coefficient of the AR(1) process the TFP shock
% rho_ppi = 0.9;  % persistence coefficient of the AR(1) process the asset-quality shock


load data_steady_state_as_policy

% steady_state_as_policy = [qk_ss Phi_k_ss eps1_ss eps2_ss theta_ss qb_ss R_ss rk_ss K_ss N_ss Y_ss w_ss I_ss C_ss omega_ss BY_ss Rk_ss];
% save data_steady_state_as_policy steady_state_as_policy;

qk_ss = log(steady_state_as_policy(1));
Phi_k_ss = log(steady_state_as_policy(2));
eps1_ss = steady_state_as_policy(3);
eps2_ss = steady_state_as_policy(4);
theta_ss = steady_state_as_policy(5);
qb_ss = log(steady_state_as_policy(6));
Rb_ss = steady_state_as_policy(7);
rk_ss = steady_state_as_policy(8);
K_ss = log(steady_state_as_policy(9));
N_ss = log(steady_state_as_policy(10));
Y_ss = log(steady_state_as_policy(11));
w_ss = steady_state_as_policy(12);
I_ss = log(steady_state_as_policy(13));
C_ss = log(steady_state_as_policy(14));
omegat_ss = steady_state_as_policy(15);
BY_ss = steady_state_as_policy(16);
Rk_ss = steady_state_as_policy(17);

S_ss = log((ppi+(1-delta)*((eps2_ss/eps_min)^(-1/eta)))*exp(K_ss)*omega_bar);
L_ss = qk_ss+S_ss; % log of (Private Liquidity)
Lambda_ss = 1/exp(C_ss);
spread_ss = Rk_ss-Rb_ss;
V_ss = (C_ss-chi*((exp(N_ss))^(1+ksi))/(1+ksi))/(1-beta);
haircut_ss = 1-theta_ss;
Ig_ss = omega_bar*Kg_ss/theta_ss;




model;

% discount factor: beta*(Lambda(+1)/Lambda)

% (1+(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)))

% (1-delta)*((eps2/eps_min)^(-1/eta))



% 1. Utility

V = C-chi*((exp(N))^(1+ksi))/(1+ksi)+beta*V(+1);

% 2. Euler equation for the Shadow Value of High-quality Asset Phi_k

exp(Phi_k) = beta*(Lambda(+1)/Lambda)*(1+(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)))*(rk(+1)+omgt(+1)*ppit(+1)*exp(qk(+1)))+beta*(Lambda(+1)/Lambda)*(1+(eta/(1-eta))*((eps2(+1)/eps_min)^(-1/eta)))*omgt(+1)*(1-delta)*exp(Phi_k(+1))+beta*(Lambda(+1)/Lambda)*(1-omgt(+1))*(1-delta)*exp(Phi_k(+1));

% 3. Relationship between Asset Price qk and Its Shadow Value Phi_k

exp(qk) = theta*exp(Phi_k);

% 4. theta_original

theta_original = ((1-delta)*((eps2/eps_min)^(-1/eta))+omgt*Kg(-1)/exp(K(-1)))/(((1-delta)*((eps2/eps_min)^(-1/eta)))+ppit+omgt*Kg(-1)/exp(K(-1)));

% 5. Cut-off Value for Investment

eps1 = 1/(exp(Phi_k));

% 6. Cut-off Value for Selling High-quality Asset

eps2 = 1/(exp(qk));

% 7. Bond Price qb

exp(qb) = beta*(Lambda(+1)/Lambda)*(1+(eta/(1-eta))*((eps1(+1)/eps_min)^(-1/eta)));

% 8. Aggregate Ouput Y

exp(Y) = exp(At)*(exp(K(-1))^alpha)*(exp(N)^(1-alpha));

% 9. Marginal Product of Capital (MPK)

rk = alpha*exp(Y)/exp(K(-1));

% 10. Wage Rate (MPL)

w = (1-alpha)*exp(Y)/exp(N);

% 11. Bond Yield

Rb = 1/exp(qb);

% 12. Aggregate Investment

exp(I) = (exp(Bt(-1))+rk*exp(K(-1))+omgt*ppit*exp(qk)*exp(K(-1)))*((eps1/eps_min)^(-1/eta))+(1-delta)*omgt*exp(qk)*exp(K(-1))*((eps2/eps_min)^(-1/eta));

% 13. Law of Motion for Aggregate Capital

exp(K) = (1-delta)*exp(K(-1))+(exp(Bt(-1))+rk*exp(K(-1))+omgt*ppit*exp(qk)*exp(K(-1)))*((eps1/eps_min)^(-1/eta))*(eps1/(1-eta))+ (1-delta)*omgt*exp(qk)*exp(K(-1))*((eps2/eps_min)^(-1/eta))*(eps2/(1-eta));

% 14. FOC for labor supply

w = chi*((exp(N))^ksi)*exp(C);

% 15. Resources Constraint

exp(C)+exp(I) = exp(Y)+exp(qb)*exp(Bt)-exp(Bt(-1))+omgt*Kg(-1)*exp(qk)-Ig*exp(qk);

% That is, exp(C)+exp(I) = exp(Y)+exp(qb)*exp(Bt)-exp(Bt(-1))+omgt*Kg(-1)*exp(qk)-Ig*exp(qk);
% As shown below, Ig = lambda*exp(S)


%exp(C)+exp(I) = exp(Y)+exp(qb)*exp(Bt)-exp(Bt(-1));
%exp(C)+exp(I) = exp(Y)+exp(qb)*exp(Bt)-exp(Bt(-1))-(1-theta)*lambda*exp(L);

% 16. Lanrangean Multiplier

Lambda = (exp(C))^(-1);

% 17. Debt-to-GDP Ratio

BY = exp(Bt(-1))/exp(Y);

% 18. Return of Holding (Risky) Assets
%Rk = (rk(+1)+(ppi+1-delta)*exp(qk(+1))*(omegat+(1-omegat)/theta))/exp(qk);
%Rk = Rb/theta;
%Rk = (rk(+1)+omgt*ppit(+1)*exp(qk(+1)))/exp(qk)+((1+(eta/(1-eta))*((eps2/eps_min)^(-1/eta)))/exp(qb))*(1-delta)*omgt*exp(Phi_k(+1))/exp(qk)+(1/exp(qb))*(1-delta)*(1-omgt)*exp(Phi_k(+1))/exp(qk);
Rk = (rk(+1)+(1-delta)*exp(Phi_k(+1)))/exp(Phi_k);

% 19. Liquidity Premium

spread = Rk-Rb;

% 20. Endogenous Resaleability

omegat = ((ppit+(1-delta)*(theta^(1/eta)))/(ppit+(1-delta)))*omgt;

% 21. Totoal Supply of Private Assets; Trading Volume

exp(S) = (ppit+(1-delta)*((eps2/eps_min)^(-1/eta)))*exp(K(-1))*omgt;


% 22. Private Liquidity

exp(L) = exp(qk)*exp(S);


% 23. Liquidity Policy (Conventional)
exp(Bt) = exp(B_ss)*((exp(L)/exp(L_ss))^(-1*phi))+bbt;


% exp(qb-qb_ss)*exp(Bt-B_ss)= ((exp(L)/exp(L_ss))^(-1*phi))+bbt;
% exp(Bt) = exp(B_ss)*((exp(L(-1))/exp(L_ss))^(-1*phi))+bbt;

% with phi>=0, i.e., leaning against the wind

% alternative setup: 
% (1) exp(Bt) = exp(B_ss)*((exp(qk)/exp(qk_ss))^phi);
% (2) exp(Lpub) = exp(Lpub_ss)*((exp(Lpri)/exp(Lpri_ss))^(-1*phi_q));
%exp(Bt) = exp(B_ss)*((exp(qk)/exp(qk_ss))^(-1*phi))+bbt;


% 24. Liquidity Policy (Unconventional), auxiliary part

%lambda = (exp(qk)/exp(qk_ss))^(-1*pphi)-1;

%lambda = -1*pphi*(omegat-omegat_ss);  % THIS IS VERY NICE

lambda = (exp(L)/exp(L_ss))^(-1*pphi)-1;



%lambda = max((exp(L)/exp(L_ss))^(-1*pphi)-1,0);


% 25. Ig
%Ig = (lambda+1)*omega_bar*Kg_ss/theta_ss;

Ig = lambda*exp(S);

% THAT IS, Ig = lambda*exp(S)

% 26. Liquidity Policy (Unconventional), essential part

% Kg = Kg(-1)+omgt*lambda*Kg(-1);

Kg = (1-omgt)*Kg(-1)+theta*lambda*exp(S);

% Kg = (1-exp(omgt))*Kg(-1)+theta*Ig;


% 27: Haircut
haircut = 1-theta;

% 28: theta and theta-original

theta = theta_original;
%theta = theta_original/((1-lambda)/2+sqrt(((1-lambda)/2)^2+lambda*theta_original));

% 29 - 32: Shocks 

At = rho_a*At(-1)-eA;  % TFP shock
ppit = rho_ppi*ppit(-1)+(1-rho_ppi)*ppi+eP;   % uncertainty shock to asset quality (mean preserving spread)
omgt = rho_omega*omgt(-1)+(1-rho_omega)*omega_bar-eO;  % resaleability (redeployability) shock 
bbt = rho_b*bbt(-1)-eB;  % fiscal shock



end;




initval;

%var qk Phi_k eps1 eps2 theta  qb  Y  K   N   rk   w   Rb   I   C   BY    Lambda  Rk     spread   Bt   omegat  At    L     S  ppit  omgt   bbt  haircut theta_original lambda  V ;

%%  [ 1    2    3   4     5     6  7  8   9   10  11   12  13   14  15      16    17      18      19     20    21    22   23   24    25    26     27          28         29    30]

qk = qk_ss;
Phi_k = Phi_k_ss;
eps1 = eps1_ss;
eps2 = eps2_ss;
theta = theta_ss;
qb = qb_ss;
Y = Y_ss;
K = K_ss;
N = N_ss;
rk = rk_ss;
w = w_ss;
Rb = Rb_ss;
I = I_ss;
C = C_ss;
BY = BY_ss;
Lambda = Lambda_ss;
Rk = Rk_ss;
spread = spread_ss;
Bt = B_ss;
omegat = omegat_ss;
At = A_ss;
V = V_ss;
L = L_ss;
S = S_ss;
ppit = ppi;
omgt = omega_bar;
haircut = haircut_ss;
theta_original = theta_ss;
lambda = 0;
Kg = Kg_ss;
Ig = omega_bar*Kg_ss/theta_ss;
bbt = 0;
eA = 0;
eP = 0;
eO = 0;
eB = 0; 

end;



shocks;

var eA; stderr stdA;
var eP; stderr stdP;
var eO; stderr stdO;
var eB; stderr stdB;

end;


steady (maxit = 100, solve_algo = 2);

check;

stoch_simul(noprint,nograph,periods=0);
%stoch_simul(nograph, periods=0);

%delete *dynamic.m
delete *variables.m
delete *static.m
delete *asv
%delete *log


%stoch_simul(noprint,nograph,periods=0);
%stoch_simul(nograph, periods=0);

%stoch_simul(periods=0,order=1,hp_filter=1600,nograph,irf=20);







%irf_tfp_2 = [I_xx Y_xx qk_xx omegat_xx K_xx eps1_xx eps2_xx spread_xx Rb_xx C_xx];
%save data_irf_tfp_2 irf_tfp_2;



%%%%%%%%%%%%
% Figures %%
%%%%%%%%%%%%



% var qk eps1 qb Y K N rk w Rb I C Lambda At;
% I, K, Y
% qk, eps1, eps2, spread
% Rb, C, omegat


% figure(1)
% 
% subplot(3,3,1)
% plot(1:20,I_xx*100,'LineWidth',1.5);
% title('$I_{t}\,\left(\%\right)$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]);
% 
% 
% 
% subplot(3,3,2)
% plot(1:20,K_xx*100,'LineWidth',1.5);
% title('$K_{t}\,\left(\%\right)$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]);
% 
% 
% subplot(3,3,3)
% plot(1:20,Y_xx*100,'LineWidth',1.5);
% title('$Y_{t}\,\left(\%\right)$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]);
% 
% subplot(3,3,4)
% plot(1:20,qk_xx*100,'-b',1:20,Phi_k_xx*100,'--b','LineWidth',1.5);
% title('$\mbox{Asset Price}\thinspace\left(\%\right)$','Interpreter','latex','FontSize',12);
% legend('$q^{k}_{t}$','$\Phi^{k}_{t}$','Interpreter','latex');
% grid on;
% xlim([1,20]);
% 
% subplot(3,3,5)
% plot(1:20,eps1_xx,'-b',1:20,eps2_xx,'--b','LineWidth',1.5);
% title('$\mbox{Cut-off Values}$','Interpreter','latex','FontSize',12);
% legend('$\varepsilon_{t}^{*}$','$\varepsilon_{t}^{**}$','Interpreter','latex');
% grid on;
% xlim([1,20]);
% 
% subplot(3,3,6)
% plot(1:20,spread_xx,'-b','LineWidth',1.5);
% % title('$B_{t}/Y_{t}$','Interpreter','latex','FontSize',12);
% title('$\mbox{spread}$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]);
% 
% subplot(3,3,7)
% plot(1:20,Rb_xx*100,'-b','LineWidth',1.5);
% title('$R^{B}_{t}$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]);
% 
% subplot(3,3,8)
% plot(1:20,C_xx*100,'LineWidth',1.5);
% title('$C_{t}\,\left(\%\right)$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]);
% 
% subplot(3,3,9)
% plot(1:20,omegat_xx,'LineWidth',1.5);
% title('$\mbox{Resaleability}$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]); 
% 
% 
% figure(2)
% 
% subplot(2,3,1)
% plot(1:20,I_xx*100,'LineWidth',1.5);
% title('$I_{t}\,\left(\%\right)$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]);
% 
% 
% subplot(2,3,2)
% plot(1:20,Y_xx*100,'LineWidth',1.5);
% title('$Y_{t}\,\left(\%\right)$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]);
% 
% subplot(2,3,3)
% plot(1:20,qk_xx*100,'-b',1:20,Phi_k_xx*100,'--b','LineWidth',1.5);
% title('$\mbox{Asset Price}\thinspace\left(\%\right)$','Interpreter','latex','FontSize',12);
% legend('$q^{k}_{t}$','$\Phi^{k}_{t}$','Interpreter','latex');
% grid on;
% xlim([1,20]);
% 
% 
% subplot(2,3,4)
% plot(1:20,spread_xx,'-b','LineWidth',1.5);
% % title('$B_{t}/Y_{t}$','Interpreter','latex','FontSize',12);
% title('$\mbox{spread}$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]);
% 
% subplot(2,3,5)
% plot(1:20,Rb_xx*100,'-b','LineWidth',1.5);
% title('$R^{B}_{t}$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]);
% 
% subplot(2,3,6)
% plot(1:20,omegat_xx,'LineWidth',1.5);
% title('$\mbox{Resaleability}$','Interpreter','latex','FontSize',12);
% grid on;
% xlim([1,20]); 
% 
% 
% print figure_ex1.eps
% % 
% % figure(2)
% % plot(1:20,At_xx*100,'LineWidth',1.5);
% % title('$\mbox{TFP Shock}\,\left(\%\right)$','Interpreter','latex','FontSize',12);
% % grid on;
% % xlim([1,20]); 
% 
% 
% 
% 
% % dynare IRF_tfp_shock_fixed_bond_info_asy.mod


