clear all; clc

% To GENERATE THE NEW FIGURE 2: three panels

% (1) to obtain the left panel (complete info versus adverse selection with the same paramete)
run figure_2_demand_for_liquidity_haoning

% BB_ci_as = [BB_ci;R_ci;BB;R];
% save data_BB_ci_as BB_ci_as


% (2) to obtain the middle panel (adverse selectin: low pi versus high pi)
run figure_2_high_pi_haoning

% BB_ci_as_high_pi = [BB_ci;R_ci;BB;R];
% save data_BB_ci_as_high_pi BB_ci_as_high_pi

% (3) to obtain the right panel (adverse selection: high omega versus low omega)
run figure_2_low_omega_haoning

% BB_ci_as_low_omega = [BB_ci;R_ci;BB;R];
% save data_BB_ci_as_low_omega BB_ci_as_low_omega


load data_BB_ci_as_haoning
BB_ci = BB_ci_as(1,:);
R_ci = BB_ci_as(2,:);
BB = BB_ci_as(3,:);
R = BB_ci_as(4,:);

load data_BB_ci_as_high_pi_haoning
BB_ci_high_pi = BB_ci_as_high_pi(1,:);
R_ci_high_pi = BB_ci_as_high_pi(2,:);
BB_high_pi = BB_ci_as_high_pi(3,:);
R_high_pi = BB_ci_as_high_pi(4,:);


load data_BB_ci_as_low_omega_haoning
BB_ci_low_omega = BB_ci_as_low_omega(1,:);
R_ci_low_omega = BB_ci_as_low_omega(2,:);
BB_low_omega = BB_ci_as_low_omega(3,:);
R_low_omega = BB_ci_as_low_omega(4,:);



figure(1)
subplot(1,3,1)
plot(BB_ci,R_ci,'-or',BB,R,'--b',B_ss.*ones(NN,1),linspace(0.983,1.012,NN),'-k','linewidth',2);
%plot(BB_ci,R_ci,'-ro',BB,R,'--b',B_ss.*ones(NN,1),linspace(0.983,1.012,NN),'-k','linewidth',2);
xlabel('Supply of Public Liquidity','Interpreter','latex','FontSize',20);
ylabel('Bond Yield','Interpreter','latex','FontSize',20);
% xlabel('Supply of Public Liquidity (B)');
% ylabel('Interst Rate (R^B)');
%xlim([0 max(BB).*1.028]);
xlim([0 max(max(BB),max(BB_low_omega)).*1.028]);
%legend('Complete Information','Adverse Selection (AS)');
%legend('CI','AS');
h = legend('$\tilde{R}^{B}$','$R^{B}$');
set(h,'Interpreter','latex','fontsize',15)
%ylim([0.99 1/beta]);
ylim([0.983 1.012]);

subplot(1,3,2)
plot(BB,R,'--b',BB_high_pi,R_high_pi,'-.r',B_ss.*ones(NN,1),linspace(0.983,1.012,NN),'-k','linewidth',2);
xlabel('Supply of Public Liquidity','Interpreter','latex','FontSize',20);
ylabel('Bond Yield','Interpreter','latex','FontSize',20);
%xlim([0 max(BB).*1.028]);
xlim([0 max(max(BB),max(BB_low_omega)).*1.028]);
h = legend('$R^{B}\,\mbox{(low \ensuremath{\pi})}$','$R^{B}\,\mbox{(high \ensuremath{\pi})}$');
set(h,'Interpreter','latex','fontsize',15)
%legend('CI: High \pi','AS: High \pi','AS');
%ylim([0.99 1/beta]);
ylim([0.983 1.012]);

% plot(BB_ci_high_pi,R_ci_high_pi,'+r',BB_high_pi,R_high_pi,'*r',BB,R,'.b',B_ss.*ones(NN,1),linspace(0.985,1.012,NN),'-k','linewidth',1.5);
% xlabel('Supply of Public Liquidity','Interpreter','latex','FontSize',11);
% ylabel('Bond Yield','Interpreter','latex','FontSize',11);
% %xlim([0 max(BB).*1.028]);
% xlim([0 max(max(BB),max(BB_low_omega)).*1.028]);
% h = legend('$\tilde{R}^{B}$','$R^{B}\,\mbox{(low \ensuremath{\pi})}$','$R^{B}\,\mbox{(high \ensuremath{\pi})}$',2);
% set(h,'Interpreter','latex','fontsize',8)
% %legend('CI: High \pi','AS: High \pi','AS');
% %ylim([0.99 1/beta]);
% ylim([0.985 1.012]);


%'$\epsilon_{t}^{*}$','Interpreter','latex','FontSize',11

subplot(1,3,3)
plot(BB,R,'--b',BB_low_omega,R_low_omega,'-.r',B_ss.*ones(NN,1),linspace(0.983,1.012,NN),'-k','linewidth',2);
xlabel('Supply of Public Liquidity','Interpreter','latex','FontSize',20);
ylabel('Bond Yield','Interpreter','latex','FontSize',20);
xlim([0 max(max(BB),max(BB_low_omega)).*1.028]);
%h = legend('$R^{B}\,\mbox{(high \ensuremath{\overline{\omega}})}$','$R^{B}\,\mbox{(low \ensuremath{\overline{\omega}})}$',2);
h = legend('$R^{B}\,\mbox{(high \ensuremath{\omega})}$','$R^{B}\,\mbox{(low \ensuremath{\omega})}$');
set(h,'Interpreter','latex','fontsize',15)
%legend('tilde{R}^{B}','AS: Low \omega','AS');
%ylim([0.99 1/beta]);
ylim([0.983 1.012]);


print -depsc2 D_public_liquidity_qk_new.eps



% x = -pi:pi/20:pi;
% plot(x,cos(x),'-ro',x,sin(x),'-.b')
% h = legend('$\cos{\hat a}$','$\sin{x}$',2);
% set(h,'Interpreter','latex','fontsize',20)


% figure(2)
% subplot(1,2,1)
% plot(BB_ci,R_ci,'-.r',BB_ci_high_pi,R_ci_high_pi,'--b',B_ss.*ones(NN,1),linspace(0.985,1.012,NN),'-k','linewidth',1.5);
% xlabel('Supply of Public Liquidity (B)');
% 
% ylabel('Interst Rate (R^B)');
% xlim([0 max(BB).*1.028]);
% legend('CI: Low \pi','CI: High \pi');
% %ylim([0.99 1/beta]);
% ylim([0.985 1.012]);
% %set(gca,'xtick',[])
% %legend('$\epsilon_{t}^{*}$','$\epsilon_{t}^{**}$');
% 
% 
% subplot(1,2,2)
% plot(BB_ci,R_ci,'-.r',BB_ci_low_omega,R_ci_low_omega,'--b',B_ss.*ones(NN,1),linspace(0.985,1.012,NN),'-k','linewidth',1.5);
% xlabel('Supply of Public Liquidity (B)');
% ylabel('Interst Rate (R^B)');
% xlim([0 max(BB).*1.028]);
% legend('CI: High \omega','CI: Low \omega');
% %ylim([0.99 1/beta]);
% ylim([0.985 1.012]);



