%close all;
clc
%clear all;


%run osr_policy_conventional_2_haoning.m


load data_series_conventional;
phi_index = series_conventional(1,:);
u_A = series_conventional(2,:);
u_P = series_conventional(3,:);
u_O = series_conventional(4,:);
u_B = series_conventional(5,:);


% Plot with initial calibration
figure(1)
subplot(2,3,1)
plot(phi_index,-(u_A-u_A(1))./u_A(1)*100,'blue','LineWidth',1.5);
xlabel('$\phi$','Interpreter','latex','FontSize',15);
xlim([0 0.3]);
ylabel('$\Delta(\phi)$','Interpreter','latex','FontSize',15);
title('TFP Shock','FontSize',15);
grid on 

subplot(2,3,2)
plot(phi_index,-(u_P-u_P(1))./u_P(1)*100,'blue','LineWidth',1.5);
xlabel('$\phi$','Interpreter','latex','FontSize',15);
xlim([0 0.3]);
ylabel('$\Delta(\phi)$','Interpreter','latex','FontSize',15);
title('Safety Shock','FontSize',15);
grid on 

subplot(2,3,3)
plot(phi_index,-(u_O-u_O(1))./u_O(1)*100,'blue','LineWidth',1.5);
xlabel('$\phi$','Interpreter','latex','FontSize',15);
xlim([0 0.3]);
ylabel('$\Delta(\phi)$','Interpreter','latex','FontSize',15);
title('Liquidity Shock','FontSize',15);
grid on 

%run osr_policy_conventional_2_haoning_other.m

load data_series_conventional_other;
phi_index = series_conventional(1,:);
u_A = series_conventional(2,:);
u_P = series_conventional(3,:);
u_O = series_conventional(4,:);
u_B = series_conventional(5,:);

subplot(2,3,4)
plot(phi_index,-(u_A-u_A(1))./u_A(1)*100,'blue','LineWidth',1.5);
xlabel('$\phi$','Interpreter','latex','FontSize',15);
xlim([0 0.3]);
ylabel('$\Delta(\phi)$','Interpreter','latex','FontSize',15);
title('TFP Shock','FontSize',15);
grid on 

subplot(2,3,5)
plot(phi_index,-(u_P-u_P(1))./u_P(1)*100,'blue','LineWidth',1.5);
xlabel('$\phi$','Interpreter','latex','FontSize',15);
xlim([0 0.3]);
ylabel('$\Delta(\phi)$','Interpreter','latex','FontSize',15);
title('Safety Shock','FontSize',15);
grid on 

subplot(2,3,6)
plot(phi_index,-(u_O-u_O(1))./u_O(1)*100,'blue','LineWidth',1.5);
xlabel('$\phi$','Interpreter','latex','FontSize',15);
xlim([0 0.3]);
ylabel('$\Delta(\phi)$','Interpreter','latex','FontSize',15);
title('Liquidity Shock','FontSize',15);
grid on 
% 
% print -depsc2 con_policy_two_cases.eps
   

