clear all; clc

figure(1)

% b = 1.2;

load data_series_unconventional;
phi_index = series_unconventional(1,:);
u_A = series_unconventional(2,:);
u_P = series_unconventional(3,:);
u_O = series_unconventional(4,:);

load data_u_no_policy
u_A0 = u_no_policy(1);
u_P0 = u_no_policy(2);
u_O0 = u_no_policy(3);

beta = 0.9848;

u_Delta_A = -(u_A-u_A0)./u_A0.*100;
u_Delta_P = -(u_P-u_P0)./u_P0.*100;
u_Delta_O = -(u_O-u_O0)./u_O0.*100;


subplot(1,3,1)
plot(phi_index,u_Delta_A,'-b','LineWidth',1.5);
xlabel('$\phi$','Interpreter','latex','FontSize',11);
xlim([0 0.3]);
ylim([0 1.05*max(u_Delta_A)]);
ylabel('$\Delta(\phi)$','Interpreter','latex','FontSize',11);
title('TFP Shock','Interpreter','latex','FontSize',10);
%h = legend('$\rho = 0.9$','$\rho =0.95 $',2);
%set(h,'Interpreter','latex','fontsize',11)
% grid on 
%legend('\rho = 0.9','\rho = 0.95');

subplot(1,3,2)
plot(phi_index,u_Delta_P,'-b','LineWidth',1.5);
xlabel('$\phi$','Interpreter','latex','FontSize',11);
xlim([0 0.45]);
ylim([0 1.05*max(u_Delta_P)]);
ylabel('$\Delta(\phi)$','Interpreter','latex','FontSize',11);
title('Safety Shock','Interpreter','latex','FontSize',10);
%h = legend('$\rho = 0.9$','$\rho =0.95 $',2);
%set(h,'Interpreter','latex','fontsize',11)
% grid on 

subplot(1,3,3)
plot(phi_index,u_Delta_O,'-b','LineWidth',1.5);
xlabel('$\phi$','Interpreter','latex','FontSize',11);
xlim([0 0.45]);
ylim([0 1.05*max(u_Delta_O)]);
ylabel('$\Delta(\phi)$','Interpreter','latex','FontSize',11);
title('Liquidity Shock','Interpreter','latex','FontSize',10);
%h = legend('$\rho = 0.9$','$\rho =0.95 $',2);
%set(h,'Interpreter','latex','fontsize',11)
% grid on 

% print -depsc2 osr_unconventional2.eps
