************** This do-file runs tests for other datasets ************************************

*** 1. Barron and Gravert (2022), IQ test

use "D:\Work\Debt project\Submission JMCB\Other datasets\Barron_Gravert_2022.dta", clear

*Comment: Study authors use a hard-easy manipulation for an IQ-test (Raven's progressive Matrices)
*Similar to our study this is done to manipulate beliefs, in their case to study wage choices for an effort task.

*Comment 2: Beliefs are collected after task completion.

sum beliefinput
*relevant belief variable (corresponds to probability to be in the top half)

ttest beliefinput, by(treatment)
esize twosample beliefinput, by(treatment)
* t-value 3.71, d= 0.74

gen bta = 0 if beliefinput!=.
replace bta=1 if beliefinput>50
ttest bta, by(treatment)
* what percentage of participants believes to be better than average ("standardized bta")

*** 2. Moore and Small (2007), Experiment 1, quiz task

use "D:\Work\Debt project\Submission JMCB\Other datasets\Moore_Small_2007.dta", clear

*Comment: Study 1 is most similar to our design as participants perform a trivia quiz 
*with a hard-easy manipulation. Moore and Small also manipulate target (person next to you, 
*typical person), therefore we focus on belief variables without target manipulation.
*They collect many related comparative judgement variables.

*Comment 2: Beliefs are collected after task completion.

sum pp7selfpercentilewhatpercentageo
*relevant belief variable (percentile in quiz)

ttest pp7selfpercentilewhatpercentageo, by(difficult)
esize twosample pp7selfpercentilewhatpercentageo, by(difficult)
* t-value 8.48, d= 1.06

*Alternative variables
ttest pp1_bet1, by(difficult)
esize twosample pp1_bet1, by(difficult)
* Bet based on comparative judgment
ttest pp6selfrelativehowdoyouexpecttha, by(difficult)
esize twosample pp6selfrelativehowdoyouexpecttha, by(difficult)
* Relative judgment on scale (1-7)

gen bta = 0 if pp7selfpercentilewhatpercentageo!=.
replace bta=1 if pp7selfpercentilewhatpercentageo>50
ttest bta, by(difficult)
* what percentage of participants believes to be better than average ("standardized bta")

*** 3. Moore and Healey (2008) 

*Comment: Participants perform 18 trivia quizzes of different difficulty levels (easy - medium -hard).
*We focus on the easy-hard comparison.

*Comment 2: Relevant variable is interim overplacement - after the quiz but before feedback.

use "D:\Work\Debt project\Submission JMCB\Other datasets\Moore_Healy_2008.dta", clear

sum x
*As original variable names where to long, relevant variable was renamed x

rename qdifficulty1simple3difficult difficulty

ttest x if difficulty!=2, by(difficulty)
*Values correspond to numbers in Table 2, column overall
*However, t-value is inflated as there are multiple observations per subject
reg x difficulty if difficulty!=2, cluster(subjno)
*t-value 7.2
esize twosample x if difficulty!=2, by(difficulty)
*d=0.74

*BTA: overpalcement>0
gen bta=0 if x!=.
replace bta=1 if x!=. & x>0
sum bta if difficulty==1
sum bta if difficulty==3

*** 4. Dargnies, Hakimov, and Kübler (2019)

*Comment: Study uses additions (easy task) and logic questions from an IQ-test (hard task).
*This is done to manipulate beliefs, in their case to study matching markets where firms hire workers

*Comment 2: Beliefs are elicited after task

use "D:\Work\Debt project\Submission JMCB\Other datasets\Dargnies_Hakimov_Kübler_2019_d2.dta", clear 

*paper uses only type=1 (unclear, what this means)
*tr is treatment indicator, hard=0, easy=1
*overconf in overplacement variable as displayed in the paper Figure 2
*belief is estimated rank uncorrected for actual rank

ttest overconf if type==1, by(tr)
*t-value 2.12
esize twosample overconf if type==1, by(tr)
*d=0.33

*alternative based on beliefs
ttest belief if type==1, by(tr)
*t-value 2.56
esize twosample belief if type==1, by(tr)
*d=0.40
*somewhat higher using raw beliefs

*bta based on belief
gen bta=0 if belief!=. & type==1
replace bta=1 if belief<=8 & belief!=. & type==1
sum bta if tr==0 
sum bta if tr==1 

*opl based on overconf
gen opl=0 if overconf!=. & type==1
replace opl=1 if overconf>0 & overconf!=. & type==1
sum opl if tr==0
sum opl if tr==1
xxx

*** Data collected in direct communication with authors or retrieved from information reported in the paper***************

*** I. Kruger (1999), study 2

*Comment: Study 2 is most similar to our design as participants perform a (word-association) task in
*the lab with a hard-easy manipulation. The other studies in the paper are about abilities such as 
*driving or juggling not assessed or manipulated within the experiment.

*Comment 2: Beliefs are collected after task completion.

*Reported are estimated percentiles (mean, N, and t-value (relative to 50th percentile))
*This can be used to back out standard deviation

*Easy group: n=49, mean=63.4, t=5.38
ttesti 49 63.4 17.43 50
*Sd 17.43 gives the t-value reported in the paper

*Hard group: n=55, mean=41.9, t=-2.85
ttesti 55 41.9 21.08 50
*Sd 21.08 gives the t-value reported in the paper

*Between group t-test and effect size (not reported in the paper)
ttesti 49 63.4 17.43 55 41.9 21.08
esizei 49 63.4 17.43 55 41.9 21.08
* t-value 5.63, d= 1.11

*BTA % cannot be calculated from the data, but average percentiles by group give an indication

*** II. Moore and Kim (2003), exp 1 & 2

*Comment: In all experiments participants solve a trivia quiz. As experiments 3 and 4 
*manipulate participant focus (self or other), we do not consider these.

*Comment 2: Beliefs (bets) before trivia quiz, after sample question

*Reported values Exp 1
*Easy treatment: mean bet 2.95, SD 1.43
*Hard treatment: mean bet 1.74, SD 1.59
*Total N=78, equal split between treatments assumed

*Between group t-test and effect size (not reported in the paper)
ttesti 39 2.95 1.43 39 1.74 1.59
esizei 39 2.95 1.43 39 1.74 1.59
* t-value 3.53, d= 0.80

*Reported values Exp 2
*Easy treatment: mean bet 2.82, SD 1.16
*Hard treatment: mean bet 1.88, SD 1.31
*Total N=88, equal split between treatments assumed

*Between group t-test and effect size (not reported in the paper)
ttesti 44 2.82 1.16 44 1.88 1.31
esizei 44 2.82 1.16 44 1.88 1.31
* t-value 3.56, d= 0.76

*Percentiles Exp 2 (as reported in paper)
*Easy (for self): 72.94, SD 19.04
*Hard (for self): 57.41, SD 21.24
*Total N=88, equal split between treatments assumed

*Between group t-test and effect size (not reported in the paper)
ttesti 44 72.94 19.04 44 57.41 21.24
esizei 44 72.94 19.04 44 57.41 21.24
* t-value 3.61, d= 0.77

*BTA cannot be calculated as bets are not against average participant

*** III. Burson,Larrick, and Klayman (2007), study 1

*Comment: Study 1 is most similar to our design as participants perform a trivia task in 
*with a hard-easy manipulation. 

*Comment 2: Beliefs are collected after task completion.

*The study reports Cohen's d direktly: 0.77
*Percentiles: 62 vs. 48 (can be interpreted as bta measure, % of participants over 50 not reported)
*n=47 and 43

*Back out std.dev. (assumption: same std.dev. in both groups)
esizei 47 62 18.18 43 48 18.18
*A std.dev. of 18.18 gives the reported d-value

ttesti 47 62 18.18 43 48 18.18
*t-value=3.64

*** IV. Bruhin, Petros and Santos-Pinto (2023)

*Comment: Study authors use a hard-easy manipulation for a real effort task (ball catch game)
*Similar to our study this is done to manipulate beliefs, in their case to study effort in team work context.

*Comment 2: Beliefs are collected BEFORE task completion.

*Sum stats received via direct communication
*Easy treatment: n=120, m=1.2, sd=3.28
*Hard treatment: n=120, m=-0.48, sd=3.28
*Belief variable is overplacement in terms of ranks (groups of 12)

ttesti 120 1.2 3.28 120 -0.48 3.28
esizei 120 1.2 3.28 120 -0.48 3.28
*t-value: 3.97, d=0.51

*BTA hard: 23.3
*BTA easy: 55.0

*** V. Colzani and Santos-Pinto (2021)

*Comment: Study authors use a hard-easy manipulation for a quiz task similar to our study. 
*This is done to manipulate beliefs, in their case to study bargaining.

*Comment 2: Beliefs are collected after task completion.

*Sum stats received via direct communication
*Easy treatment: N=94, Mean overplacement: 1.043, SD: 5.609
*Hard treatment: N=96, Mean overplacement: -1.875, SD: 6.491
*Belief variable is overplacement in terms of ranks (groups of 12)

*Discrepancy with the numbers reported in the paper m(easy)=2.04, mean(hard)=-1.61

ttesti 94 1.043 5.609 96 -1.875 6.491
esizei 94 1.043 5.609 96 -1.875 6.491
*t-value: 3.31, d=0.48

ttesti 94 2.04 5.94 96 -1.61 5.5
esizei 94 2.04 5.94 96 -1.61 5.5
*Using values from the paper and SD estimated from CIs (Figure 2)
*t-value: 4.4, d=0.64


*BTA hard: 66/94
*BTA easy: 43/96
display 66/94
display 43/96

*** VI. Klühs, Koch, and Stein (2019), Experiment

*Comment: Study authors use a hard-easy manipulation for a quiz task similar to our study. 
*This is done to manipulate beliefs to study overborrowng in a developing country.

*Comment 2: Beliefs are elicited after test quiz, before main quiz

*Sum stats received via direct communication
*Easy treatment: N= 259, Mean rank: 7.223938, SD: 1.885287
*Hard treatment: N= 212, Mean rank: 6.886792, SD: 1.894471
*Ranks from 1-10 with 10 best

ttesti 259 7.223938 1.885287 212 6.886792 1.894471
esizei 259 7.223938 1.885287 212 6.886792 1.894471
*t-value: 1.93, d=0.18

*BTA hard 156
display 156/212
*BTA easy 205
display 205/259

*Beliefs after task
*Sum stats received via direct communication
*Easy treatment: N= 259, Mean rank: 7.239382, SD: 1.839656
*Hard treatment: N= 212, Mean rank: 6.391509, SD: 1.74772
*Ranks from 1-10 with 10 best

ttesti 259 7.239382 1.839656 212 6.391509 1.74772
esizei 259 7.239382 1.839656 212 6.391509 1.74772
*t-value: 5.09, d=0.47
*values increase after task

*** VII. Dargnies, Hakimov, and Kübler (2019)

*Comment: Study uses additions (easy task) and logic questions from an IQ-test (hard task).
*This is done to manipulate beliefs, in their case to study matching markets where firms hire workers

*Comment 2: Beliefs are elicited after task

*Approximate numbers are taken from Fig. 2 
*Easy: Mean OC 0.5, CI 1.5
*Hard: Mean OC -0.75, CI 2.0
*Total N=240, relevant N=160 (workers), assumption: equal split between hard and easy treatment

display 80^(1/2)*1.5/3.92
*SD easy about 3.42
display 80^(1/2)*2.0/3.92
*SD easy about 4.56

ttesti 80 0.5 3.42 80 -0.75 4.56
*t=1.96, p-value 0.5 roughly in line with reported p of ranksum test
esizei 80 0.5 3.42 80 -0.75 4.56
*d=0.31

*BTA hard 40%
*BTA easy 55%



