**************************************************************
*** Earn More Tomorrow: Overconfidence, Income Expectations and Consumer Indebtedness
***
*** Date: Jan 2023
*** By: Antonia Grohmann, Lukas Menkhoff, Christoph Merkle and Renke Schmacker
**************************************************************


set more off
clear

***install packages
ssc install estout
ssc install ivreg2
ssc install weakiv
ssc install avar
ssc install ranktest
ssc install cibar



***set data folder here
global folder "~\replication_package_jmcb"

global data "$folder/data"
global graphs "$folder/graphs"
global tabs "$folder/tabs"


*load data file
use "$data/data_sessions1-23.dta", clear

global control female age bachelor masters works lnincome
global FL FLsum
global risk risk_scale risk_soep 
global selfcontrol selfcontrol_factor

rename risk risk_soep

***change some labels to get clean tables
label variable debt_1 "Debt after market 1"
label variable debt_2 "Debt after market 2"
label variable debt_final "Final debt"
label variable debt_dum "Has debt"
label variable treatment_easy "Easy"
label variable treatment_random "Control"
label variable treatment_hard "Hard"
label variable female "Female"
label variable bachelor "Bachelor"
label variable masters "Masters"
label variable works "Works"
label variable lnincome "Log of income"
label variable FLsum "Financial literacy"
label variable risk_scale "Risk tolerance (choices)"
label variable risk_soep "Risk tolerance (self-assessed)"
label variable selfcontrol_factor "Self control"
label variable exp_total_payout_1 "Expectations"
label variable overconfidence "Overconfidence"
label variable exp_total_payout_2 "Expectations 2"
label variable overconfidence "Overconfidence"
label variable overconfidence_exp2 "Overconfidence 2"

***Results mentioned in main text

sum quiz_correct_bothrounds if treatment_hard==1 & high_price==0 & comprehend==1
sum quiz_correct_bothrounds if treatment_hard==1 & high_price==0 & comprehend==1
sum quiz_correct_bothrounds if treatment_easy==1 & high_price==0 & comprehend==1

***average payout

sum payout_total if treatment_hard==1 & high_price==0 & comprehend==1
sum payout_total if treatment_easy==1 & high_price==0 & comprehend==1
sum payout_total if treatment_random==1 & high_price==0 & comprehend==1

*Corelations between overconfidence measures
corr overconfidence_exp1 overconfidence_exp2

*Corelations between overconfidence point beliefs and probabilistic rank beliefs
pwcorr overconfidence overconfidence_exp1_2, sig

***has debt
tab debt_dum if high_price==0


*************
*** Table 1: Overconfidence and Borrowing Behavior in the GSOEP Data
*************

/// see do_file replication_SOEP.do
/// replication requires access to GSOEP data


*************
*** Table 2: Demographic and control variables
*************

cap log close
cap log using "$tabs/Table_2.tex", text replace

foreach var of varlist female age bachelor masters works income FLsum risk_scale risk_soep selfcontrol_factor{

di "*********** `var' ************"
sum `var' if  high_price==0 & comprehend==1

*forval i=1/3{
tab treatment if high_price==0 & comprehend==1, sum(`var')
*sum `var' if treatment==`i' & high_price==0 & comprehend==1
*}
oneway `var' treatment if high_price==0 & comprehend==1
}


cap log close




*************
***Table 3: Overconfident income expectations
*************

cap log using "$tabs/Table_3.tex", text replace

***Panel A: Overconfidence
sum overconfidence if high_price==0 & comprehend==1, detail
ttest overconfidence=0 if high_price==0 & comprehend==1

sum overconfidence if high_price==0 & comprehend==1 & treatment==2, detail
ttest overconfidence=0 if high_price==0 & comprehend==1 & treatment==2

sum overconfidence if high_price==0 & comprehend==1 & treatment==1, detail
ttest overconfidence=0 if high_price==0 & comprehend==1 & treatment==1

sum overconfidence if high_price==0 & comprehend==1 & treatment==3, detail
ttest overconfidence=0 if high_price==0 & comprehend==1 & treatment==3

ttest overconfidence if high_price==0 & treatment!=3 & comprehend==1, by(treatment_easy)

***Panel B: Overconfidence 2
sum overconfidence_exp2 if high_price==0 & comprehend==1, detail
ttest overconfidence_exp2==0 if high_price==0 & comprehend==1

sum overconfidence_exp2 if high_price==0 & comprehend==1 & treatment==2, detail
ttest overconfidence_exp2=0 if high_price==0 & comprehend==1 & treatment==2

sum overconfidence_exp2 if high_price==0 & comprehend==1 & treatment==1, detail
ttest overconfidence_exp2=0 if high_price==0 & comprehend==1 & treatment==1

sum overconfidence_exp2 if high_price==0 & comprehend==1 & treatment==3, detail
ttest overconfidence_exp2=0 if high_price==0 & comprehend==1 & treatment==3


ttest overconfidence_exp2 if high_price==0 & treatment!=3 & comprehend==1, by(treatment_easy)

cap log close

*************
***Table 4: Borrowing behavior
*************


gen exp_inc_minus_debt = exp_total_payout_1 - debt_1

cap log using "$tabs/Table_4.tex", text replace

*Panel A: All participants
sum debt_1 if comprehend==1 & high_price==0, detail
sum debt_2 if comprehend==1 & high_price==0, detail
sum debt_final if comprehend==1 & high_price==0, detail
sum debt_new_2 if comprehend==1 & high_price==0, detail
sum earning_unspent_3 if comprehend==1 & high_price==0, detail
sum exp_inc_minus_debt if comprehend==1 & high_price==0, detail

*Panel B: Easy treatment
sum debt_1 if comprehend==1 & high_price==0 & treatment==2, detail
sum debt_2 if comprehend==1 & high_price==0 & treatment==2, detail
sum debt_final if comprehend==1 & high_price==0 & treatment==2, detail

*Panel C: Hard treatment
sum debt_1 if comprehend==1 & high_price==0 & treatment==1, detail
sum debt_2 if comprehend==1 & high_price==0 & treatment==1, detail
sum debt_final if comprehend==1 & high_price==0 & treatment==1, detail

*Panel D: Random treatment
sum debt_1 if comprehend==1 & high_price==0 & treatment==3, detail
sum debt_2 if comprehend==1 & high_price==0 & treatment==3, detail
sum debt_final if comprehend==1 & high_price==0 & treatment==3, detail

cap log close


*************
***Table 5: Debt taking and treatment effect
*************

reg debt_1 treatment_easy treatment_random if comprehend==1 & high_price==0 , robust
estimates store T5_1
reg debt_2 treatment_easy treatment_random if comprehend==1 & high_price==0, robust
estimates store T5_2
reg debt_final treatment_easy treatment_random  if comprehend==1 & high_price==0, robust
estimate store T5_3
reg debt_dum treatment_easy treatment_random  if comprehend==1 & high_price==0, robust
estimate store T5_4

esttab T5_* using "$tabs/Table_5.tex" , replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Debt taking and treatment effect") 


*************
***Table 6: Indebtedness over the course of the experiment (OLS)
*************

reg debt_1 exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1 & high_price==0 , robust
estimates store T6_1
reg debt_1 overconfidence $control $FL $risk $selfcontrol  if comprehend==1 & high_price==0 , robust
estimates store T6_2
reg debt_2 exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1 & high_price==0 , robust
estimates store T6_3
reg debt_2 overconfidence $control $FL $risk $selfcontrol  if comprehend==1 & high_price==0 , robust
estimates store T6_4
reg debt_final exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1 & high_price==0 , robust
estimates store T6_5
reg debt_final overconfidence $control $FL $risk $selfcontrol  if comprehend==1 & high_price==0 , robust
estimates store T6_6
reg debt_dum exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1 & high_price==0 , robust
estimates store T6_7
reg debt_dum overconfidence $control $FL $risk $selfcontrol  if comprehend==1 & high_price==0 , robust
estimates store T6_8



esttab T6_* using "$tabs/Table_6.tex" , order(exp_total_payout_1 overconfidence) replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Debt after market 1") mgroups("\makecell{Debt after \\ market 1}" "\makecell{Debt after \\ market 2}" "Final debt" "Has debt",pattern(1 0 1 0 1 0 1 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles


***number mentioned in the text

*z-standardized overconfidence
sum overconfidence
gen overconfidence_z = (overconfidence-r(mean))/r(sd)

reg debt_dum overconfidence_z $control $FL $risk $selfcontrol  if comprehend==1 & high_price==0 , robust




*************
***Table 7: Indebtedness over the course of the experiment (IV)
*************

foreach var in debt_1 debt_2 debt_final debt_dum{
local i = `i'+1

*IV without controls 
ivreg2 `var' (overconfidence=treatment_easy) if comprehend==1 & high_price==0 & treatment_random==0 , robust first savefirst savefprefix(st1_`i')
weakiv, estadd
estimates store IV1_`i'
estadd local controls " " : IV1_`i'

local i=`i'+1

*IV with controls 
ivreg2 `var' (overconfidence=treatment_easy) $control $FL $risk $selfcontrol if comprehend==1 & high_price==0 & treatment_random==0, robust first savefprefix(st1_`i')
weakiv, estadd
estimates store IV1_`i'
estadd local controls "$\checkmark$" : IV1_`i'
}

*generate tables

***Panel A: Second stage
esttab IV1_* using "$tabs/Table_7.tex" , replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(N rkf ar_p, fmt(%4.0f %8.2f %8.3f) ///
labels( "Observations" "1st stage F-stat." "AR test p")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Panel A: Second Stage") 

***Panel B: First stage
esttab st1_* using "$tabs/Table_7.tex" , keep(treatment_easy) append label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(controls N, fmt(%5s %4.0f ) ///
labels("Controls" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Panel B: First stage") 


*************
***Table 8: Robustness test of treatment effects
*************


*Panel A: Expectations
reg exp_total_payout_1 treatment_easy treatment_random if comprehend==1 & high_price==1 , robust
estimates store T8A_1
reg exp_total_payout_2 treatment_easy treatment_random if comprehend==1 & high_price==1 , robust
estimates store T8A_2
reg overconfidence treatment_easy treatment_random if comprehend==1 & high_price==1 , robust
estimates store T8A_3
reg overconfidence_exp2 treatment_easy treatment_random if comprehend==1 & high_price==1 , robust
estimates store T8A_4

esttab T8A_* using "$tabs/Table_8.tex" , replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) 

*Panel B: Debt taking
reg debt_1 treatment_easy treatment_random if  high_price==1 & comprehend==1, robust
estimates store T8B_1
reg debt_2 treatment_easy treatment_random if  high_price==1 & comprehend==1, robust
estimates store T8B_2
reg debt_final treatment_easy treatment_random  if   high_price==1 & comprehend==1, robust
estimate store T8B_3
reg debt_dum treatment_easy treatment_random  if  high_price==1 & comprehend==1, robust
estimates store T8B_4

esttab T8B_* using "$tabs/Table_8.tex" , append label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) 



*************
***Table 9: Robustness test of overconfidence and borrowing behavior
*************

reg debt_1 exp_total_payout_1 if comprehend==1 & high_price==1 , robust
estimates store T9_1
reg debt_1 overconfidence if comprehend==1 & high_price==1 , robust
estimates store T9_2
reg debt_2 exp_total_payout_1 if comprehend==1 & high_price==1 , robust
estimates store T9_3
reg debt_2 overconfidence if comprehend==1 & high_price==1 , robust
estimates store T9_4
reg debt_final exp_total_payout_1 if comprehend==1 & high_price==1 , robust
estimates store T9_5
reg debt_final overconfidence if comprehend==1 & high_price==1 , robust
estimates store T9_6
reg debt_dum exp_total_payout_1 if comprehend==1 & high_price==1 , robust
estimates store T9_7
reg debt_dum overconfidence if comprehend==1 & high_price==1 , robust
estimates store T9_8

esttab T9_* using "$tabs/Table_9.tex" , replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) 



*************
***Figure 2: Income expectations by treatment before market 1
*************

set scheme s1mono

*debt taking by treatment
cibar exp_total_payout_1 if comprehend==1 & high_price==0, over1(treatment) barlabel(on) graphopts(ytitle("Income expectations"))
graph export "$graphs/Figure_2.png", replace

*************
***Figure 3: Income expectations by treatment before market 2
*************

cibar exp_total_payout_2 if comprehend==1 & high_price==0, over1(treatment) barlabel(on) graphopts(ytitle("Income expectations (second income task)"))
graph export "$graphs/Figure_3.png", replace






*************
***Appendix A: GSOEP results
*************

* see do-file "appendix_D_other_data.do"


*************
***Appendix D: Evidence on the Hard-easy Effect
*************

* see do-file "Tests for other data.do"


*************
***Appendix E. Robustness Tests for the Main Experiment
*************

*************
***Table E.1: Indebtedness over the course of the experiment (OLS)
*************

reg debt_1 treatment_easy if treatment~=3 & comprehend==1 & high_price==0 , robust
estimates store TE1_1
reg debt_1 treatment_easy $control $FL $risk $selfcontrol if treatment~=3 & comprehend==1 & high_price==0 , robust
estimates store TE1_2
reg debt_2 treatment_easy if treatment~=3 & comprehend==1 & high_price==0 , robust
estimates store TE1_3
reg debt_2 treatment_easy $control $FL $risk $selfcontrol if treatment~=3 & comprehend==1 & high_price==0 , robust
estimates store TE1_4
reg debt_final treatment_easy if treatment~=3 & comprehend==1 & high_price==0 , robust
estimates store TE1_5
reg debt_final treatment_easy $control $FL $risk $selfcontrol if treatment~=3 & comprehend==1 & high_price==0 , robust
estimates store TE1_6
reg debt_dum treatment_easy if treatment~=3 & comprehend==1 & high_price==0 , robust
estimates store TE1_7
reg debt_dum treatment_easy $control $FL $risk $selfcontrol if treatment~=3 & comprehend==1 & high_price==0 , robust
estimates store TE1_8



esttab TE1_* using "$tabs/Table_E1.tex" , replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Debt after market 1") mgroups("\makecell{Debt after \\ market 1}" "\makecell{Debt after \\ market 2}" "Final debt" "Has debt",pattern(1 0 1 0 1 0 1 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles


*************
***Table E.2: T-test comparing excluded participants with full sample
*************

cap log close
cap log using "$tabs/Table_E2.tex", text replace

foreach var of varlist female age bachelor masters works lnincome FLsum risk_scale risk_soep selfcontrol_factor{

di "********* `var' *************"
ttest `var' if high_price==0, by(comprehend)
}


cap log close


*************
***Table E.3: Participant comprehension and income expectations
*************

cap log close
cap log using "$tabs/Table_E3.tex", text replace

********* Used Sample *********
tab treatment if high_price==0 & comprehend==1, sum(exp_total_payout_1)
ttest exp_total_payout_1 if high_price==0 & comprehend==1 & treatment~=3, by(treatment)

********* Full Sample *********
tab treatment if high_price==0 , sum(exp_total_payout_1)
ttest exp_total_payout_1 if high_price==0  & treatment~=3, by(treatment)

********* Excluded Sample *********
tab treatment if high_price==0 & comprehend==0, sum(exp_total_payout_1)
ttest exp_total_payout_1 if high_price==0 & comprehend==0 & treatment~=3, by(treatment)

********* All correct *********
tab treatment if high_price==0 & comprehend_correct==5, sum(exp_total_payout_1)
ttest exp_total_payout_1 if high_price==0 & comprehend_correct==5 & treatment~=3, by(treatment)

********* One or more errors *********
tab treatment if high_price==0 & comprehend_correct<5, sum(exp_total_payout_1)
ttest exp_total_payout_1 if high_price==0 & comprehend_correct<5 & treatment~=3, by(treatment)

cap log close


*************
***Table E.4: Participant comprehension and the treatment effect
*************

*Panel A: Used sample
reg debt_1 treatment_easy treatment_random if comprehend==1 & high_price==0 , robust
estimates store T1_1
reg debt_2 treatment_easy treatment_random if comprehend==1 & high_price==0, robust
estimates store T1_2
reg debt_final treatment_easy treatment_random  if comprehend==1 & high_price==0, robust
estimate store T1_3
reg debt_dum treatment_easy treatment_random  if comprehend==1 & high_price==0, robust
estimate store T1_4

esttab T1_* using "$tabs/Table_E4.tex" , replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Used sample") 

*Panel B: Full sample
reg debt_1 treatment_easy treatment_random if high_price==0 , robust
estimates store T1_1
reg debt_2 treatment_easy treatment_random if high_price==0, robust
estimates store T1_2
reg debt_final treatment_easy treatment_random  if high_price==0, robust
estimate store T1_3
reg debt_dum treatment_easy treatment_random  if high_price==0, robust
estimate store T1_4

esttab T1_* using "$tabs/Table_E4.tex" , append label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Full sample") 

*Panel C: All questions correct
reg debt_1 treatment_easy treatment_random if comprehend_correct==5 & high_price==0 , robust
estimates store T1_1
reg debt_2 treatment_easy treatment_random if comprehend_correct==5 & high_price==0, robust
estimates store T1_2
reg debt_final treatment_easy treatment_random  if comprehend_correct==5 & high_price==0, robust
estimate store T1_3
reg debt_dum treatment_easy treatment_random  if comprehend_correct==5 & high_price==0, robust
estimate store T1_4

esttab T1_* using "$tabs/Table_E4.tex" , append label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("All questions correct") 



*************
***Table E.5: Other exclusion criteria and the treatment effect
*************

*Panel A: Preferring cash
reg debt_1 treatment_easy treatment_random if comprehend==1 & high_price==0 & prefer_good==0, robust
estimates store T1_1
reg debt_2 treatment_easy treatment_random if comprehend==1 & high_price==0 & prefer_good==0, robust
estimates store T1_2
reg debt_final treatment_easy treatment_random  if comprehend==1 & high_price==0 & prefer_good==0, robust
estimate store T1_3
reg debt_dum treatment_easy treatment_random  if comprehend==1 & high_price==0 & prefer_good==0, robust
estimate store T1_4

esttab T1_* using "$tabs/Table_E5.tex" , drop(_cons) replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Preferring cash") 

*Panel B: Consumption <= income exp.
reg debt_1 treatment_easy treatment_random if comprehend==1 & high_price==0 & expend_1<=exp_total_payout_1, robust
estimates store T1_1
reg debt_2 treatment_easy treatment_random if comprehend==1 & high_price==0 & expend_1<=exp_total_payout_1, robust
estimates store T1_2
reg debt_final treatment_easy treatment_random  if comprehend==1 & high_price==0 & expend_1<=exp_total_payout_1, robust
estimate store T1_3
reg debt_dum treatment_easy treatment_random  if comprehend==1 & high_price==0 & expend_1<=exp_total_payout_1, robust
estimate store T1_4

esttab T1_* using "$tabs/Table_E5.tex" , drop(_cons) append label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Consumption $\leq$ income exp.") 


*Panel C: Positive consumption 
reg debt_1 treatment_easy treatment_random if comprehend==1 & high_price==0 & expend_1>0, robust
estimates store T1_1
reg debt_2 treatment_easy treatment_random if comprehend==1 & high_price==0 & expend_1>0, robust
estimates store T1_2
reg debt_final treatment_easy treatment_random  if comprehend==1 & high_price==0 & expend_1>0, robust
estimate store T1_3
reg debt_dum treatment_easy treatment_random  if comprehend==1 & high_price==0 & expend_1>0, robust
estimate store T1_4

esttab T1_* using "$tabs/Table_E5.tex" , drop(_cons) append label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Positive consumption") 



*************
***Table E.6: Correlates of Overconfidence
*************

reg overconfidence $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store TE6_1
reg overconfidence_exp2 $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store TE6_2
reg overconfidence_exp1_2 $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store TE6_3
reg overconfidence_exp2_2 $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store TE6_4


esttab TE6_* using "$tabs/Table_E6.tex" , replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) 




*************
***Table E.7: Results for alternative overconfidence measures
*************


*Panel A: Overconfidence 2
reg debt_final overconfidence_exp2 if comprehend==1 & high_price==0, robust
estimates store E7_1
estadd local controls "no" : E7_1
reg debt_final overconfidence_exp2 treatment_easy treatment_random if comprehend==1 & high_price==0, robust
estimates store E7_2
estadd local controls "no" : E7_2
reg debt_final overconfidence_exp2 treatment_easy treatment_random $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store E7_3
estadd local controls "yes" : E7_3

reg debt_dum overconfidence_exp2 if comprehend==1 & high_price==0, robust
estimates store E7_4
estadd local controls "no" : E7_4
reg debt_dum overconfidence_exp2 treatment_easy treatment_random if comprehend==1 & high_price==0, robust
estimates store E7_5
estadd local controls "no" : E7_5
reg debt_dum overconfidence_exp2 treatment_easy treatment_random $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store E7_6
estadd local controls "yes" : E7_6


esttab E7_* using "$tabs/Table_E7.tex" , keep(overconfidence_exp2 treatment_easy treatment_random _cons) replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N controls, fmt(%8.2f %4.0f %5s) ///
labels( "R2" "Observations" "Controls")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Overconfidence 2") 


*Panel B: Income (probabilities)
reg debt_1 expected_value if comprehend==1 & high_price==0, robust
estimates store E7_1
estadd local controls "no" : E7_1
reg debt_1 expected_value treatment_easy treatment_random $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store E7_2
estadd local controls "yes" : E7_2
reg debt_2 expected_value if comprehend==1 & high_price==0, robust
estimates store E7_3
estadd local controls "no" : E7_3
reg debt_2 expected_value treatment_easy treatment_random $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store E7_4
estadd local controls "yes" : E7_4
reg debt_final expected_value if comprehend==1 & high_price==0, robust
estimates store E7_5
estadd local controls "no" : E7_5
reg debt_final expected_value treatment_easy treatment_random $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store E7_6
estadd local controls "yes" : E7_6


esttab E7_* using "$tabs/Table_E7.tex" , keep(expected_value treatment_easy treatment_random _cons) append label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N controls, fmt(%8.2f %4.0f %5s) ///
labels( "R2" "Observations" "Controls")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Income (probabilities)") 



*Panel C: Overconfidence (probabilities)
reg debt_1 overconfidence_exp1_2 if comprehend==1 & high_price==0, robust
estimates store E7_1
estadd local controls "no" : E7_1
reg debt_1 overconfidence_exp1_2 treatment_easy treatment_random $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store E7_2
estadd local controls "yes" : E7_2
reg debt_2 overconfidence_exp1_2 if comprehend==1 & high_price==0, robust
estimates store E7_3
estadd local controls "no" : E7_3
reg debt_2 overconfidence_exp1_2 treatment_easy treatment_random $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store E7_4
estadd local controls "yes" : E7_4
reg debt_final overconfidence_exp1_2 if comprehend==1 & high_price==0, robust
estimates store E7_5
estadd local controls "no" : E7_5
reg debt_final overconfidence_exp1_2 treatment_easy treatment_random $control $FL $risk $selfcontrol if comprehend==1 & high_price==0, robust
estimates store E7_6
estadd local controls "yes" : E7_6

esttab E7_* using "$tabs/Table_E7.tex" , keep(overconfidence_exp1_2 treatment_easy treatment_random _cons) append label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N controls, fmt(%8.2f %4.0f %5s) ///
labels( "R2" "Observations" "Controls")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Overconfidence (probabilities)") 



*************
***Table E.8: Intensive margin of debt and the treatment effect
*************

est clear

reg debt_1 treatment_easy treatment_random if comprehend==1 & high_price==0 & debt_1>0, robust
estimates store T1_1
reg debt_2 treatment_easy treatment_random if comprehend==1 & high_price==0 & debt_2>0, robust
estimates store T1_2
reg debt_final treatment_easy treatment_random  if comprehend==1 & high_price==0 & debt_final>0, robust
estimate store T1_3

esttab T1_* using "$tabs/Table_E8.tex" , replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.3f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Intensive margin of debt and the treatment effect") 



*************
***Table E.9: Intensive margin of debt and mechanisms
*************

est clear

reg debt_1 overconfidence if debt_1>0 & comprehend==1 & high_price==0 & treatment_random==0 , robust
estimates store TE9_1
ivreg2 debt_1 (overconfidence=treatment_easy) if debt_1>0 & comprehend==1 & high_price==0 & treatment_random==0 , robust 
weakiv, estadd
estimates store TE9_2

reg debt_2 overconfidence if debt_2>0 & comprehend==1 & high_price==0 & treatment_random==0 , robust
estimates store TE9_3
ivreg2 debt_2 (overconfidence=treatment_easy) if debt_2>0 & comprehend==1 & high_price==0 & treatment_random==0 , robust 
weakiv, estadd
estimates store TE9_4

reg debt_final overconfidence if debt_final>0 & comprehend==1 & high_price==0 & treatment_random==0 , robust
estimates store TE9_5
ivreg2 debt_final (overconfidence=treatment_easy) if debt_final>0 & comprehend==1 & high_price==0 & treatment_random==0 , robust 
weakiv, estadd
estimates store TE9_6

esttab TE9_* using "$tabs/Table_E9.tex" , replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(N rkf ar_p r2, fmt(%4.0f %8.2f %8.3f %8.3f) ///
labels( "Observations" "F stat" "AR p-value" "R2")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Panel B: Overconfidence")



*************
*** Table F1: Demographic and control variables
*************

cap log close
cap log using "$tabs/Table_F1.tex", text replace

foreach var of varlist female age bachelor masters works income FLsum risk_scale risk_soep selfcontrol_factor{
di "*********** `var' ************"
sum `var' if  high_price==1 & comprehend==1

ttest `var' if comprehend==1, by(high_price)
*forval i=1/3{
tab treatment if high_price==1 & comprehend==1, sum(`var')
*sum `var' if treatment==`i' & high_price==0 & comprehend==1
*}

oneway `var' treatment if high_price==1 & comprehend==1
}


cap log close



*************
***Table F2: Robustness experiment: Indebtedness after market stage 1
*************

reg debt_1 exp_total_payout_1   if comprehend==1 & high_price==1 , robust
estimates store TF2_1
reg debt_1 overconfidence if comprehend==1 & high_price==1 , robust
estimates store TF2_2
reg debt_1 exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF2_3
reg debt_1 overconfidence $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF2_4
reg debt_1 exp_total_payout_1 treatment_easy treatment_random $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF2_5
reg debt_1 overconfidence treatment_easy treatment_random $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF2_6



esttab TF2_* using "$tabs/Table_F2.tex" , order(exp_total_payout_1 overconfidence treatment_easy treatment_random) replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Debt after market 1") mgroups("\makecell{Debt after \\ market 1}" "\makecell{Debt after \\ market 2}" "Final debt" "Has debt",pattern(1 0 1 0 1 0 1 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles



*************
***Table F3: Robustness experiment: Indebtedness after market stage 2
*************

reg debt_2 exp_total_payout_1   if comprehend==1 & high_price==1 , robust
estimates store TF3_1
reg debt_2 overconfidence if comprehend==1 & high_price==1 , robust
estimates store TF3_2
reg debt_2 exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF3_3
reg debt_2 overconfidence $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF3_4
reg debt_2 exp_total_payout_1 treatment_easy treatment_random $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF3_5
reg debt_2 overconfidence treatment_easy treatment_random $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF3_6



esttab TF3_* using "$tabs/Table_F3.tex" , order(exp_total_payout_1 overconfidence treatment_easy treatment_random) replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Debt after market 1") mgroups("\makecell{Debt after \\ market 1}" "\makecell{Debt after \\ market 2}" "Final debt" "Has debt",pattern(1 0 1 0 1 0 1 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles




*************
***Table F4: Robustness experiment: Indebtedness at the end of the experiment
*************

reg debt_final exp_total_payout_1   if comprehend==1 & high_price==1 , robust
estimates store TF4_1
reg debt_final overconfidence if comprehend==1 & high_price==1 , robust
estimates store TF4_2
reg debt_final exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF4_3
reg debt_final overconfidence $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF4_4
reg debt_final exp_total_payout_1 treatment_easy treatment_random $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF4_5
reg debt_final overconfidence treatment_easy treatment_random $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF4_6



esttab TF4_* using "$tabs/Table_F4.tex" , order(exp_total_payout_1 overconfidence treatment_easy treatment_random) replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Debt after market 1") mgroups("\makecell{Debt after \\ market 1}" "\makecell{Debt after \\ market 2}" "Final debt" "Has debt",pattern(1 0 1 0 1 0 1 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles



*************
***Table F5: Robustness experiment: Propensity to remain in debt at the end of the experiment
*************

reg debt_dum exp_total_payout_1   if comprehend==1 & high_price==1 , robust
estimates store TF5_1
reg debt_dum overconfidence if comprehend==1 & high_price==1 , robust
estimates store TF5_2
reg debt_dum exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF5_3
reg debt_dum overconfidence $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF5_4
reg debt_dum exp_total_payout_1 treatment_easy treatment_random $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF5_5
reg debt_dum overconfidence treatment_easy treatment_random $control $FL $risk $selfcontrol  if comprehend==1 & high_price==1 , robust
estimates store TF5_6



esttab TF5_* using "$tabs/Table_F5.tex" , order(exp_total_payout_1 overconfidence treatment_easy treatment_random) replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Debt after market 1") mgroups("\makecell{Debt after \\ market 1}" "\makecell{Debt after \\ market 2}" "Final debt" "Has debt",pattern(1 0 1 0 1 0 1 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles



*************
***Table F.6: Debt taking and treatment effect (pooled results)
*************

est clear

reg debt_1 treatment_easy treatment_random if comprehend==1, robust
estimates store T1_1
reg debt_2 treatment_easy treatment_random if comprehend==1, robust
estimates store T1_2
reg debt_final treatment_easy treatment_random  if comprehend==1, robust
estimate store T1_3
reg debt_dum treatment_easy treatment_random  if comprehend==1, robust
estimate store T1_4

esttab T1_* using "$tabs/Table_F6.tex" , replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.3f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Debt taking and treatment effect (pooled results)") 


*************
***Table F7: Indebtedness over the course of the experiment (OLS, pooled results)
*************

reg debt_1 exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1  , robust
estimates store TF7_1
reg debt_1 overconfidence $control $FL $risk $selfcontrol  if comprehend==1  , robust
estimates store TF7_2
reg debt_2 exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1  , robust
estimates store TF7_3
reg debt_2 overconfidence $control $FL $risk $selfcontrol  if comprehend==1  , robust
estimates store TF7_4
reg debt_final exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1  , robust
estimates store TF7_5
reg debt_final overconfidence $control $FL $risk $selfcontrol  if comprehend==1  , robust
estimates store TF7_6
reg debt_dum exp_total_payout_1 $control $FL $risk $selfcontrol  if comprehend==1  , robust
estimates store TF7_7
reg debt_dum overconfidence $control $FL $risk $selfcontrol  if comprehend==1  , robust
estimates store TF7_8



esttab TF7_* using "$tabs/Table_F7.tex" , order(exp_total_payout_1 overconfidence) replace label booktabs width(0.8\hsize) cells(b(star fmt(%9.3f)) se(par(( )) fmt(%9.3f))) stats(r2 N, fmt(%8.2f %4.0f) ///
labels( "R2" "Observations")) starlevels(* 0.1 ** 0.05 *** 0.01) ///
title("Debt after market 1") mgroups("\makecell{Debt after \\ market 1}" "\makecell{Debt after \\ market 2}" "Final debt" "Has debt",pattern(1 0 1 0 1 0 1 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles
