****SOEP-IS Tables for replication files at JMCB
****Date January 2024
*********************************************************

***Insert filepath here
global filepath ""

use "$filepath\Replication Data SOEP JMCB.dta", clear

***labels

label variable overconfidence_math "Overconfidence (numbers)"
label variable overconfidence_animals "Overconfidence (animals)"
label variable female "Gender"
label variable age "Age"
label variable education "Education"
label variable works "Works"
label variable hnetto "Household income (net)"
label variable ln_hnetto "Log of income"
label variable FLsum "Financial literacy"
label variable risk_soep "Risk tolerance (self assessed)"
label variable risk_scale "Risk tolerance (choices)"
label variable partner_HH "Partner in household"
label variable children_hh "Children in household"
label variable selfcontrol_pred "Self Control"

***Table 1

reg debt_usedoverdraft overconfidence_math female age education works ln_hnetto FLsum risk_soep risk_scale selfcontrol_pred if overconfidence_animals!=., robust
estimates store m1
reg debt_usedoverdraft overconfidence_animals female age education works ln_hnetto FLsum risk_soep risk_scale selfcontrol_pred if overconfidence_math!=. , robust
estimates store m2

reg latepayment_perc overconfidence_math female age education works ln_hnetto FLsum risk_soep risk_scale selfcontrol_pred if overconfidence_animals!=. , robust
estimates store m3
reg latepayment_perc overconfidence_animals female age education works ln_hnetto FLsum risk_soep risk_scale selfcontrol_pred if overconfidence_math!=., robust
estimates store m4

reg feels_debtburden overconfidence_math female age education works ln_hnetto FLsum risk_soep risk_scale selfcontrol_pred if Year==2016 & overconfidence_animals!=., robust
estimates store m5

reg feels_debtburden overconfidence_animals female age education works ln_hnetto FLsum risk_soep risk_scale selfcontrol_pred if Year==2016 & overconfidence_math!=., robust
estimates store m6

estout m1 m2 m3 m4 m5 m6 using "$filepath\oc_soep_1.txt", ///
unstack cells(b(fmt(%9.3f) star) se(par fmt(%9.3f))) stats(r2 N, fmt(%9.3f %9.0f) labels("R\$^2\$" "Observations")) ///
order(overconfidence_math overconfidence_animals female age education works ln_hnetto  FLsum  risk_soep risk_scale selfcontrol_pred )  ///
msign(--) lz varwidth(16) modelwidth(13) style(tex)  title(Overconfidence SOEP) label legend varlabels(_cons Constant) mlabels(, span prefix(\multicolumn{@span}{c}{) ///
suffix(})) prehead("\begin{table}\caption{@title}" "\begin{footnotesize}" "\begin{center}" "\begin{tabular}{lcccccc}") posthead(\midrule) prefoot(\midrule) ///
postfoot("\bottomrule[0.5pt]" "\small " "\end{tabular}" "\end{center}" "\end{footnotesize}" "\end{table}") starlevels(\$^*\$ .10  \$^{**}\$ .05 \$^{***}\$ .01) replace

*** Numbers in main text
count if sample1!=.
tab ifkr07
tab latepayment_perc
tab feels_debtburden


****Table A.1.

estpost tabstat female age education works hnetto FLsum risk_soep risk_scale selfcontrol_factor if sample1!=., statistics(n mean sd p5 p95) columns(statistics)
estout . using "$filepath\demo_soep.txt", unstack  cells("count (fmt(%9.0f)) mean (fmt(%9.2f)) sd (fmt(%9.2f)) p5 (fmt(%9.2f)) p95 (fmt(%9.2f))") label replace style(tex) msign(--) lz varwidth(16)

***Table A.2.

reg overconfidence_math female age education works ln_hnetto FLsum risk_soep risk_scale selfcontrol_factor if Year==2017, robust
estimates store m1
reg overconfidence_animals female age education works ln_hnetto FLsum risk_soep risk_scale selfcontrol_factor if Year==2017, robust
estimates store m2

estout m1 m2 using "$filepath/overconfidencetable.txt", ///
unstack cells(b(fmt(%9.3f) star) se(par fmt(%9.3f))) stats(r2 N, fmt(%9.3f %9.0f) labels("R\$^2\$" "Observations")) ///
order(overconfidence_math overconfidence_animals female age education works ln_hnetto  FLsum  risk_soep risk_scale)  ///
msign(--) lz varwidth(16) modelwidth(13) style(tex)  title(Overconfidence SOEP) label legend varlabels(_cons Constant) mlabels(, span prefix(\multicolumn{@span}{c}{) ///
suffix(})) prehead("\begin{table}\caption{@title}" "\begin{footnotesize}" "\begin{center}" "\begin{tabular}{lcccccc}") posthead(\midrule) prefoot(\midrule) ///
postfoot("\bottomrule[0.5pt]" "\small " "\end{tabular}" "\end{center}" "\end{footnotesize}" "\end{table}") starlevels(\$^*\$ .10  \$^{**}\$ .05 \$^{***}\$ .01) replace


***Figure A.1.
histogram overconfidence_math if Year==2017, discrete frequency graphregion(color(white)) bgcolor(white) fcolor(navy) lcolor(gray) start(-1) ylabel(0 20 40 60 80 100 120)
graph export "$filepath\overconfidence_math_hist.pdf", replace

***Figure A.2
histogram overconfidence_animals if Year==2017, discrete frequency graphregion(color(white)) bgcolor(white) fcolor(navy) lcolor(gray) start(-1) ylabel(0 20 40 60 80 100 120)
graph export "$filepath\overconfidence_animals_hist.pdf", replace

***Numbers in Appendix text

count if Year==2016
count if Year==2017
tab education if Year==2016
 sum num*
sum overconfidence_math if Year==2017
sum overconfidence_animals if Year==2017
pwcorr overconfidence_math overconfidence_animals if Year==2017

