%% *************************************************************************
%  Figure3.m

% Matlab code for "Aggregate Dynamics with Sectoral Price Stickiness 
% Heterogeneity and Aggregate Real Shocks"
% by Alessandro Flamini and Iftekhar Hasan

%  Figure3.m creates Figure 3 by using matrixes xyz1, xyz2, 
%  xyz3 and xxxx defined with data produced by simulating the Dynare code 
%  adfaars.mod for couples of alpha_s and alpha_m.
%
%  For each matrix, in each column the first and second rows report values 
%  for alpha_s and alpha_m, while the third row report the associated value 
%  of the sum of first five autocorrealtion coeffients for inflation. Each
%  matrix xyz1, xyz2, and xyz3 is under the assumption of a specific 
%  constant duration.
% **************************************************************************

close all
%% Data
xyz1 = [0.73        0.727272727	0.72	0.711111111	0.70	0.685714286	0.67	0.64	0.6	    0.55	0.50	0.45        0.40	0.35        0.30	0.25        0.20; ...
        0.20	    0.25	    0.30	0.35	    0.40	0.45	    0.50	0.55	0.6	    0.64	0.67	0.685714286	0.70	0.711111111	0.72	0.727272727	0.73; ...
        3.20	    3.3729	    3.52	3.6393	    3.74	3.8308	    3.90	3.9252	3.9723	3.9252	3.90	3.8308      3.74	3.6393      3.52	3.3729      3.20; ];
   
xyz2 = [0.2           0.25	0.3     0.35	0.4     0.45	0.5         0.55	0.6     0.6500	0.7     0.7375	0.76	0.775	0.7857	0.79375	0.8     0.805	0.8091	0.8125	0.815384615 ; ...
        0.815384615	0.8125	0.8091	0.805	0.8     0.79375	0.7857      0.775	0.76	0.7375	0.7     0.6500	0.6     0.55	0.5     0.45	0.4     0.35	0.3     0.25	0.2 ; ...
       2.8263        3.0522	3.2485	3.4214	3.5745	3.711	3.8316      3.9366	4.0241	4.0896	4.1183	4.0896	4.0241	3.9366	3.8316	3.711	3.5745	3.4214	3.2485	3.0522	2.8263];

xyz3 = [0.885714286	0.884615385	0.883333333	0.881818182	0.88	0.877777778	0.88	0.871428571	0.87	0.86	0.85	0.833333333	0.8     0.75        0.70	0.65	0.60	0.55        0.50	0.45            0.40	0.35        0.3         0.25        0.2 ; ...
        0.2           0.25        0.3         0.35        0.40	0.45        0.50	0.55        0.60	0.65	0.70	0.75        0.8     0.833333333	0.85	0.86	0.87	0.871428571	0.88	0.877777778     0.88	0.881818182	0.883333333	0.884615385	0.885714286 ; ...
        2.018         2.2902      2.5423      2.7779      3.00	3.2078      3.40	3.5884      3.76	3.9174	4.06	4.1669      4.2207	4.1669      4.06	3.9174	3.76	3.5884      3.40	3.2078          3.00	2.7779      2.5423      2.2902      2.018]; 
    
xxxx = [0.2      0.2     0.2     0.2     0.2     0.2     0.2     0.2     0.2     0.3     0.3 	 0.3     0.3     0.3 	 0.3 	 0.3 	0.3     0.3 	0.3     0.4     0.4     0.4     0.4 	0.4 	0.4 	 	0.4 	 	0.4 	0.4 	0.5     0.5 	0.5 	0.5 	0.5 	0.5 	0.5 	0.5 	0.5 	0.5     0.5 	0.6 	0.6 	0.6 	0.6 	0.6 	 	0.6 	0.6 	0.6 	0.6 	0.6 	0.67	0.7 	0.7     0.7 	 	0.7 	0.7 	0.7 	0.7 	0.7 	0.7 	0.72	0.73	0.76	0.7857	0.8     0.8     0.8      	0.8 	0.8 	0.8     0.8 	0.8 	0.8091	0.85	0.87	0.88	0.88	0.9     0.9 	0.9 	0.9 	0.9     0.9 	0.9; ...
        0.2      0.3     0.4     0.5     0.6     0.7     0.73	 0.8     0.9     0.2     0.3     0.4     0.5     0.6     0.7     0.72	0.8     0.8091	0.9     0.2     0.3     0.4     0.5     0.6     0.7         0.8         0.88	0.9     0.2     0.3     0.4     0.5     0.6     0.67	0.7     0.7857	0.8     0.88	0.9     0.2     0.3     0.4     0.5     0.6         0.7     0.76	0.8     0.87	0.9     0.5     0.2     0.3 	0.4         0.5     0.6     0.7     0.8     0.85	0.9     0.3     0.2     0.6     0.5     0.2     0.3     0.4         0.5     0.6     0.7     0.8     0.9     0.3     0.7     0.6     0.4     0.5     0.2     0.3     0.4     0.5     0.6     0.7     0.8; ...
        2.7426	 2.9726	3.1427	 3.2615	 3.318	 3.2649	 3.2     2.9313	 1.7971	 2.9726	 3.195	 3.3615	 3.4837	 3.5548	 3.5389	 3.52	3.2953	3.2485	2.2945	3.1427	3.3615	3.5262	3.6503	3.7316	3.74    	3.5745		3       2.7337	3.2615	3.4837	3.6503	3.7784	3.8691	3.9     3.9042	3.8316	3.7996	3.4     3.1303	3.318	3.5548	3.7316	3.8691	3.9723		4.0303	4.0241	3.9839	3.76	3.4912	3.9     3.2649	3.5389	3.74		3.9042	4.0303	4.1183	4.1303	4.06	3.8187	3.52	3.2     4.0241	3.8316	2.9313	3.2953	3.5745   	3.7996	3.9839	4.1303	4.2207	4.1042	3.2485	4.06	3.76	3       3.4     1.7971	2.2945	2.7337	3.1303	3.4912	3.8187	4.1042];      
   
%% Vectors for persistence curves and their projections on the base plane

% First persistence curve with constant duration   
x1 = xyz1(1,:); y1 = xyz1(2,:); z1 = xyz1(3,:);

% Projections of the first persitence curve on the base plane
x11 = xyz1(1,:); y11 = xyz1(2,:); z11 = 1.5*ones(size(xyz1(1,:)));

% Second persistence curve with constant duration
x2 = xyz2(1,:); y2 = xyz2(2,:); z2 = xyz2(3,:);
      
% Projections of the second persitence curve on the base plane
x22 = xyz2(1,:); y22 = xyz2(2,:); z22 = 1.5*ones(size(xyz2(1,:)));

% Third persistence curve with constant duration
x3 = xyz3(1,:); y3 = xyz3(2,:); z3 = xyz3(3,:);
 
% Projections of the third persitence curve on the base plane 
x33 = xyz3(1,:); y33 = xyz3(2,:); z33 = 1.5*ones(size(xyz3(1,:)));


%% Figure

% Surface
figure
[xq,yq] = meshgrid(.1:.04:1, .1:.04:1);

vq = griddata(xxxx(1,:),xxxx(2,:),xxxx(3,:),xq,yq);

meshc(xq,yq,vq)

hold on

% Plot the first persistence curve
plot3(x1,y1,z1,'LineWidth',1.5,'DisplayName','AD = 2.5','Color','c')
% Plot the projection of the first persitence curve on the base plane
plot3(x11,y11,z11,'LineWidth',1,'DisplayName','AD = 2.5','Color','c')
% plot3(x11,y11,z11,'o','LineWidth',1,'DisplayName','AD = 2.5')

% Plot the second persistence curve
plot3(x2,y2,z2,'LineWidth',1.5,'DisplayName','AD = 3.3','Color','r')
% Plot the projection of the second persitence curve on the base plane
plot3(x22,y22,z22,'LineWidth',1,'DisplayName','AD = 3.3','Color','r')
hold on

hold on
% Plot the third persistence curve
plot3(x3,y3,z3,'LineWidth',1.5,'DisplayName','AD = 5','Color','g')
% Plot the projection of the third persitence curve on the base plane
plot3(x33,y33,z33,'LineWidth',1,'DisplayName','AD = 5','Color','g')

hold on
xlabel('\alpha_s','Fontsize',14)
ylabel('\alpha_m','Fontsize',14)
zlabel('Persistence','Fontsize',14)
