clear all

cd ""

* ==============================================================================
* Figure 1
* ==============================================================================

import excel "Data.xlsx", sheet("Figure1") firstrow clear
rename month mon
gen month = m(2007m1)+_n-1
format month %tm
drop mon

twoway(line policy month, lcolor(red) lwidth(0.5) xlabel(564(24)715) ylabel(0(1)5) xtitle("") ytitle("percent")), graphregion(color(white)) bgcolor(white) xline(588 659 689,lcolor(black))


* ==============================================================================
* Figure 2
* ==============================================================================

import excel "Data.xlsx", sheet("Figure2") firstrow clear
twoway(connect pct_dn time,msymbol(D) lcolor(black) xlabel(-6(1)6) ylabel(0(10)50)),legend(off) ytitle("percent") xtitle("Months since scheduled renewal") title("") graphregion(color(white)) bgcolor(white) 


* ==============================================================================
* Figure 5a
* ==============================================================================

import excel "Data.xlsx", sheet("Figure5a") firstrow clear
rename month mon
gen month = m(2009m1)+_n-1
format month %tm
drop mon

twoway(line gap5 mon, lcolor(black) lwidth(0.5) xlabel(588(24)708)),yline(0) xtitle("") ytitle("percent") graphregion(color(white)) bgcolor(white) 


* ==============================================================================
* Figures 5b-5c
* ==============================================================================
clear

scalar auto = 18.56*84/1.13
scalar dur = 44.36*24/1.13
scalar scale = 0.95  // for aggregation: from 2,3,4,5-yr FRM to all FRM

* Monthly auto sales data (adjusted for non-commericial share)
import excel "Data.xlsx", sheet("autosales") cellrange(A11:C139) firstrow clear
gen month = m(2009m1)+_n-1
format month %tm
gen salesunit = Units*0.87
gen salesamt = Dollars*1000*0.87
keep month sales*
save autospending.dta,replace

* Rate gap and frm shares
import excel "Data.xlsx", sheet("rategap") firstrow clear
rename *,lower
rename month month_str
gen month = m(2009m1)+_n-1
format month %tm
order month
drop month_str

*# of FRM renewed (monthly)
gen frm5adj= 1000000*nmort*frmshare*frm5share*0.20/12
gen frm4adj= 1000000*nmort*frmshare*frm4share*0.25/12
gen frm3adj= 1000000*nmort*frmshare*frm3share*0.33/12
gen frm2adj= 1000000*nmort*frmshare*frm2share*0.50/12

* Asymmetry in elasticity
gen gap5_neg = (gap5<=0)
gen gap4_neg = (gap4<=0)
gen gap3_neg = (gap3<=0)
gen gap2_neg = (gap2<=0)

* Auto spending due to reset
gen frm5auto = -gap5*gap5_neg*frm5adj*auto
gen frm4auto = -gap4*gap4_neg*frm4adj*auto
gen frm3auto = -gap3*gap3_neg*frm3adj*auto
gen frm2auto = -gap2*gap2_neg*frm2adj*auto
gen autoamt5  = frm5auto
gen autoamt  = (frm5auto+frm4auto+frm3auto+frm2auto)/scale

* auto spending due to refi
gen frm5dur = -gap5*gap5_neg*frm5adj*dur
gen frm4dur = -gap4*gap4_neg*frm4adj*dur
gen frm3dur = -gap3*gap3_neg*frm3adj*dur
gen frm2dur = -gap2*gap2_neg*frm2adj*dur
gen duramt5  = frm5dur
gen duramt  =  (frm5dur+frm4dur+frm3dur+frm2dur)/scale

* compare with agg new auto sales
merge 1:1 month using autospending.dta
drop _merge

drop if month<m(2009m1)
drop if month>m(2019m6)

gen autoamt_mil = autoamt/1000000
gen autoamt5_mil = autoamt5/1000000

gen duramt_mil = duramt/1000000
gen duramt5_mil = duramt5/1000000



* Figure 5b 
twoway(line autoamt_mil month,lcolor(black) lwidth(0.4) ytitle("million $") xlabel(588(24)708)) (line autoamt5_mil month,lcolor(black) lwidth(0.4) lpattern(dash_dot)), legend(label(1 "All FRM renewing borrowers") label(2 "5-year FRM renewing borrowers") pos(2) ring(0) row(2) size(small) region(col(none))) xtitle("") title("") graphregion(color(white)) bgcolor(white) title("") 

* Figure 5c
twoway(line duramt_mil month,lcolor(black) lwidth(0.4) ytitle("million $") xlabel(588(24)708)) (line duramt5_mil month,lcolor(black) lwidth(0.4) lpattern(dash_dot)), legend(label(1 "All FRM renewing borrowers") label(2 "5-year FRM renewing borrowers") pos(2) ring(0) row(2) size(small) region(col(none))) xtitle("") title("") graphregion(color(white)) bgcolor(white) title("") 

save autoplot,replace
erase autospending.dta

