clc;clear all;close all;

% load data
borrower = xlsread('Data','Figure3_Figure4');

nq =8;
ci =1.96;
quarter = borrower(1:nq,1);

dn60 = borrower(1:nq,:);
dn24 = borrower(nq+1:2*nq,:);
up60 = borrower(2*nq+1:3*nq,:);
up24 = borrower(3*nq+1:4*nq,:); 


% Figure 3. Spending responses

figure;
subplot(2,2,1) % flow auto spending
plot(quarter,dn60(:,2),'-.rs',quarter,dn60(:,2)+ci*dn60(:,3),'b+',quarter,dn60(:,2)-ci*dn60(:,3),'b+')
axis([-2 5 -20 60])
vline(0)
hline(0,'k-')
title("Auto spending")
ylabel('dollars/month')
xlabel('quarter')

subplot(2,2,2) % cum. auto spending
plot(quarter,dn60(:,10),'-.rs',quarter,dn60(:,10)+ci*dn60(:,11),'b+',quarter,dn60(:,10)-ci*dn60(:,11),'b+')
axis([-2 5 -200 600])
vline(0)
hline(0,'k-')
title("Cumulative auto spending")
ylabel('dollars')
xlabel('quarter')

subplot(2,2,3) % flow IL
plot(quarter,dn60(:,4),'-.rs',quarter,dn60(:,4)+ci*dn60(:,5),'b+',quarter,dn60(:,4)-ci*dn60(:,5),'b+')
axis([-2 5 -50 100])
vline(0)
hline(0,'k-')
title("IL-Financed spending")
ylabel('dollars/month')
xlabel('quarter')

subplot(2,2,4) % cum. IL
plot(quarter,dn60(:,12),'-.rs',quarter,dn60(:,12)+ci*dn60(:,13),'b+',quarter,dn60(:,12)-ci*dn60(:,13),'b+')
axis([-2 5 -500 1000])
vline(0)
hline(0,'k-')
title("Cumulative IL-financed spending")
ylabel('dollars')
xlabel('quarter')


% Figure 4(a) debt repayment expandionary episode

figure;
subplot(2,2,1)
plot(quarter,dn24(:,6),'-.rs',quarter,dn24(:,6)+ci*dn24(:,7),'b+',quarter,dn24(:,6)-ci*dn24(:,7),'b+')
axis([-2 5 -600 200])
vline(0)
hline(0,'k-')
title("Credit card (FRM-2yr)")
ylabel('dollars')
xlabel('quarter')

subplot(2,2,2)
plot(quarter,dn24(:,8),'-.rs',quarter,dn24(:,8)+ci*dn24(:,9),'b+',quarter,dn24(:,8)-ci*dn24(:,9),'b+')
axis([-2 5 -1000 3000])
vline(0)
hline(0,'k-')
title("Lines of credit (FRM-2yr)")
ylabel('dollars')
xlabel('quarter')

subplot(2,2,3)
plot(quarter,dn60(:,6),'-.rs',quarter,dn60(:,6)+ci*dn60(:,7),'b+',quarter,dn60(:,6)-ci*dn60(:,7),'b+')
axis([-2 5 -400 200])
vline(0)
hline(0,'k-')
title("Credit card (FRM-5yr)")
ylabel('dollar')
xlabel('quarter')
ylabel('dollars')

subplot(2,2,4)
plot(quarter,dn60(:,8),'-.rs',quarter,dn60(:,8)+ci*dn60(:,9),'b+',quarter,dn60(:,8)-ci*dn60(:,9),'b+')
axis([-2 5 -500 1500])
vline(0)
hline(0,'k-')
title("Lines of credit (FRM-5yr)")
ylabel('dollars')
xlabel('quarter')


% Figure 4(b) debt repayment contractionary episode

figure;
subplot(2,2,1)
plot(quarter,up24(:,6),'-.rs',quarter,up24(:,6)+ci*up24(:,7),'b+',quarter,up24(:,6)-ci*up24(:,7),'b+')
axis([-2 5 -600 200])
vline(0)
hline(0,'k-')
title("Credit card (FRM-2yr)")
xlabel('quarter')
ylabel('dollars')

subplot(2,2,2)
plot(quarter,up24(:,8),'-.rs',quarter,up24(:,8)+ci*up24(:,9),'b+',quarter,up24(:,8)-ci*up24(:,9),'b+')
axis([-2 5 -2000 1000])
vline(0)
hline(0,'k-')
title("Lines of credit (FRM-2yr)")
ylabel('dollars')
xlabel('quarter')

subplot(2,2,3)
plot(quarter,up60(:,6),'-.rs',quarter,up60(:,6)+ci*up60(:,7),'b+',quarter,up60(:,6)-ci*up60(:,7),'b+')
axis([-2 5 -600 400])
vline(0)
hline(0,'k-')
title("Credit card (FRM-5yr)")
ylabel('dollars')
xlabel('quarter')
ylabel('dollars')


subplot(2,2,4)
plot(quarter,up60(:,8),'-.rs',quarter,up60(:,8)+ci*up60(:,9),'b+',quarter,up60(:,8)-ci*up60(:,9),'b+')
axis([-2 5 -2000 2000])
vline(0)
hline(0,'k-')
title("Lines of credit (FRM-5yr)")
ylabel('dollars')
xlabel('quarter')







