clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use data,clear

keep if month>=m(2010m1)
keep if rep_mon<=m(2017m1)  

* adjust (change maturity month)
sort tu_consumer_id open_mon tu_trade_id rep_mon
by tu_consumer_id open_mon tu_trade_id: gen adjust = (mat_mon!=mat_mon[_n-1] & _n!=1)

* renew (as scheduled)
sort tu_consumer_id open_mon tu_trade_id rep_mon
by tu_consumer_id open_mon tu_trade_id: gen renew = (adjust==1 & rep_mon>=mat_mon[_n-1]-6 & rep_mon<=mat_mon[_n-1]+6) 

* drop adjust out of renew range
gen temp =1 if adjust==1 & renew==0
by tu_consumer_id open_mon tu_trade_id: egen temp2 = mean(temp)
drop if temp2==1 
drop temp* 

* post-renew indicator
by tu_consumer_id open_mon tu_trade_id: gen postrenew = sum(renew) 

* vrm and frm
sort tu_consumer_id open_mon tu_trade_id postrenew rep_mon
  by tu_consumer_id open_mon tu_trade_id postrenew: gen vrmpay = (renew==0 & terms_amt!=terms_amt[_n-1] & terms_amt>0 & terms_amt!=. & terms_amt[_n-1]>0 & terms_amt[_n-1]!=. &_n!=1) 

by tu_consumer_id open_mon tu_trade_id postrenew: egen nvrmpay_within = sum(vrmpay)
gen vrm_within = (nvrmpay_within>0) // whether the term is vrm

by tu_consumer_id open_mon tu_trade_id postrenew: gen temp=(_n==1) // to compute the number of terms
by tu_consumer_id open_mon tu_trade_id: egen nterm=sum(temp) 
drop temp 

by tu_consumer_id open_mon tu_trade_id postrenew: gen temp=(_n==1 & vrm_within==1)
by tu_consumer_id open_mon tu_trade_id: egen temp2 = sum(temp)  // number of terms that are vrm 

gen vrm=(nterm==temp2) 
gen frm=(temp2==0)
gen mixloan = 1-frm-vrm 

drop temp* vrmpay *within nterm 

* 3-step impute rates
  * (1) formula: b(t)=(1+r)b(t-1)-O (annualized effective rate)
by tu_consumer_id open_mon tu_trade_id:     gen imputer = 100*12*((current_ba+terms_amt)/current_ba[_n-1]-1) if current_ba>0 & terms_amt>0 & current_ba[_n-1]>0

// Case 1: current ba are either not changing or increase (imputer too high)
by tu_consumer_id open_mon tu_trade_id: gen test1 = (current_ba>=current_ba[_n-1] & current_ba!=. & current_ba[_n-1]!=. & current_ba>0 & current_ba[_n-1]>0)
replace imputer = . if test1==1

// Case 2: prepay too much (balance reduces more than 0.9*terms_amt)
by tu_consumer_id open_mon tu_trade_id: gen test2 = ((current_ba[_n-1]-current_ba)>0.9*terms_amt & terms_amt!=. & terms_amt>0 & current_ba!=. & current_ba[_n-1]!=. & current_ba>0 & current_ba[_n-1]>0)
replace imputer = . if test2==1

// Case 3: terms_amt =0
replace imputer = . if terms_amt==0

  * (2) drop loans with median r too low or too high
sort tu_consumer_id open_mon tu_trade_id postrenew rep_mon 
  by tu_consumer_id open_mon tu_trade_id postrenew: egen medr = median(imputer)

  by tu_consumer_id open_mon tu_trade_id: egen minmed = min(medr) 
  by tu_consumer_id open_mon tu_trade_id: egen maxmed = max(medr) 

sum medr,d
gen lb = r(p1)  
gen ub = r(p99)  
drop if minmed<=lb 
drop if maxmed>=ub 

* # of renewals per account
by tu_consumer_id open_mon tu_trade_id: egen nrenew = sum(renew) 

*month of actual renew
gen temp =rep_mon if renew==1 & nrenew==1
by tu_consumer_id open_mon tu_trade_id: egen renew_mon = mean(temp) 
format renew_mon %tm
drop temp

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==2
by tu_consumer_id open_mon tu_trade_id: egen renew21_mon = mean(temp) 
format renew21_mon %tm
drop temp

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen renew31_mon = mean(temp) 
format renew31_mon %tm
drop temp

* month of scheduled renew
by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 & nrenew==1
by tu_consumer_id open_mon tu_trade_id: egen schrenew = mean(temp)
format schrenew %tm
drop temp

by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 &postrenew==1 & nrenew==2
by tu_consumer_id open_mon tu_trade_id: egen schrenew21 = mean(temp)
format schrenew21 %tm
drop temp

by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 &postrenew==1 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen schrenew31 = mean(temp)
format schrenew31 %tm
drop temp

* ftime diff between actual and scheduled renew
gen diff = renew_mon-schrenew
replace diff = renew21_mon-schrenew21 if diff==.
replace diff = renew31_mon-schrenew31 if diff==.

tab diff 

*****************************************************************
* rate increase episode 
*****************************************************************
clear all
cap close
set more off
set excelxlsxlargefile on


cd ""

use data.dta,clear

keep if month>=m(2012m7)
keep if month<=m(2019m8) 

* adjust (change maturity month)
sort tu_consumer_id open_mon tu_trade_id rep_mon
by tu_consumer_id open_mon tu_trade_id: gen adjust = (mat_mon!=mat_mon[_n-1] & _n!=1)

* renew (as scheduled)
sort tu_consumer_id open_mon tu_trade_id rep_mon
by tu_consumer_id open_mon tu_trade_id: gen renew = (adjust==1 & rep_mon>=mat_mon[_n-1]-6 & rep_mon<=mat_mon[_n-1]+6) 

* drop adjust out of renew range
gen temp =1 if adjust==1 & renew==0
by tu_consumer_id open_mon tu_trade_id: egen temp2 = mean(temp)
drop if temp2==1 
drop temp* 

* drop adjust out of renew range
gen temp =1 if adjust==1 & renew==0
by tu_consumer_id open_mon tu_trade_id: egen temp2 = mean(temp)
drop if temp2==1 
drop temp* 

* post-renew indicator
by tu_consumer_id open_mon tu_trade_id: gen postrenew = sum(renew) 

* vrm and frm
sort tu_consumer_id open_mon tu_trade_id postrenew rep_mon
  by tu_consumer_id open_mon tu_trade_id postrenew: gen vrmpay = (renew==0 & terms_amt!=terms_amt[_n-1] & terms_amt>0 & terms_amt!=. & terms_amt[_n-1]>0 & terms_amt[_n-1]!=. &_n!=1) 
by tu_consumer_id open_mon tu_trade_id postrenew: egen nvrmpay_within = sum(vrmpay)

gen vrm_within = (nvrmpay_within>0) 

by tu_consumer_id open_mon tu_trade_id postrenew: gen temp=(_n==1)
by tu_consumer_id open_mon tu_trade_id: egen nterm=sum(temp) 
drop temp 

by tu_consumer_id open_mon tu_trade_id postrenew: gen temp=(_n==1 & vrm_within==1)
by tu_consumer_id open_mon tu_trade_id: egen temp2 = sum(temp)

gen vrm=(nterm==temp2) 
gen frm=(temp2==0)
gen mixloan = 1-frm-vrm 

drop temp* vrmpay *within nterm 

* 3-step impute rates
  * (1) formular: b(t)=(1+r)b(t-1)-M (annualized effective rate)
by tu_consumer_id open_mon tu_trade_id:     gen imputer = 100*12*((current_ba+terms_amt)/current_ba[_n-1]-1) if current_ba>0 & terms_amt>0 & current_ba[_n-1]>0

// Case 1: current ba are either not changing or increase (imputer too high)
by tu_consumer_id open_mon tu_trade_id: gen test1 = (current_ba>=current_ba[_n-1] & current_ba!=. & current_ba[_n-1]!=. & current_ba>0 & current_ba[_n-1]>0)
replace imputer = . if test1==1 & rep_mon!=m(2018m6)

// Case 2: prepay too much (balance reduces more than 0.9*terms_amt)
by tu_consumer_id open_mon tu_trade_id: gen test2 = ((current_ba[_n-1]-current_ba)>0.9*terms_amt & terms_amt!=. & terms_amt>0 & current_ba!=. & current_ba[_n-1]!=. & current_ba>0 & current_ba[_n-1]>0)
replace imputer = . if test2==1

// Case 3: terms_amt =0.
replace imputer = . if terms_amt==0

  * (2) drop loans with median r too low or too high
sort tu_consumer_id open_mon tu_trade_id postrenew rep_mon 
  by tu_consumer_id open_mon tu_trade_id postrenew: egen medr = median(imputer)

  by tu_consumer_id open_mon tu_trade_id: egen minmed = min(medr) 
  by tu_consumer_id open_mon tu_trade_id: egen maxmed = max(medr) 

sum medr,d
gen lb = r(p1)  
gen ub = r(p99)  
drop if minmed<=lb 
drop if maxmed>=ub 

* # of renewals per account
by tu_consumer_id open_mon tu_trade_id: egen nrenew = sum(renew) 

* month of actual renew
gen temp =rep_mon if renew==1 & nrenew==1
by tu_consumer_id open_mon tu_trade_id: egen renew_mon = mean(temp) 
format renew_mon %tm
drop temp

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==2
by tu_consumer_id open_mon tu_trade_id: egen renew21_mon = mean(temp) 
format renew21_mon %tm
drop temp

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen renew31_mon = mean(temp) 
format renew31_mon %tm
drop temp

* month of scheduled renew
by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 & nrenew==1
by tu_consumer_id open_mon tu_trade_id: egen schrenew = mean(temp)
format schrenew %tm
drop temp

by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 &postrenew==1 & nrenew==2
by tu_consumer_id open_mon tu_trade_id: egen schrenew21 = mean(temp)
format schrenew21 %tm
drop temp

by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 &postrenew==1 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen schrenew31 = mean(temp)
format schrenew31 %tm
drop temp

* for figure (time diff between actual and scheduled renew)
gen diff = renew_mon-schrenew
replace diff = renew21_mon-schrenew21 if diff==.
replace diff = renew31_mon-schrenew31 if diff==.

tab diff 
