clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

* 2-YR TERM 
use borrower_statistics_dataset_rate_increase.dta,clear

keep if frm==1

keep if inlist(term,24)

keep if reset_mon>=m(2012m7)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

drop if postrenew_reco==. 

sort tu_consumer_id open_mon tu_trade_id month
by tu_consumer_id open_mon tu_trade_id: gen dyn_postrenew = sum(postrenew_reco)
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 100 if dyn_postrenew[_n+1]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 200 if dyn_postrenew[_n+2]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 300 if dyn_postrenew[_n+3]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 400 if dyn_postrenew[_n+4]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 500 if dyn_postrenew[_n+5]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 600 if dyn_postrenew[_n+6]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 700 if dyn_postrenew[_n+7]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 800 if dyn_postrenew[_n+8]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 900 if dyn_postrenew[_n+9]==1

tab dyn_postrenew 

gen dyn_qt = dyn_postrenew
replace dyn_qt = 1 if inlist(dyn_postrenew,1,2,3)
replace dyn_qt = 2 if inlist(dyn_postrenew,4,5,6)
replace dyn_qt = 3 if inlist(dyn_postrenew,7,8,9)
replace dyn_qt = 4 if inlist(dyn_postrenew,10,11,12)
replace dyn_qt = 5 if inlist(dyn_postrenew,13,14,15)
replace dyn_qt = 6 if dyn_postrenew>=16 & dyn_postrenew!=.

replace dyn_qt = 100 if inlist(dyn_postrenew,100,200,300)
replace dyn_qt = 200 if inlist(dyn_postrenew,400,500,600)
replace dyn_qt = 300 if inlist(dyn_postrenew,700,800,900)
tab dyn_qt

replace dyn_qt = 400 if dyn_qt==0
replace dyn_qt = 0 if dyn_qt==100

foreach x of varlist bc33 by33{
foreach tt of numlist 24{
quietly xtreg `x' i.dyn_qt lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_dyn_`tt'
}
}

estimates table bc33_dyn_24 by33_dyn_24,keep(300.dyn_qt 200.dyn_qt 1.dyn_qt 2.dyn_qt 3.dyn_qt 4.dyn_qt 5.dyn_qt) b(%7.3f) se(%7.3f) stats(N)

* 5-YR TERM 
use borrower_statistics_dataset_rate_increase.dta,clear

keep if frm==1

keep if inlist(term,60)

keep if reset_mon>=m(2013m2)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

drop if postrenew_reco==. 

sort tu_consumer_id open_mon tu_trade_id month
by tu_consumer_id open_mon tu_trade_id: gen dyn_postrenew = sum(postrenew_reco)
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 100 if dyn_postrenew[_n+1]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 200 if dyn_postrenew[_n+2]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 300 if dyn_postrenew[_n+3]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 400 if dyn_postrenew[_n+4]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 500 if dyn_postrenew[_n+5]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 600 if dyn_postrenew[_n+6]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 700 if dyn_postrenew[_n+7]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 800 if dyn_postrenew[_n+8]==1
by tu_consumer_id open_mon tu_trade_id: replace dyn_postrenew= 900 if dyn_postrenew[_n+9]==1

tab dyn_postrenew 

gen dyn_qt = dyn_postrenew
replace dyn_qt = 1 if inlist(dyn_postrenew,1,2,3)
replace dyn_qt = 2 if inlist(dyn_postrenew,4,5,6)
replace dyn_qt = 3 if inlist(dyn_postrenew,7,8,9)
replace dyn_qt = 4 if inlist(dyn_postrenew,10,11,12)
replace dyn_qt = 5 if inlist(dyn_postrenew,13,14,15)
replace dyn_qt = 6 if dyn_postrenew>=16 & dyn_postrenew!=.

replace dyn_qt = 100 if inlist(dyn_postrenew,100,200,300)
replace dyn_qt = 200 if inlist(dyn_postrenew,400,500,600)
replace dyn_qt = 300 if inlist(dyn_postrenew,700,800,900)
tab dyn_qt

replace dyn_qt = 400 if dyn_qt==0
replace dyn_qt = 0 if dyn_qt==100

* Regressions
foreach x of varlist bc33 by33{
foreach tt of numlist 60{
quietly xtreg `x' i.dyn_qt lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_dyn_`tt'
}
}

estimates table bc33_dyn_60 by33_dyn_60,keep(300.dyn_qt 200.dyn_qt 1.dyn_qt 2.dyn_qt 3.dyn_qt 4.dyn_qt 5.dyn_qt) b(%7.3f) se(%7.3f) stats(N)
