clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use data.dta, clear

* adjust (change maturity month)
gen adjust = (mat_mon!=l.mat_mon)

* renew as scheduled 
gen renew = (adjust==1 & rep_mon>=l.mat_mon-6 & rep_mon<=l.mat_mon+6)

* Post-renew indicator
sort tu_consumer_id open_mon tu_trade_id rep_mon
by tu_consumer_id open_mon tu_trade_id: gen postrenew = sum(renew) 

xtset tu_trade_id rep_mon
gen vrmpay = (renew==0 & terms_amt!=l.terms_amt & terms_amt>0 & terms_amt!=. & l.terms_amt>0 & l.terms_amt!=.) 

  sort tu_consumer_id open_mon tu_trade_id postrenew rep_mon
by tu_consumer_id open_mon tu_trade_id postrenew: egen nvrmpay_within = sum(vrmpay)
gen vrm_within = (nvrmpay_within>0) 

gen vrm=(vrm_within==1) 
tab vrm 

drop vrmpay *within 

* 3-step impute rates
  * (1) formula: b(t)=(1+r)b(t-1)-M (annualized effective rate)
xtset tu_trade_id rep_mon
  gen imputer_m = 100*((current_ba+terms_amt)/l.current_ba-1) if current_ba>0 & terms_amt>0 & l.current_ba>0

// Case 1: current ba are either not changing or increase (imputer too high)
xtset tu_trade_id rep_mon
gen test1 = (current_ba>=l.current_ba & current_ba!=. & l.current_ba!=. & current_ba>0 & l.current_ba>0)
replace imputer_m = . if test1==1

// Case 2: prepay too much (balance reduces more than 0.9*terms_amt)
xtset tu_trade_id rep_mon
gen test2 = ((l.current_ba-current_ba)>0.9*terms_amt & terms_amt!=. & terms_amt>0 & current_ba!=. & l.current_ba!=. & current_ba>0 & l.current_ba>0)
replace imputer_m = . if test2==1

// Case 3: terms_amt =0.
replace imputer_m = . if terms_amt==0

  * (2) drop loans with median r too low or too high
sort tu_consumer_id open_mon tu_trade_id postrenew rep_mon
  by tu_consumer_id open_mon tu_trade_id postrenew: egen medr_m = median(imputer_m)
  
* for frm mortgages
  by tu_consumer_id open_mon tu_trade_id: egen minmed = min(medr_m) 
  by tu_consumer_id open_mon tu_trade_id: egen maxmed = max(medr_m) 

sum medr_m,d
gen lb = r(p1)  
gen ub = r(p99)  
drop if minmed<=lb 
drop if maxmed>=ub 

* interest rates - quoted rates for comparison with OSFI and median disc rates
gen rate = 2*((1+ medr_m/100)^6-1)*100 if vrm==0
replace rate = imputer_m*12 if vrm==1 
replace rate = 2*((1+ medr_m/100)^6-1)*100 if ((imputer<=lb|imputer>=ub) & vrm==1)
replace rate =. if test1==1|terms_amt==.

drop minmed maxmed lb ub imputer medr test1 test2

* # of renewals per account
by tu_consumer_id open_mon tu_trade_id: egen nrenew = sum(renew) 

* single variable for all renewal dates
gen renew_all = open_mon if postrenew==0 

* month of actual renew 
gen temp =rep_mon if renew==1 & nrenew==1
by tu_consumer_id open_mon tu_trade_id: egen renew_mon = mean(temp) 
format renew_mon %tm
drop temp

replace renew_all = renew_mon if postrenew==1 & nrenew==1
drop renew_mon

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==2
by tu_consumer_id open_mon tu_trade_id: egen renew21_mon = mean(temp) 
format renew21_mon %tm
drop temp

replace renew_all = renew21_mon if postrenew==1 & nrenew==2
drop renew21_mon

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==2
by tu_consumer_id open_mon tu_trade_id: egen renew22_mon = mean(temp) 
format renew22_mon %tm
drop temp

replace renew_all = renew22_mon if postrenew==2 & nrenew==2
drop renew22_mon

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen renew31_mon = mean(temp) 
format renew31_mon %tm
drop temp

replace renew_all = renew31_mon if postrenew==1 & nrenew==3
drop renew31_mon

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen renew32_mon = mean(temp) 
format renew32_mon %tm
drop temp

replace renew_all = renew32_mon if postrenew==2 & nrenew==3
drop renew32_mon

gen temp =rep_mon if renew==1 & postrenew==3 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen renew33_mon = mean(temp) 
format renew33_mon %tm
drop temp

replace renew_all = renew33_mon if postrenew==3 & nrenew==3
drop renew33_mon

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==4
by tu_consumer_id open_mon tu_trade_id: egen renew41_mon = mean(temp) 
format renew41_mon %tm
drop temp

replace renew_all = renew41_mon if postrenew==1 & nrenew==4
drop renew41_mon

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==4
by tu_consumer_id open_mon tu_trade_id: egen renew42_mon = mean(temp) 
format renew42_mon %tm
drop temp

replace renew_all = renew42_mon if postrenew==2 & nrenew==4
drop renew42_mon

gen temp =rep_mon if renew==1 & postrenew==3 & nrenew==4
by tu_consumer_id open_mon tu_trade_id: egen renew43_mon = mean(temp) 
format renew43_mon %tm
drop temp

replace renew_all = renew43_mon if postrenew==3 & nrenew==4
drop renew43_mon

gen temp =rep_mon if renew==1 & postrenew==4 & nrenew==4
by tu_consumer_id open_mon tu_trade_id: egen renew44_mon = mean(temp) 
format renew44_mon %tm
drop temp

replace renew_all = renew44_mon if postrenew==4 & nrenew==4
drop renew44_mon

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==5
by tu_consumer_id open_mon tu_trade_id: egen renew51_mon = mean(temp) 
format renew51_mon %tm
drop temp

replace renew_all = renew51_mon if postrenew==1 & nrenew==5
drop renew51_mon

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==5
by tu_consumer_id open_mon tu_trade_id: egen renew52_mon = mean(temp) 
format renew52_mon %tm
drop temp

replace renew_all = renew52_mon if postrenew==2 & nrenew==5
drop renew52_mon

gen temp =rep_mon if renew==1 & postrenew==3 & nrenew==5
by tu_consumer_id open_mon tu_trade_id: egen renew53_mon = mean(temp) 
format renew53_mon %tm
drop temp

replace renew_all = renew53_mon if postrenew==3 & nrenew==5
drop renew53_mon

gen temp =rep_mon if renew==1 & postrenew==4 & nrenew==5
by tu_consumer_id open_mon tu_trade_id: egen renew54_mon = mean(temp) 
format renew54_mon %tm
drop temp

replace renew_all = renew54_mon if postrenew==4 & nrenew==5
drop renew54_mon

gen temp =rep_mon if renew==1 & postrenew==5 & nrenew==5
by tu_consumer_id open_mon tu_trade_id: egen renew55_mon = mean(temp) 
format renew55_mon %tm
drop temp

replace renew_all = renew55_mon if postrenew==5 & nrenew==5
drop renew55_mon

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==6
by tu_consumer_id open_mon tu_trade_id: egen renew61_mon = mean(temp) 
format renew61_mon %tm
drop temp

replace renew_all = renew61_mon if postrenew==1 & nrenew==6
drop renew61_mon

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==6
by tu_consumer_id open_mon tu_trade_id: egen renew62_mon = mean(temp) 
format renew62_mon %tm
drop temp

replace renew_all = renew62_mon if postrenew==2 & nrenew==6
drop renew62_mon

gen temp =rep_mon if renew==1 & postrenew==3 & nrenew==6
by tu_consumer_id open_mon tu_trade_id: egen renew63_mon = mean(temp) 
format renew63_mon %tm
drop temp

replace renew_all = renew63_mon if postrenew==3 & nrenew==6
drop renew63_mon

gen temp =rep_mon if renew==1 & postrenew==4 & nrenew==6
by tu_consumer_id open_mon tu_trade_id: egen renew64_mon = mean(temp) 
format renew64_mon %tm
drop temp

replace renew_all = renew64_mon if postrenew==4 & nrenew==6
drop renew64_mon

gen temp =rep_mon if renew==1 & postrenew==5 & nrenew==6
by tu_consumer_id open_mon tu_trade_id: egen renew65_mon = mean(temp) 
format renew65_mon %tm
drop temp

replace renew_all = renew65_mon if postrenew==5 & nrenew==6
drop renew65_mon

gen temp =rep_mon if renew==1 & postrenew==6 & nrenew==6
by tu_consumer_id open_mon tu_trade_id: egen renew66_mon = mean(temp) 
format renew66_mon %tm
drop temp

replace renew_all = renew66_mon if postrenew==6 & nrenew==6
drop renew66_mon

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==7
by tu_consumer_id open_mon tu_trade_id: egen renew71_mon = mean(temp) 
format renew71_mon %tm
drop temp

replace renew_all = renew71_mon if postrenew==1 & nrenew==7
drop renew71_mon

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==7
by tu_consumer_id open_mon tu_trade_id: egen renew72_mon = mean(temp) 
format renew72_mon %tm
drop temp

replace renew_all = renew72_mon if postrenew==2 & nrenew==7
drop renew72_mon

gen temp =rep_mon if renew==1 & postrenew==3 & nrenew==7
by tu_consumer_id open_mon tu_trade_id: egen renew73_mon = mean(temp) 
format renew73_mon %tm
drop temp

replace renew_all = renew73_mon if postrenew==3 & nrenew==7
drop renew73_mon

gen temp =rep_mon if renew==1 & postrenew==4 & nrenew==7
by tu_consumer_id open_mon tu_trade_id: egen renew74_mon = mean(temp) 
format renew74_mon %tm
drop temp

replace renew_all = renew74_mon if postrenew==4 & nrenew==7
drop renew74_mon

gen temp =rep_mon if renew==1 & postrenew==5 & nrenew==7
by tu_consumer_id open_mon tu_trade_id: egen renew75_mon = mean(temp) 
format renew75_mon %tm
drop temp

replace renew_all = renew75_mon if postrenew==5 & nrenew==7
drop renew75_mon

gen temp =rep_mon if renew==1 & postrenew==6 & nrenew==7
by tu_consumer_id open_mon tu_trade_id: egen renew76_mon = mean(temp) 
format renew76_mon %tm
drop temp

replace renew_all = renew76_mon if postrenew==6 & nrenew==7
drop renew76_mon

gen temp =rep_mon if renew==1 & postrenew==7 & nrenew==7
by tu_consumer_id open_mon tu_trade_id: egen renew77_mon = mean(temp) 
format renew77_mon %tm
drop temp

replace renew_all = renew77_mon if postrenew==7 & nrenew==7
drop renew77_mon

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==8
by tu_consumer_id open_mon tu_trade_id: egen renew81_mon = mean(temp) 
format renew81_mon %tm
drop temp

replace renew_all = renew81_mon if postrenew==1 & nrenew==8
drop renew81_mon

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==8
by tu_consumer_id open_mon tu_trade_id: egen renew82_mon = mean(temp) 
format renew82_mon %tm
drop temp

replace renew_all = renew82_mon if postrenew==2 & nrenew==8
drop renew82_mon

gen temp =rep_mon if renew==1 & postrenew==3 & nrenew==8
by tu_consumer_id open_mon tu_trade_id: egen renew83_mon = mean(temp) 
format renew83_mon %tm
drop temp

replace renew_all = renew83_mon if postrenew==3 & nrenew==8
drop renew83_mon

gen temp =rep_mon if renew==1 & postrenew==4 & nrenew==8
by tu_consumer_id open_mon tu_trade_id: egen renew84_mon = mean(temp) 
format renew84_mon %tm
drop temp

replace renew_all = renew84_mon if postrenew==4 & nrenew==8
drop renew84_mon

gen temp =rep_mon if renew==1 & postrenew==5 & nrenew==8
by tu_consumer_id open_mon tu_trade_id: egen renew85_mon = mean(temp) 
format renew85_mon %tm
drop temp

replace renew_all = renew85_mon if postrenew==5 & nrenew==8
drop renew85_mon

gen temp =rep_mon if renew==1 & postrenew==6 & nrenew==8
by tu_consumer_id open_mon tu_trade_id: egen renew86_mon = mean(temp) 
format renew86_mon %tm
drop temp

replace renew_all = renew86_mon if postrenew==6 & nrenew==8
drop renew86_mon

gen temp =rep_mon if renew==1 & postrenew==7 & nrenew==8
by tu_consumer_id open_mon tu_trade_id: egen renew87_mon = mean(temp) 
format renew87_mon %tm
drop temp

replace renew_all = renew87_mon if postrenew==7 & nrenew==8
drop renew87_mon

gen temp =rep_mon if renew==1 & postrenew==8 & nrenew==8
by tu_consumer_id open_mon tu_trade_id: egen renew88_mon = mean(temp) 
format renew88_mon %tm
drop temp

replace renew_all = renew88_mon if postrenew==8 & nrenew==8
drop renew88_mon

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==9
by tu_consumer_id open_mon tu_trade_id: egen renew91_mon = mean(temp) 
format renew91_mon %tm
drop temp

replace renew_all = renew91_mon if postrenew==1 & nrenew==9
drop renew91_mon

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==9
by tu_consumer_id open_mon tu_trade_id: egen renew92_mon = mean(temp) 
format renew92_mon %tm
drop temp

replace renew_all = renew92_mon if postrenew==2 & nrenew==9
drop renew92_mon

gen temp =rep_mon if renew==1 & postrenew==3 & nrenew==9
by tu_consumer_id open_mon tu_trade_id: egen renew93_mon = mean(temp) 
format renew93_mon %tm
drop temp

replace renew_all = renew93_mon if postrenew==3 & nrenew==9
drop renew93_mon

gen temp =rep_mon if renew==1 & postrenew==4 & nrenew==9
by tu_consumer_id open_mon tu_trade_id: egen renew94_mon = mean(temp) 
format renew94_mon %tm
drop temp

replace renew_all = renew94_mon if postrenew==4 & nrenew==9
drop renew94_mon

gen temp =rep_mon if renew==1 & postrenew==5 & nrenew==9
by tu_consumer_id open_mon tu_trade_id: egen renew95_mon = mean(temp) 
format renew95_mon %tm
drop temp

replace renew_all = renew95_mon if postrenew==5 & nrenew==9
drop renew95_mon

gen temp =rep_mon if renew==1 & postrenew==6 & nrenew==9
by tu_consumer_id open_mon tu_trade_id: egen renew96_mon = mean(temp) 
format renew96_mon %tm
drop temp

replace renew_all = renew96_mon if postrenew==6 & nrenew==9
drop renew96_mon

gen temp =rep_mon if renew==1 & postrenew==7 & nrenew==9
by tu_consumer_id open_mon tu_trade_id: egen renew97_mon = mean(temp) 
format renew97_mon %tm
drop temp

replace renew_all = renew97_mon if postrenew==7 & nrenew==9
drop renew97_mon

gen temp =rep_mon if renew==1 & postrenew==8 & nrenew==9
by tu_consumer_id open_mon tu_trade_id: egen renew98_mon = mean(temp) 
format renew98_mon %tm
drop temp

replace renew_all = renew98_mon if postrenew==8 & nrenew==9
drop renew98_mon

gen temp =rep_mon if renew==1 & postrenew==9 & nrenew==9
by tu_consumer_id open_mon tu_trade_id: egen renew99_mon = mean(temp) 
format renew99_mon %tm
drop temp

replace renew_all = renew99_mon if postrenew==9 & nrenew==9
drop renew99_mon

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==10
by tu_consumer_id open_mon tu_trade_id: egen renew101_mon = mean(temp) 
format renew101_mon %tm
drop temp

replace renew_all = renew101_mon if postrenew==1 & nrenew==10
drop renew101_mon

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==10
by tu_consumer_id open_mon tu_trade_id: egen renew102_mon = mean(temp) 
format renew102_mon %tm
drop temp

replace renew_all = renew102_mon if postrenew==2 & nrenew==10
drop renew102_mon

gen temp =rep_mon if renew==1 & postrenew==3 & nrenew==10
by tu_consumer_id open_mon tu_trade_id: egen renew103_mon = mean(temp) 
format renew103_mon %tm
drop temp

replace renew_all = renew103_mon if postrenew==3 & nrenew==10
drop renew103_mon

gen temp =rep_mon if renew==1 & postrenew==4 & nrenew==10
by tu_consumer_id open_mon tu_trade_id: egen renew104_mon = mean(temp) 
format renew104_mon %tm
drop temp

replace renew_all = renew104_mon if postrenew==4 & nrenew==10
drop renew104_mon

gen temp =rep_mon if renew==1 & postrenew==5 & nrenew==10
by tu_consumer_id open_mon tu_trade_id: egen renew105_mon = mean(temp) 
format renew105_mon %tm
drop temp

replace renew_all = renew105_mon if postrenew==5 & nrenew==10
drop renew105_mon

gen temp =rep_mon if renew==1 & postrenew==6 & nrenew==10
by tu_consumer_id open_mon tu_trade_id: egen renew106_mon = mean(temp) 
format renew106_mon %tm
drop temp

replace renew_all = renew106_mon if postrenew==6 & nrenew==10
drop renew106_mon

gen temp =rep_mon if renew==1 & postrenew==7 & nrenew==10
by tu_consumer_id open_mon tu_trade_id: egen renew107_mon = mean(temp) 
format renew107_mon %tm
drop temp

replace renew_all = renew107_mon if postrenew==7 & nrenew==10
drop renew107_mon

gen temp =rep_mon if renew==1 & postrenew==8 & nrenew==10
by tu_consumer_id open_mon tu_trade_id: egen renew108_mon = mean(temp) 
format renew108_mon %tm
drop temp

replace renew_all = renew108_mon if postrenew==8 & nrenew==10
drop renew108_mon

gen temp =rep_mon if renew==1 & postrenew==9 & nrenew==10
by tu_consumer_id open_mon tu_trade_id: egen renew109_mon = mean(temp) 
format renew109_mon %tm
drop temp

replace renew_all = renew109_mon if postrenew==9 & nrenew==10
drop renew109_mon

gen temp =rep_mon if renew==1 & postrenew==10 & nrenew==10
by tu_consumer_id open_mon tu_trade_id: egen renew1010_mon = mean(temp) 
format renew1010_mon %tm
drop temp

replace renew_all = renew1010_mon if postrenew==10 & nrenew==10
drop renew1010_mon

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==11
by tu_consumer_id open_mon tu_trade_id: egen renew111_mon = mean(temp) 
format renew111_mon %tm
drop temp

replace renew_all = renew111_mon if postrenew==1 & nrenew==11
drop renew111_mon

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==11
by tu_consumer_id open_mon tu_trade_id: egen renew112_mon = mean(temp) 
format renew112_mon %tm
drop temp

replace renew_all = renew112_mon if postrenew==2 & nrenew==11
drop renew112_mon

gen temp =rep_mon if renew==1 & postrenew==3 & nrenew==11
by tu_consumer_id open_mon tu_trade_id: egen renew113_mon = mean(temp) 
format renew113_mon %tm
drop temp

replace renew_all = renew113_mon if postrenew==3 & nrenew==11
drop renew113_mon

gen temp =rep_mon if renew==1 & postrenew==4 & nrenew==11
by tu_consumer_id open_mon tu_trade_id: egen renew114_mon = mean(temp) 
format renew114_mon %tm
drop temp

replace renew_all = renew114_mon if postrenew==4 & nrenew==11
drop renew114_mon

gen temp =rep_mon if renew==1 & postrenew==5 & nrenew==11
by tu_consumer_id open_mon tu_trade_id: egen renew115_mon = mean(temp) 
format renew115_mon %tm
drop temp

replace renew_all = renew115_mon if postrenew==5 & nrenew==11
drop renew115_mon

gen temp =rep_mon if renew==1 & postrenew==6 & nrenew==11
by tu_consumer_id open_mon tu_trade_id: egen renew116_mon = mean(temp) 
format renew116_mon %tm
drop temp

replace renew_all = renew116_mon if postrenew==6 & nrenew==11
drop renew116_mon

gen temp =rep_mon if renew==1 & postrenew==7 & nrenew==11
by tu_consumer_id open_mon tu_trade_id: egen renew117_mon = mean(temp) 
format renew117_mon %tm
drop temp

replace renew_all = renew117_mon if postrenew==7 & nrenew==11
drop renew117_mon

gen temp =rep_mon if renew==1 & postrenew==8 & nrenew==11
by tu_consumer_id open_mon tu_trade_id: egen renew118_mon = mean(temp) 
format renew118_mon %tm
drop temp

replace renew_all = renew118_mon if postrenew==8 & nrenew==11
drop renew118_mon

gen temp =rep_mon if renew==1 & postrenew==9 & nrenew==11
by tu_consumer_id open_mon tu_trade_id: egen renew119_mon = mean(temp) 
format renew119_mon %tm
drop temp

replace renew_all = renew119_mon if postrenew==9 & nrenew==11
drop renew119_mon

gen temp =rep_mon if renew==1 & postrenew==10 & nrenew==11
by tu_consumer_id open_mon tu_trade_id: egen renew1110_mon = mean(temp) 
format renew1110_mon %tm
drop temp

replace renew_all = renew1110_mon if postrenew==10 & nrenew==11
drop renew1110_mon

gen temp =rep_mon if renew==1 & postrenew==11 & nrenew==11
by tu_consumer_id open_mon tu_trade_id: egen renew1111_mon = mean(temp) 
format renew1111_mon %tm
drop temp

replace renew_all = renew1111_mon if postrenew==11 & nrenew==11
drop renew1111_mon

* interest rates 
display "60m mortgages - insured and uninsured, FRM"
foreach num of numlist 528/717 {
qui sum open_rate if (open_mon==`num' & current_term==60 ), detail 
mat n`num'= r(p50), r(mean)
mat list n`num'
mat rownames n`num'= n`num'  
}
mat intrtstats= n528\n529\n530\n531\n532\n533\n534\n535\n536\n537\n538\n539\n540\n541\n542\n543\n544\n545\n546\n547\n548\n549\n550\n551\n552\n553\n554\n555\n556\n557\n558\n559\n560\n561\n562\n563\n564\n565\n566\n567\n568\n569\n570\n571\n572\n573\n574\n575\n576\n577\n578\n579\n580\n581\n582\n583\n584\n585\n586\n587\n588\n589\n590\n591\n592\n593\n594\n595\n596\n597\n598\n599\n600\n601\n602\n603\n604\n605\n606\n607\n608\n609\n610\n611\n612\n613\n614\n615\n616\n617\n618\n619\n620\n621\n622\n623\n624\n625\n626\n627\n628\n629\n630\n631\n632\n633\n634\n635\n636\n637\n638\n639\n640\n641\n642\n643\n644\n645\n646\n647\n648\n649\n650\n651\n652\n653\n654\n655\n656\n657\n658\n659\n660\n661\n662\n663\n664\n665\n666\n667\n668\n669\n670\n671\n672\n673\n674\n675\n676\n677\n678\n679\n680\n681\n682\n683\n684\n685\n686\n687\n688\n689\n690\n691\n692\n693\n694\n695\n696\n697\n698\n699\n700\n701\n702\n703\n704\n705\n706\n707\n708\n709\n710\n711\n712\n713\n714\n715\n716\n717
mat colnames intrtstats = Median Mean
mat list intrtstats

display "60m mortgages - insured, FRM"
foreach num of numlist 528/717 {
qui sum open_rate if (open_mon==`num' & current_term==60 & insurance_indicator=="Y"), detail 
mat n`num'= r(p50),r(mean)
mat list n`num'
mat rownames n`num'= n`num'  
}
mat intrtstats= n528\n529\n530\n531\n532\n533\n534\n535\n536\n537\n538\n539\n540\n541\n542\n543\n544\n545\n546\n547\n548\n549\n550\n551\n552\n553\n554\n555\n556\n557\n558\n559\n560\n561\n562\n563\n564\n565\n566\n567\n568\n569\n570\n571\n572\n573\n574\n575\n576\n577\n578\n579\n580\n581\n582\n583\n584\n585\n586\n587\n588\n589\n590\n591\n592\n593\n594\n595\n596\n597\n598\n599\n600\n601\n602\n603\n604\n605\n606\n607\n608\n609\n610\n611\n612\n613\n614\n615\n616\n617\n618\n619\n620\n621\n622\n623\n624\n625\n626\n627\n628\n629\n630\n631\n632\n633\n634\n635\n636\n637\n638\n639\n640\n641\n642\n643\n644\n645\n646\n647\n648\n649\n650\n651\n652\n653\n654\n655\n656\n657\n658\n659\n660\n661\n662\n663\n664\n665\n666\n667\n668\n669\n670\n671\n672\n673\n674\n675\n676\n677\n678\n679\n680\n681\n682\n683\n684\n685\n686\n687\n688\n689\n690\n691\n692\n693\n694\n695\n696\n697\n698\n699\n700\n701\n702\n703\n704\n705\n706\n707\n708\n709\n710\n711\n712\n713\n714\n715\n716\n717
mat colnames intrtstats = Median Mean
mat list intrtstats

display "60m mortgages - uninsured, FRM"
foreach num of numlist 528/717 {
qui sum open_rate if (open_mon==`num' & current_term==60 & insurance_indicator=="N"), detail 
mat n`num'= r(p50), r(mean)
mat list n`num'
mat rownames n`num'= n`num'  
}
mat intrtstats= n528\n529\n530\n531\n532\n533\n534\n535\n536\n537\n538\n539\n540\n541\n542\n543\n544\n545\n546\n547\n548\n549\n550\n551\n552\n553\n554\n555\n556\n557\n558\n559\n560\n561\n562\n563\n564\n565\n566\n567\n568\n569\n570\n571\n572\n573\n574\n575\n576\n577\n578\n579\n580\n581\n582\n583\n584\n585\n586\n587\n588\n589\n590\n591\n592\n593\n594\n595\n596\n597\n598\n599\n600\n601\n602\n603\n604\n605\n606\n607\n608\n609\n610\n611\n612\n613\n614\n615\n616\n617\n618\n619\n620\n621\n622\n623\n624\n625\n626\n627\n628\n629\n630\n631\n632\n633\n634\n635\n636\n637\n638\n639\n640\n641\n642\n643\n644\n645\n646\n647\n648\n649\n650\n651\n652\n653\n654\n655\n656\n657\n658\n659\n660\n661\n662\n663\n664\n665\n666\n667\n668\n669\n670\n671\n672\n673\n674\n675\n676\n677\n678\n679\n680\n681\n682\n683\n684\n685\n686\n687\n688\n689\n690\n691\n692\n693\n694\n695\n696\n697\n698\n699\n700\n701\n702\n703\n704\n705\n706\n707\n708\n709\n710\n711\n712\n713\n714\n715\n716\n717
mat colnames intrtstats = Median Mean
mat list intrtstats
