clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use producttype filingdate ratetype lender purpose purpose_recode outstanding_osfi appraisalvalue authorized income_osfi year birth loanterm insurance intrate bureauscore ltvratio using "osfi.dta", clear 

tab lender // market share 

gen filing_mon = mofd(filingdate)
format filing_mon %tm 

keep if filing_mon>=m(2014m1) & filing_mon<=m(2018m9)
tab lender 
drop if producttype=="HELOC"|producttype=="HELOC+HELOC"|producttype=="Mortgage+HELOC"
keep if purpose=="Purchase"
keep if ratetype=="Fixed" 
tab lender 

gen sample = (lender=="X")
tab sample

* loanterm 
gen term5 = (loanterm==5) 
tab term5 

gen ins = (insurance=="Insured")
tab ins 

table filing_mon if term5==1 & ins==1 & sample==1, c(med intrate)
table filing_mon if term5==1 & ins==0 & sample==1, c(med intrate)
