clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use producttype filingdate ratetype lender purpose outstanding_osfi income_osfi year birth loanterm insurance intrate bureauscore ltvratio using "osfi.dta", clear 

gen filing_mon = mofd(filingdate)
format filing_mon %tm 

keep if filing_mon>=m(2014m1) & filing_mon<=m(2018m9)
tab lender 
drop if producttype=="HELOC"|producttype=="HELOC+HELOC"|producttype=="Mortgage+HELOC"
keep if purpose=="Purchase"
keep if ratetype=="Fixed" 
tab lender 

gen sample = (lender=="X")
tab sample

* dti
gen lti_outs_comp_osfi = outstanding_osfi/income_osfi*100

* age at origination 
gen age_at_orig = year - birth 
tab age_at_orig,m

* loanterm 
gen term5 = (loanterm==5) 
tab term5 

gen ins = (insurance=="Insured")
tab ins 

mean sample 
table sample, c(mean intrate med intrate)
table sample, c(mean outstanding_osfi med outstanding_osfi)
table sample, c(mean ltvratio med ltvratio)
table sample, c(mean lti_outs_comp_osfi med lti_outs_comp_osfi)
table sample, c(mean bureauscore med bureauscore)
table sample, c(mean age_at_orig med age_at_orig)
table sample, c(mean ins)
table sample, c(mean term5)








