clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use CSCE_cleanMicrodata.dta,clear

* reformat survey quarter
sort Survey_Quarter RESPID
by Survey_Quarter: gen temp=(_n==1)
gen temp2=sum(temp)
gen quarter = q(2014q3)+temp2
format quarter %tq

tab quarter
drop if quarter==q(2019q3)
drop if quarter==q(2014q4)

* housing status
keep if Q6_13==1|Q6_13==2  //mortgage borrowers (frm or vrm)
gen frm   = (Q6_13==1)
gen mover = (Q6_8<=1)  // live in primary residence <=1 year

    gen status = 0 if frm==1 & mover==0
replace status = 1 if frm==0 & mover==0
replace status = 2 if mover==1

gen frm_nonmover = (frm==1 & mover==0)
gen nonfrm_nonmover = (frm==0 & mover==0)

* over the last 12 months, how interest rates have changed
gen pastup=(Q2_3==4|Q2_3==5)  //risen a lot/a little
table quarter,c(mean pastup sd pastup)

gen pastdn=(Q2_3==1|Q2_3==2)  //fall a lot/a little
table quarter,c(mean pastdn sd pastdn)

gen pastdnsame = (Q2_3==1|Q2_3==2|Q2_3==3)
gen pastsame = (Q2_3==3)

* (II) next 12 month expectation (how likely the average interest rate will be higher)
replace Q2_4 =. if Q2_4>100
replace Q2_4 = 100 - Q2_4 if QCQ4==2 & quarter>=q(2018q4)
replace Q2_4 = 100 - Q2_4 if QCQ2==2 & quarter<=q(2018q3)

* measuring expectations: expect rates more likely (prob>0.5) to rise
gen exphi = 1 if Q2_4>50 & Q2_4<=100
replace exphi = 0 if Q2_4<=50

gen expnonhi = 1 - exphi 

* demographics
gen age = Q6_1
gen male= (Q6_2==1)
gen married = (Q6_5==1)
gen educat = Q6_3

tab educat
gen bachplus = (Q6_3>=6) if Q6_3!=99

gen period = 0 if quarter<q(2017q1)
replace period = 1 if quarter>=q(2017q3)

* panel identifiers 
egen id = group(panelistid) 
xtset id quarter 
sort id quarter
by id: gen N = _N
tab N 
tab N resp_status
tab resp_status
gen quasi_resp = 2 - resp_status
tab quasi_resp 

bysort id (quarter): gen groups = sum(quasi_resp)
egen new_id = group(id groups)
duplicates tag new_id, gen(hh)
tab hh

xtset new_id quarter 

xi: xtreg exphi pastup age male married i.educat i.quarter, fe vce(robust)

* x years from now,interest rate will be higher
sum Q2_5A,d
replace Q2_5A=. if Q2_5A>=99
sum Q2_5B,d
replace Q2_5B=. if Q2_5B>=99
sum Q2_5C,d
replace Q2_5C=. if Q2_5C>=99

gen exphi12 = (exphi== 1 & Q2_5B>Q2_5A) if Q2_5B!=. & Q2_5A!=.
xi:xtreg exphi12 pastup age male married i.educat i.quarter, fe vce(robust)

gen exphi125 = (exphi== 1 & Q2_5B>Q2_5A & Q2_5C>Q2_5B) if Q2_5B!=. & Q2_5A!=. & Q2_5C!=.
xi:xtreg exphi125 pastup age male married i.educat i.quarter,fe vce(robust)

* taking actions in responses to interest rate expectations
gen bf   = (Q2_6M1==1|Q2_6M2==1|Q2_6M3==1|Q2_6M4==1|Q2_6M5==1)
gen pp   = (Q2_6M1==2|Q2_6M2==2|Q2_6M3==2|Q2_6M4==2|Q2_6M5==2)
gen cut  = (Q2_6M1==3|Q2_6M2==3|Q2_6M3==3|Q2_6M4==3|Q2_6M5==3)
gen pay  = (Q2_6M1==4|Q2_6M2==4|Q2_6M3==4|Q2_6M4==4|Q2_6M5==4)
gen none = (Q2_6M1==5|Q2_6M2==5|Q2_6M3==5|Q2_6M4==5|Q2_6M5==5)

xi: xtreg pay pastup age male married i.educat i.quarter,fe vce(robust)

xi: xtreg cut pastup age male married i.educat i.quarter,fe vce(robust)

xi: xtreg pp pastup age male married i.educat i.quarter,fe vce(robust)

xi: xtreg bf pastup age male married i.educat i.quarter,fe vce(robust)


* contractionary episode only
xi:xtreg exphi pastup age male married i.educat i.quarter if quarter>=q(2017q3),fe vce(robust)

xi:xtreg exphi12 pastup age male married i.educat i.quarter if quarter>=q(2017q3),fe vce(robust)

xi:xtreg exphi125 pastup age male married i.educat i.quarter if quarter>=q(2017q3),fe vce(robust)

xi:xtreg pay pastup age male married i.educat i.quarter if quarter>=q(2017q3),fe vce(robust)

xi:xtreg cut pastup age male married i.educat i.quarter if quarter>=q(2017q3),fe vce(robust)

xi:xtreg pp pastup age male married i.educat i.quarter if quarter>=q(2017q3),fe vce(robust)

xi:xtreg bf pastup age male married i.educat i.quarter if quarter>=q(2017q3),fe vce(robust)

