clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use borrower_statistics_dataset_rate_decrease.dta,clear

keep if frm==1

keep if inlist(term,60)

keep if reset_mon>=m(2010m1)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month>m(2017m1)

drop if postrenew_reco==. 

* Regressions 
foreach x of varlist cscore {
foreach tt of numlist 24 36 48 60{
quietly xtreg f3.`x' postrenew_reco age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

foreach x of varlist by65_60 by65_90 in65_60 in65_90 ai65_60 ai65_90 bc65_60 bc65_90 {
foreach tt of numlist 24 36 48 60{
quietly xtreg f3.`x' postrenew_reco age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

estimates table cscore_24 cscore_36 cscore_48 cscore_60,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table by65_60_24 by65_90_24 in65_60_24 in65_90_24 ai65_60_24 ai65_90_24 bc65_60_24 bc65_90_24,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)

estimates table by65_60_36 by65_90_36 in65_60_36 in65_90_36 ai65_60_36 ai65_90_36 bc65_60_36 bc65_90_36,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)

estimates table by65_60_48 by65_90_48 in65_60_48 in65_90_48 ai65_60_48 ai65_90_48 bc65_60_48 bc65_90_48,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)

estimates table by65_60_60 by65_90_60 in65_60_60 in65_90_60 ai65_60_60 ai65_90_60 bc65_60_60 bc65_90_60,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)
