clear all

cd ""

use autoplot,clear   // run Figure1_2_5_plots to obtain this data

scalar dur = 44.36*24/1.13
scalar auto = 18.56*84/1.13
scalar scale = 0.95  // for aggregation: from 2,3,4,5-yr FRM to all FRM

gen autopct = 100*autoamt/salesamt
gen autopct5 = 100*autoamt5/salesamt

* expansionary episode 2015.1-2017.1
egen e1_frm5 = sum(frm5adj) if month>=m(2015m1) & month<=m(2017m1)
egen e1_frm4 = sum(frm4adj) if month>=m(2015m1) & month<=m(2017m1)
egen e1_frm3 = sum(frm3adj) if month>=m(2015m1) & month<=m(2017m1)
egen e1_frm2 = sum(frm2adj) if month>=m(2015m1) & month<=m(2017m1)

egen e2_frm5 = sum(frm5adj) if month>=m(2017m7) & month<=m(2019m6)
egen e2_frm4 = sum(frm4adj) if month>=m(2017m7) & month<=m(2019m6)
egen e2_frm3 = sum(frm3adj) if month>=m(2017m7) & month<=m(2019m6)
egen e2_frm2 = sum(frm2adj) if month>=m(2017m7) & month<=m(2019m6)

egen temp = sum(salesamt) if month>=m(2015m1) & month<=m(2017m1)

egen e1_autodata = mean(temp)
gen e1_durdata = 3.299*10^11  // StatsCan GDP data on quarterly durable expenditures (Table: 36-10-0104-01 (formerly CANSIM 380-0064)

* auto spending
gen e1_auto_tot = (auto*(0.16*e1_frm2+0.18*e1_frm3+0.38*e1_frm4+1.13*e1_frm5))/scale
gen e1_auto_frm5= auto*(1.13*e1_frm5)


* durable spending
gen e1_dur_tot  = (dur*(0.16*e1_frm2+0.18*e1_frm3+0.38*e1_frm4+1.13*e1_frm5))/scale
gen e1_dur_frm5= dur*(1.13*e1_frm5)


* mortgage paydown
gen e1_mort_tot=((14.74-1.76)*24*e1_frm2+(13.91-2.19)*36*e1_frm3+(34.17-9.9)*48*e1_frm4+(92.03-46.47)*60*e1_frm5)/scale
gen e1_mort_frm5=(92.03-46.47)*60*e1_frm5

gen e2_mort_tot=((84.49-83.33)*24*e2_frm2+(49.49-54.98)*36*e2_frm3+(40.37-36.29)*48*e2_frm4+(39.23-34)*60*e2_frm5)/scale
gen e2_mort_frm5=(39.23-34)*60*e2_frm5



* ==============================================================================
* Table 12 Expansionary
* ==============================================================================
sum e1_auto_tot e1_auto_frm5 e1_dur_tot e1_dur_frm5 e1_mort_tot e1_mort_frm5

* ==============================================================================
* Table 12 Contractionary-Mortgage
* ==============================================================================
sum e2_mort_tot e2_mort_frm5


* For Revolving debt
* aggregate to quarterly 
gen quarter = qofd(dofm(month))
format quarter %tq

sort quarter month
by quarter: egen qgap5 = mean(gap5)
by quarter: egen qgap4 = mean(gap4)
by quarter: egen qgap3 = mean(gap3)
by quarter: egen qgap2 = mean(gap2)

sort quarter month
by quarter: egen qfrm5adj = sum(frm5adj)
by quarter: egen qfrm4adj = sum(frm4adj)
by quarter: egen qfrm3adj = sum(frm3adj)
by quarter: egen qfrm2adj = sum(frm2adj)
by quarter : keep if _n==1
keep quarter q*

* Asymmetry in elasticity
gen gap5_neg = (qgap5<=0)
gen gap4_neg = (qgap4<=0)
gen gap3_neg = (qgap3<=0)
gen gap2_neg = (qgap2<=0)

* Rev debt paid down due to refi (Table 6 estimates)
gen frm5sav = qgap5*(1-gap5_neg)*qfrm5adj*(438.2/0.32)
gen frm4sav = qgap4*(1-gap4_neg)*qfrm4adj*(0/0.49)
gen frm3sav = qgap3*(1-gap3_neg)*qfrm3adj*(900.7/0.70)
gen frm2sav = qgap2*(1-gap2_neg)*qfrm2adj*(261.6/0.85)

scalar scale = 0.95  // for aggregate: from 2,3,4,5-yr FRM to all FRM
gen savamt  = (frm5sav+frm4sav+frm3sav+frm2sav)/scale

egen e2_tot = sum(savamt) if quarter>=q(2017q3) & quarter<=q(2019q2)
replace e2_tot = e2_tot
egen e2_frm5 = sum(frm5sav) if quarter>=q(2017q3) & quarter<=q(2019q2)

* ==============================================================================
* Table 12 Contractionary-Revolving
* ==============================================================================
sum e2_tot e2_frm5