clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use mortgage_statistics_dataset_rate_decrease.dta,clear

keep if frm==1

keep if inlist(term,24,36,48,60)

keep if reset_mon>=m(2010m1)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month>m(2017m1)

gen d60 = (mop==3)

sort tu_trade_id month
by tu_trade_id: gen n =_n 

* MORTGAGE SUMMARY STATISTICS BY TERM
* 2-YR TERM
sum current_balance if term==24, d
mat A = r(mean), r(sd)
mat rownames A = "current balance"
sum rate if term==24, d
mat B = r(mean), r(sd)
mat rownames B = "rate"
sum terms_amt if term==24, d
mat C = r(mean), r(sd)
mat rownames C = "scheduled payment"
sum d60 if term==24, d
mat D = r(mean), r(sd)
mat rownames D = "60-day mortgage delinquency"
count if n==1 & term==24
mat E = r(N), r(N)
mat rownames E = "number of loans"
mat J = A\B\C\D\E
mat colnames J = mean sd
mat list J

* 3-YR TERM
sum current_balance if term==36, d
mat A = r(mean), r(sd)
mat rownames A = "current balance"
sum rate if term==36, d
mat B = r(mean), r(sd)
mat rownames B = "rate"
sum terms_amt if term==36, d
mat C = r(mean), r(sd)
mat rownames C = "scheduled payment"
sum d60 if term==36, d
mat D = r(mean), r(sd)
mat rownames D = "60-day mortgage delinquency"
count if n==1 & term==36
mat E = r(N), r(N)
mat rownames E = "number of loans"
mat J = A\B\C\D\E
mat colnames J = mean sd
mat list J

* 4-YR TERM
sum current_balance if term==48, d
mat A = r(mean), r(sd)
mat rownames A = "current balance"
sum rate if term==48, d
mat B = r(mean), r(sd)
mat rownames B = "rate"
sum terms_amt if term==48, d
mat C = r(mean), r(sd)
mat rownames C = "scheduled payment"
sum d60 if term==48, d
mat D = r(mean), r(sd)
mat rownames D = "60-day mortgage delinquency"
count if n==1 & term==48
mat E = r(N), r(N)
mat rownames E = "number of loans"
mat J = A\B\C\D\E
mat colnames J = mean sd
mat list J

* 5-YR TERM 
sum current_balance if term==60, d
mat A = r(mean), r(sd)
mat rownames A = "current balance"
sum rate if term==60, d
mat B = r(mean), r(sd)
mat rownames B = "rate"
sum terms_amt if term==60, d
mat C = r(mean), r(sd)
mat rownames C = "scheduled payment"
sum d60 if term==60, d
mat D = r(mean), r(sd)
mat rownames D = "60-day mortgage delinquency"
count if n==1 & term==60
mat E = r(N), r(N)
mat rownames E = "number of loans"
mat J = A\B\C\D\E
mat colnames J = mean sd
mat list J

* RATE INCREASE EPISODE
* 2YR-TERM
use mortgage_statistics_dataset_rate_decrease.dta,clear

keep if inlist(term,24)

keep if reset_mon>=m(2012m7)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

gen d60 = (mop==3)

sort tu_trade_id month
by tu_trade_id: gen n=_n

* MORTGAGE SUMMARY STATISTICS
sum current_balance if term==24, d
mat A = r(mean), r(sd)
mat rownames A = "current balance"
sum rate if term==24, d
mat B = r(mean), r(sd)
mat rownames B = "rate"
sum terms_amt if term==24, d
mat C = r(mean), r(sd)
mat rownames C = "scheduled payment"
sum d60 if term==24, d
mat D = r(mean), r(sd)
mat rownames D = "60-day mortgage delinquency"
count if n==1 & term==24
mat E = r(N), r(N)
mat rownames E = "number of loans"
mat J = A\B\C\D\E
mat colnames J = mean sd
mat list J


* 3-YR TERM
use mortgage_statistics_dataset_rate_decrease.dta,clear

keep if inlist(term,36)

keep if reset_mon>=m(2012m10)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

gen d60 = (mop==3)

sort tu_trade_id month
by tu_trade_id: gen n=_n

* MORTGAGE SUMMARY STATISTICS
sum current_balance if term==36, d
mat A = r(mean), r(sd)
mat rownames A = "current balance"
sum rate if term==36, d
mat B = r(mean), r(sd)
mat rownames B = "rate"
sum terms_amt if term==36, d
mat C = r(mean), r(sd)
mat rownames C = "scheduled payment"
sum d60 if term==36, d
mat D = r(mean), r(sd)
mat rownames D = "60-day mortgage delinquency"
count if n==1 & term==36
mat E = r(N), r(N)
mat rownames E = "number of loans"
mat J = A\B\C\D\E
mat colnames J = mean sd
mat list J

* 4-YR TERM
use mortgage_statistics_dataset_rate_decrease.dta,clear

keep if inlist(term,48)

keep if reset_mon>=m(2012m11)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)


gen d60 = (mop==3)

sort tu_trade_id month
by tu_trade_id: gen n=_n

* MORTGAGE SUMMARY STATISTICS
sum current_balance if term==48, d
mat A = r(mean), r(sd)
mat rownames A = "current balance"
sum rate if term==48, d
mat B = r(mean), r(sd)
mat rownames B = "rate"
sum terms_amt if term==48, d
mat C = r(mean), r(sd)
mat rownames C = "scheduled payment"
sum d60 if term==48, d
mat D = r(mean), r(sd)
mat rownames D = "60-day mortgage delinquency"
count if n==1 & term==48
mat E = r(N), r(N)
mat rownames E = "number of loans"
mat J = A\B\C\D\E
mat colnames J = mean sd
mat list J


* 5-YR TERM
use mortgage_statistics_dataset_rate_decrease.dta,clear

keep if inlist(term,60)

keep if reset_mon>=m(2013m2)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

gen d60 = (mop==3)

sort tu_trade_id month
by tu_trade_id: gen n=_n

* MORTGAGE SUMMARY STATISTICS BY TERM
sum current_balance if term==60, d
mat A = r(mean), r(sd)
mat rownames A = "current balance"
sum rate if term==60, d
mat B = r(mean), r(sd)
mat rownames B = "rate"
sum terms_amt if term==60, d
mat C = r(mean), r(sd)
mat rownames C = "scheduled payment"
sum d60 if term==60, d
mat D = r(mean), r(sd)
mat rownames D = "60-day mortgage delinquency"
count if n==1 & term==60
mat E = r(N), r(N)
mat rownames E = "number of loans"
mat J = A\B\C\D\E
mat colnames J = mean sd
mat list J


