clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use borrower_statistics_dataset_rate_decrease.dta,clear

keep if frm==1

keep if inlist(term,24,36,48,60)

keep if reset_mon>=m(2010m1)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month>m(2017m1)

drop if postrenew_reco==. 

gen tot_util_ur = (bc33 + by33)/(bc28 + by28)
sum tot_util_ur,d
gen p99 = r(p99)
gen tot_util_rp99 = tot_util_ur 
replace tot_util_rp99 = . if tot_util_ur>=p99
drop p99

    gen age_cat = 1 if age>45 & age<=65  
replace age_cat = 2 if age<=45  
replace age_cat = 3 if age>65  

    gen totutil = (bc33+by33)/(bc28+by28)

   * low credit score indicator 
   sort tu_consumer_id open_mon tu_trade_id month
by tu_consumer_id open_mon tu_trade_id: gen dyn_postrenew = sum(postrenew_reco)
gen temp=.
sort tu_consumer_id open_mon tu_trade_id month
foreach i of numlist 1/12{
by tu_consumer_id open_mon tu_trade_id :  replace temp=1 if dyn_postrenew[_n+`i']==1 & temp==.
}
by tu_consumer_id open_mon tu_trade_id: egen temp2 = mean(cscore) if temp==1
by tu_consumer_id open_mon tu_trade_id: egen avgcs12 = mean(temp2)
drop temp*

sum avgcs12, d
gen avgcs12_low = (avgcs12<r(p50)) if avgcs12!=.
gen interact_avgcs12_low = avgcs12_low*postrenew_reco

   * high credit utilization indicator 
gen temp=.
sort tu_consumer_id open_mon tu_trade_id month
foreach i of numlist 1/12{
by tu_consumer_id open_mon tu_trade_id :  replace temp=1 if dyn_postrenew[_n+`i']==1 & temp==.
}
by tu_consumer_id open_mon tu_trade_id: egen temp2 = mean(totutil) if temp==1
by tu_consumer_id open_mon tu_trade_id: egen avgutil12 = mean(temp2)
drop temp*

gen avgutil12_high = (avgutil12>=0.5) if avgutil12!=.
gen interact_avgutil12_high = avgutil12_high*postrenew_reco

drop dyn_postrenew

* Regressions
foreach x of varlist bcy33 bc33 by33 tot_util_rp99 {
foreach tt of numlist 60{
quietly xtreg `x' postrenew_reco interact_avgcs12_low avgcs12_low i.age_cat lagfsaltv_high i.month if term==`tt',fe r
estimates store `x'_csavg_`tt'
}
}

foreach x of varlist bcy33 bc33 by33 tot_util_rp99{
foreach tt of numlist 60{
quietly xtreg `x' postrenew_reco interact_avgutil12_high avgutil12_high lagcscore_low i.age_cat lagfsaltv_high i.month if term==`tt',fe r
estimates store `x'_turavg_`tt'
}
}

foreach x of varlist bcy33 bc33 by33 tot_util_rp99{
foreach tt of numlist 60{
quietly xtreg `x' i.age_cat##postrenew_reco lagcscore_low lagfsaltv_high i.month if term==`tt',fe r
estimates store `x'_age_`tt'
}
}

estimates table bcy33_csavg_60 bc33_csavg_60 by33_csavg_60,keep(postrenew_reco interact*) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table bcy33_turavg_60 bc33_turavg_60 by33_turavg_60 ,keep(postrenew_reco interact*) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table bcy33_age_60 bc33_age_60 by33_age_60,keep(1.postrenew_reco 2.age_cat#1.postrenew_reco 3.age_cat#1.postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table tot_util_rp99_csavg_60,keep(postrenew_reco interact*) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table tot_util_rp99_turavg_60,keep(postrenew_reco interact*) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table tot_util_rp99_age_60,keep(1.postrenew_reco 2.age_cat#1.postrenew_reco 3.age_cat#1.postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

