clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

* 2-YR TERM
use borrower_statistics_dataset_rate_increase.dta,clear

keep if frm==1

keep if inlist(term,24)

keep if reset_mon>=m(2012m7)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

drop if postrenew_reco==. 

xtset tu_trade_id month

* Change in balances
gen dbc28    = bc28-l.bc28
gen dby28    = by28-l.by28

* Required payments divided by balances for credit cards and lines of credit
gen cc_reqpayratio_lag = bc60/l.bc33
gen loc_reqpayratio_lag = by60/l.by33

* Credit limits: large increase in credit limit >1000
     * credit card
gen newbc_lm = (dbc28>1000)  if dbc28!=.
     * loc
gen newloc_lm = (dby28>1000) if dby28!=.

* Regressions
foreach x of varlist by28 bc28{
foreach tt of numlist 24{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

foreach x of varlist newbc_lm newloc_lm cc_reqpayratio_lag loc_reqpayratio_lag {
foreach tt of numlist 24{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

estimates table by28_24 bc28_24,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table newbc_lm_24 newloc_lm_24 cc_reqpayratio_lag_24 loc_reqpayratio_lag_24,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)

* 3-YR TERM 
use borrower_statistics_dataset_rate_increase.dta,clear

keep if frm==1

keep if inlist(term,36)

keep if reset_mon>=m(2012m10)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

drop if postrenew_reco==. 

xtset tu_trade_id month

* Change in balances
gen dbc28    = bc28-l.bc28
gen dby28    = by28-l.by28

* Required payments divided by balances for credit cards and lines of credit
gen cc_reqpayratio_lag = bc60/l.bc33
gen loc_reqpayratio_lag = by60/l.by33

* Credit limits: large increase in credit limit >1000
     * credit card
gen newbc_lm = (dbc28>1000)  if dbc28!=.
     * loc
gen newloc_lm = (dby28>1000) if dby28!=.

* Regressions 
foreach x of varlist by28 bc28{
foreach tt of numlist 36{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

foreach x of varlist newbc_lm newloc_lm cc_reqpayratio_lag loc_reqpayratio_lag {
foreach tt of numlist 36{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

estimates table by28_36 bc28_36,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table newbc_lm_36 newloc_lm_36 cc_reqpayratio_lag_36 loc_reqpayratio_lag_36,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)

* 4-YR TERM 

use borrower_statistics_dataset_rate_increase.dta,clear

keep if frm==1

keep if inlist(term,48)

keep if reset_mon>=m(2012m11)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

drop if postrenew_reco==. 

xtset tu_trade_id month

* Change in balances
gen dbc28    = bc28-l.bc28
gen dby28    = by28-l.by28

* Required payments divided by balances for credit cards and lines of credit
gen cc_reqpayratio_lag = bc60/l.bc33
gen loc_reqpayratio_lag = by60/l.by33

* Credit limits: large increase in credit limit >1000
     * credit card
gen newbc_lm = (dbc28>1000)  if dbc28!=.
     * loc
gen newloc_lm = (dby28>1000) if dby28!=.

* Regressions 
foreach x of varlist by28 bc28{
foreach tt of numlist 48{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

foreach x of varlist newbc_lm newloc_lm cc_reqpayratio_lag loc_reqpayratio_lag {
foreach tt of numlist 48{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

estimates table by28_48 bc28_48,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table newbc_lm_48 newloc_lm_48 cc_reqpayratio_lag_48 loc_reqpayratio_lag_48,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)

* 5-YR TERM
use borrower_statistics_dataset_rate_increase.dta,clear

keep if frm==1

keep if inlist(term,60)

keep if reset_mon>=m(2013m2)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

drop if postrenew_reco==. 

xtset tu_trade_id month

* Change in balances
gen dbc28    = bc28-l.bc28
gen dby28    = by28-l.by28

* Required payments divided by balances for credit cards and lines of credit
gen cc_reqpayratio_lag = bc60/l.bc33
gen loc_reqpayratio_lag = by60/l.by33

* Credit limits: large increase in credit limit >1000
     * credit card
gen newbc_lm = (dbc28>1000)  if dbc28!=.
     * loc
gen newloc_lm = (dby28>1000) if dby28!=.

* Regressions
foreach x of varlist by28 bc28{
foreach tt of numlist 60{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

foreach x of varlist newbc_lm newloc_lm cc_reqpayratio_lag loc_reqpayratio_lag {
foreach tt of numlist 60{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

estimates table by28_60 bc28_60,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table newbc_lm_60 newloc_lm_60 cc_reqpayratio_lag_60 loc_reqpayratio_lag_60,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)

