clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use CSCE_cleanMicrodata.dta,clear

* format the quarter variable to numerical rather than categorical...
sort Survey_Quarter RESPID
by Survey_Quarter: gen temp=(_n==1)
gen temp2=sum(temp)
gen quarter = q(2014q3)+temp2
format quarter %tq

tab quarter
drop if quarter==q(2019q3)
drop if quarter==q(2014q4)

* housing status
keep if Q6_13==1|Q6_13==2  //mortgage borrowers (frm or vrm)
gen frm   = (Q6_13==1)
gen mover = (Q6_8<=1)  // live in primary residence <=1 year

    gen status = 0 if frm==1 & mover==0
replace status = 1 if frm==0 & mover==0
replace status = 2 if mover==1

gen frm_nonmover = (frm==1 & mover==0)
gen nonfrm_nonmover = (frm==0 & mover==0)

* over the last 12 months, how interest rates have changed
gen pastup=(Q2_3==4|Q2_3==5)  //risen a lot/a little
gen pastdn=(Q2_3==1|Q2_3==2)  //fall a lot/a little

* next 12 month expectation (how likely the average interest rate will be higher)
replace Q2_4 =. if Q2_4>100
replace Q2_4 = 100 - Q2_4 if QCQ4==2 & quarter>=q(2018q4)
replace Q2_4 = 100 - Q2_4 if QCQ2==2 & quarter<=q(2018q3)

* taking actions in responses to interest rate expectations
gen bf   = (Q2_6M1==1|Q2_6M2==1|Q2_6M3==1|Q2_6M4==1|Q2_6M5==1)
gen pp   = (Q2_6M1==2|Q2_6M2==2|Q2_6M3==2|Q2_6M4==2|Q2_6M5==2)
gen cut  = (Q2_6M1==3|Q2_6M2==3|Q2_6M3==3|Q2_6M4==3|Q2_6M5==3)
gen pay  = (Q2_6M1==4|Q2_6M2==4|Q2_6M3==4|Q2_6M4==4|Q2_6M5==4)
gen none = (Q2_6M1==5|Q2_6M2==5|Q2_6M3==5|Q2_6M4==5|Q2_6M5==5)


* measuring expectations: expect rates more likely (prob>0.5) to rise
gen exphi = 1 if Q2_4>50 & Q2_4<=100
replace exphi = 0 if Q2_4<=50

gen expnonhi = 1 - exphi 

* household characteristics 
gen age = Q6_1
gen male= (Q6_2==1)
gen married = (Q6_5==1)
gen educat = Q6_3

tab educat
gen bachplus = (Q6_3>=6) if Q6_3!=99

* interest rates 
sum Q2_5A,d
replace Q2_5A=. if Q2_5A>=99
sum Q2_5B,d
replace Q2_5B=. if Q2_5B>=99
sum Q2_5C,d
replace Q2_5C=. if Q2_5C>=99

* explansionary period = 0 
gen period = 0 if quarter<q(2017q1)
replace period = 1 if quarter>=q(2017q3)
keep if period==0|period==1 

foreach num of numlist 0/1{
table period if period==`num', c(mean age sd age)
table period if period==`num', c(mean male sd male)
table period if period==`num', c(mean married sd married)
table period if period==`num', c(mean bachplus sd bachplus)
table period if period==`num', c(mean frm_nonmover sd frm_nonmover)
table period if period==`num', c(mean nonfrm_nonmover sd nonfrm_nonmover)
table period if period==`num', c(mean pastup sd pastup)
table period if period==`num', c(mean exphi sd exphi)
table period if period==`num' & pastup==1, c(mean exphi sd exphi)
table period if period==`num' & pastdn==1, c(mean exphi sd exphi)

foreach var of varlist Q2_5A Q2_5B Q2_5C{
sum `var' if period==`num',d
gen p99 = r(p99)
replace `var' = . if `var'>=p99 & period==`num'
drop p99
}

table period if period==`num', c(mean Q2_5A sd Q2_5A)
table period if period==`num', c(mean Q2_5B sd Q2_5B)
table period if period==`num', c(mean Q2_5C sd Q2_5C)


table period if period==`num', c(mean pay sd pay)
table period if period==`num', c(mean cut sd cut)
table period if period==`num', c(mean pp sd pp)
table period if period==`num', c(mean bf sd bf)
}

* overall 

use CSCE_cleanMicrodata2.dta,clear

* format the quarter variable to numerical rather than categorical...
sort Survey_Quarter RESPID
by Survey_Quarter: gen temp=(_n==1)
gen temp2=sum(temp)
gen quarter = q(2014q3)+temp2
format quarter %tq

tab quarter
drop if quarter==q(2019q3)
drop if quarter==q(2014q4)

* housing status
keep if Q6_13==1|Q6_13==2  //mortgage borrowers (frm or vrm)
gen frm   = (Q6_13==1)
gen mover = (Q6_8<=1)  // live in primary residence <=1 year

    gen status = 0 if frm==1 & mover==0
replace status = 1 if frm==0 & mover==0
replace status = 2 if mover==1

gen frm_nonmover = (frm==1 & mover==0)
gen nonfrm_nonmover = (frm==0 & mover==0)

* over the last 12 months, how interest rates have changed
gen pastup=(Q2_3==4|Q2_3==5)  //risen a lot/a little
gen pastdn=(Q2_3==1|Q2_3==2)  //fall a lot/a little

* next 12 month expectation (how likely the average interest rate will be higher)
replace Q2_4 =. if Q2_4>100
replace Q2_4 = 100 - Q2_4 if QCQ4==2 & quarter>=q(2018q4)
replace Q2_4 = 100 - Q2_4 if QCQ2==2 & quarter<=q(2018q3)

* taking actions in responses to interest rate expectations
gen bf   = (Q2_6M1==1|Q2_6M2==1|Q2_6M3==1|Q2_6M4==1|Q2_6M5==1)
gen pp   = (Q2_6M1==2|Q2_6M2==2|Q2_6M3==2|Q2_6M4==2|Q2_6M5==2)
gen cut  = (Q2_6M1==3|Q2_6M2==3|Q2_6M3==3|Q2_6M4==3|Q2_6M5==3)
gen pay  = (Q2_6M1==4|Q2_6M2==4|Q2_6M3==4|Q2_6M4==4|Q2_6M5==4)
gen none = (Q2_6M1==5|Q2_6M2==5|Q2_6M3==5|Q2_6M4==5|Q2_6M5==5)


* measuring expectations: expect rates more likely (prob>0.5) to rise
gen exphi = 1 if Q2_4>50 & Q2_4<=100
replace exphi = 0 if Q2_4<=50

gen expnonhi = 1 - exphi 

* household characteristics 
gen age = Q6_1
gen male= (Q6_2==1)
gen married = (Q6_5==1)
gen educat = Q6_3

tab educat
gen bachplus = (Q6_3>=6) if Q6_3!=99

* interest rates 
sum Q2_5A,d
replace Q2_5A=. if Q2_5A>=99
sum Q2_5B,d
replace Q2_5B=. if Q2_5B>=99
sum Q2_5C,d
replace Q2_5C=. if Q2_5C>=99


* explansionary period = 0 
gen period = 1

table period, c(mean age sd age)
table period, c(mean male sd male)
table period, c(mean married sd married)
table period, c(mean bachplus sd bachplus)
table period, c(mean frm_nonmover sd frm_nonmover)
table period, c(mean nonfrm_nonmover sd nonfrm_nonmover)
table period, c(mean pastup sd pastup)
table period, c(mean exphi sd exphi)
table period if pastup==1, c(mean exphi sd exphi)
table period if pastdn==1, c(mean exphi sd exphi)

foreach var of varlist Q2_5A Q2_5B Q2_5C{
sum `var',d
gen p99 = r(p99)
replace `var' = . if `var'>=p99
drop p99
}

table period, c(mean Q2_5A sd Q2_5A)
table period, c(mean Q2_5B sd Q2_5B)
table period, c(mean Q2_5C sd Q2_5C)


table period, c(mean pay sd pay)
table period, c(mean cut sd cut)
table period, c(mean pp sd pp)
table period, c(mean bf sd bf)

