clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use borrower_statistics_dataset_rate_decrease.dta,clear

keep if frm==1

keep if inlist(term,24,36,48,60)

keep if reset_mon>=m(2010m1)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month>m(2017m1)

drop if postrenew_reco==. 

gen total_pay = in60 + by60 + bc60 + ai60 + terms_amt if terms_amt!=. & terms_amt>0
gen nonmort_pay = in60 + by60 + bc60 + ai60 if terms_amt!=. & total_pay!=. 
gen revolv_pay = by60 + bc60 if terms_amt!=. & total_pay!=. 

* Regressions 
foreach x of varlist total_pay nonmort_pay revolv_pay terms_amt{
foreach tt of numlist 24 36 48 60{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt' & total_pay!=.,fe r
estimates store `x'_`tt'
}
}

estimates table total_pay_24 nonmort_pay_24 revolv_pay_24 terms_amt_24,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table total_pay_36 nonmort_pay_36 revolv_pay_36 terms_amt_36,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table total_pay_48 nonmort_pay_48 revolv_pay_48 terms_amt_48,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

estimates table total_pay_60 nonmort_pay_60 revolv_pay_60 terms_amt_60,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)
