clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

* 2-YR TERM 
use borrower_statistics_dataset_rate_increase.dta,clear

keep if frm==1

keep if inlist(term,24)

keep if reset_mon>=m(2012m7)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

drop if postrenew_reco==. 

gen total_pay = in60 + by60 + bc60 + ai60 + terms_amt if terms_amt!=. & terms_amt>0
gen nonmort_pay = in60 + by60 + bc60 + ai60 if terms_amt!=. & total_pay!=. 
gen revolv_pay = by60 + bc60 if terms_amt!=. & total_pay!=. 

* Regressions
foreach x of varlist total_pay nonmort_pay revolv_pay terms_amt{
foreach tt of numlist 24{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt' & total_pay!=.,fe r
estimates store `x'_`tt'
}
}

estimates table total_pay_24 nonmort_pay_24 revolv_pay_24 terms_amt_24,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)


* 3-YR TERM 

use borrower_statistics_dataset_rate_increase.dta,clear

keep if frm==1

keep if inlist(term,36)

keep if reset_mon>=m(2012m10)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

drop if postrenew_reco==. 

gen total_pay = in60 + by60 + bc60 + ai60 + terms_amt if terms_amt!=. & terms_amt>0
gen nonmort_pay = in60 + by60 + bc60 + ai60 if terms_amt!=. & total_pay!=. 
gen revolv_pay = by60 + bc60 if terms_amt!=. & total_pay!=. 

* Regressions 
foreach x of varlist total_pay nonmort_pay revolv_pay terms_amt{
foreach tt of numlist 36{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt' & total_pay!=.,fe r
estimates store `x'_`tt'
}
}

estimates table total_pay_36 nonmort_pay_36 revolv_pay_36 terms_amt_36,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

* 4-YR TERM 
use borrower_statistics_dataset_rate_increase.dta,clear

keep if frm==1

keep if inlist(term,48)

keep if reset_mon>=m(2012m11)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

drop if postrenew_reco==. 

gen total_pay = in60 + by60 + bc60 + ai60 + terms_amt if terms_amt!=. & terms_amt>0
gen nonmort_pay = in60 + by60 + bc60 + ai60 if terms_amt!=. & total_pay!=. 
gen revolv_pay = by60 + bc60 if terms_amt!=. & total_pay!=. 

* Regressions 
foreach x of varlist total_pay nonmort_pay revolv_pay terms_amt{
foreach tt of numlist 48{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt' & total_pay!=.,fe r
estimates store `x'_`tt'
}
}

estimates table total_pay_48 nonmort_pay_48 revolv_pay_48 terms_amt_48,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)

* 5-YR TERM 
use borrower_statistics_dataset_rate_increase.dta,clear

keep if frm==1

keep if inlist(term,60)

keep if reset_mon>=m(2013m2)

keep if reset_renew==1 

drop if lifecy>term+18

drop if month==m(2019m7)

drop if postrenew_reco==. 

gen total_pay = in60 + by60 + bc60 + ai60 + terms_amt if terms_amt!=. & terms_amt>0
gen nonmort_pay = in60 + by60 + bc60 + ai60 if terms_amt!=. & total_pay!=. 
gen revolv_pay = by60 + bc60 if terms_amt!=. & total_pay!=. 

* Regressions 
foreach x of varlist total_pay nonmort_pay revolv_pay terms_amt{
foreach tt of numlist 60{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt' & total_pay!=.,fe r
estimates store `x'_`tt'
}
}

estimates table total_pay_60 nonmort_pay_60 revolv_pay_60 terms_amt_60,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N)
