clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

* 2-YR TERM 
use mortgage_statistics_dataset_rate_increase.dta, clear 

keep if frm==1

keep if inlist(term,24)

keep if reset_mon>=m(2012m7)

keep if reset_renew==1 

drop if month==m(2019m7)

drop if postrenew_reco==. 

drop if lifecy>term+18

sort tu_consumer_id open_mon tu_trade_id month
by tu_consumer_id open_mon tu_trade_id: egen qq4 = sum(postrenew_reco)

drop if qq4>12 

gen d60 = (mop==3)

gen TT = T0 if postrenew_reco==0
replace TT = T1 if postrenew_reco==1

  * Regressions
foreach x of varlist rate req_amt terms_amt TT d60{
foreach tt of numlist 24{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

estimates table rate_24 req_amt_24 terms_amt_24 TT_24,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N) 
estimates table d60_24,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)

* 3-YR TERM 
use mortgage_statistics_dataset_rate_increase.dta, clear 

keep if frm==1

keep if inlist(term,36)

keep if reset_mon>=m(2012m10)

keep if reset_renew==1 

drop if month==m(2019m7)

drop if postrenew_reco==. 

drop if lifecy>term+18

sort tu_consumer_id open_mon tu_trade_id month
by tu_consumer_id open_mon tu_trade_id: egen qq4 = sum(postrenew_reco)

drop if qq4>12 

gen d60 = (mop==3)

gen TT = T0 if postrenew_reco==0
replace TT = T1 if postrenew_reco==1

 * Regressions 
foreach x of varlist rate req_amt terms_amt TT d60{
foreach tt of numlist 36{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

estimates table rate_36 req_amt_36 terms_amt_36 TT_36,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N) 
estimates table d60_36,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)

* 4-YR TERM 
use mortgage_statistics_dataset_rate_increase.dta, clear 

keep if frm==1

keep if inlist(term,48)

keep if reset_mon>=m(2012m11)

keep if reset_renew==1 

drop if month==m(2019m7)

drop if postrenew_reco==. 

drop if lifecy>term+18

sort tu_consumer_id open_mon tu_trade_id month
by tu_consumer_id open_mon tu_trade_id: egen qq4 = sum(postrenew_reco)

drop if qq4>12 

gen d60 = (mop==3)

gen TT = T0 if postrenew_reco==0
replace TT = T1 if postrenew_reco==1

  * Regressions
foreach x of varlist rate req_amt terms_amt TT d60{
foreach tt of numlist 48{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

estimates table rate_48 req_amt_48 terms_amt_48 TT_48,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N) 
estimates table d60_48,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)

* 5-YR TERM 
use mortgage_statistics_dataset_rate_increase.dta, clear 

keep if frm==1

keep if inlist(term,60)

keep if reset_mon>=m(2013m2)

keep if reset_renew==1 

drop if month==m(2019m7)

drop if postrenew_reco==. 

drop if lifecy>term+18

sort tu_consumer_id open_mon tu_trade_id month
by tu_consumer_id open_mon tu_trade_id: egen qq4 = sum(postrenew_reco)

drop if qq4>12 

gen d60 = (mop==3)

gen TT = T0 if postrenew_reco==0
replace TT = T1 if postrenew_reco==1

 * Regressions 
foreach x of varlist rate req_amt terms_amt TT d60{
foreach tt of numlist 60{
quietly xtreg `x' postrenew_reco lagcscore age lagfsaltv i.month if term==`tt',fe r
estimates store `x'_`tt'
}
}

estimates table rate_60 req_amt_60 terms_amt_60 TT_60,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N) 
estimates table d60_60,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N)
