clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use mortgage_statistics_dataset_rate_decrease.dta,clear 

keep if frm==1

keep if inlist(term,24,36,48,60)

keep if reset_mon>=m(2010m1)

keep if reset_renew==1 

drop if postrenew_reco==. 

drop if lifecy>term+18
 
keep if (reset_renew==1)

keep if term==nextterm

gen d60 = (mop==3)

gen TT = T0 if postrenew_reco==0
replace TT = T1 if postrenew_reco==1

* 2-YR TERM 
* Regressions 
xtreg rate postrenew_reco lagcscore age lagfsaltv i.month if term==24, fe r
estimates store rate_24
	
xtreg req_amt postrenew_reco lagcscore age lagfsaltv i.month if term==24, fe r
estimates store req_amt_24

xtreg terms_amt postrenew_reco lagcscore age lagfsaltv i.month if term==24, fe r
estimates store terms_amt_24

xtreg TT postrenew_reco lagcscore age lagfsaltv i.month if term==24, fe r
estimates store TT_24

xtreg d60 postrenew_reco lagcscore age lagfsaltv i.month if term==24, fe r
estimates store d60_24

estimates table rate_24 req_amt_24 terms_amt_24 TT_24,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N) 
estimates table d60_24,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N) 

* 3-YR TERM 
* Regressions 
xtreg rate postrenew_reco lagcscore age lagfsaltv i.month if term==36, fe r
estimates store rate_36
	
xtreg req_amt postrenew_reco lagcscore age lagfsaltv i.month if term==36, fe r
estimates store req_amt_36

xtreg terms_amt postrenew_reco lagcscore age lagfsaltv i.month if term==36, fe r
estimates store terms_amt_36

xtreg TT postrenew_reco lagcscore age lagfsaltv i.month if term==36, fe r
estimates store TT_36

xtreg d60 postrenew_reco lagcscore age lagfsaltv i.month if term==36, fe r
estimates store d60_36

estimates table rate_36 req_amt_36 terms_amt_36 TT_36,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N) 
estimates table d60_36,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N) 

* 4-YR TERM 
* Regressions 
xtreg rate postrenew_reco lagcscore age lagfsaltv i.month if term==48, fe r
estimates store rate_48
	
xtreg req_amt postrenew_reco lagcscore age lagfsaltv i.month if term==48, fe r
estimates store req_amt_48

xtreg terms_amt postrenew_reco lagcscore age lagfsaltv i.month if term==48, fe r
estimates store terms_amt_48

xtreg TT postrenew_reco lagcscore age lagfsaltv i.month if term==48, fe r
estimates store TT_48

xtreg d60 postrenew_reco lagcscore age lagfsaltv i.month if term==48, fe r
estimates store d60_48

estimates table rate_48 req_amt_48 terms_amt_48 TT_48,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N) 
estimates table d60_48,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N) 

* 5-YR TERM 
* Regressions 
xtreg rate postrenew_reco lagcscore age lagfsaltv i.month if term==60, fe r
estimates store rate_60
	
xtreg req_amt postrenew_reco lagcscore age lagfsaltv i.month if term==60, fe r
estimates store req_amt_60

xtreg terms_amt postrenew_reco lagcscore age lagfsaltv i.month if term==60, fe r
estimates store terms_amt_60

xtreg TT postrenew_reco lagcscore age lagfsaltv i.month if term==60, fe r
estimates store TT_60

xtreg d60 postrenew_reco lagcscore age lagfsaltv i.month if term==60, fe r
estimates store d60_60

estimates table rate_60 req_amt_60 terms_amt_60 TT_60,keep(postrenew_reco) b(%7.3f) se(%7.3f) p(%7.3f) stats(N) 
estimates table d60_60,keep(postrenew_reco) b(%7.6f) se(%7.6f) p(%7.3f) stats(N) 

