clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

use mortgage_statistics_dataset_rate_decrease.dta,clear 

keep if frm==1 

keep if reset_mon>=m(2010m1)

keep if reset_mon<m(2015m1) 

keep if inlist(term,36,48,60)

drop if lifecy>term+18

rename rep_mon month

drop if postrenew_reco==. 

gen d60 = (mop==3)

gen TT = T0 if postrenew_reco==0
replace TT = T1 if postrenew_reco==1

gen T15 = postrenew_reco
gen X = T15*reset_renew

* Regressions 
foreach var of varlist rate req_amt terms_amt TT d60{
foreach num of numlist 60{
xtreg `var' X T15 reset_renew  lagcscore age lagfsaltv i.month if (term==`num' & reset_mon>=m(2010m1) & reset_mon<=m(2011m12) & reset_renew==1)|(term==`num' & reset_mon>=m(2012m1) & reset_mon<=m(2012m12) & reset_renew==0)  , fe vce(cl tu_trade_id)
estimates store `var'_`num'
}
}

foreach var of varlist rate req_amt terms_amt TT d60{
foreach num of numlist 48{
xtreg `var' X T15 reset_renew  lagcscore age lagfsaltv i.month if (term==`num' & reset_mon>=m(2011m1) & reset_mon<=m(2012m12) & reset_renew==1)|(term==`num' & reset_mon>=m(2013m1) & reset_mon<=m(2013m12) & reset_renew==0)  , fe vce(cl tu_trade_id)
estimates store `var'_`num'
}
}

foreach var of varlist rate req_amt terms_amt TT d60{
foreach num of numlist 36{
xtreg `var' X T15 reset_renew  lagcscore age lagfsaltv i.month if (term==`num' & reset_mon>=m(2012m1) & reset_mon<=m(2013m12) & reset_renew==1)|(term==`num' & reset_mon>=m(2014m1) & reset_mon<=m(2014m12) & reset_renew==0)  , fe vce(cl tu_trade_id)
estimates store `var'_`num'
}
}

estimates table rate_36 req_amt_36 terms_amt_36 TT_36,keep(X) b(%7.3f) se(%7.3f) p(%7.3f) stats(N) 
estimates table d60_36,keep(X) b(%7.6f) se(%7.6f) p(%7.3f) stats(N) 

estimates table rate_48 req_amt_48 terms_amt_48 TT_48,keep(X) b(%7.3f) se(%7.3f) p(%7.3f) stats(N) 
estimates table d60_48,keep(X) b(%7.6f) se(%7.6f) p(%7.3f) stats(N) 

estimates table rate_60 req_amt_60 terms_amt_60 TT_60,keep(X) b(%7.3f) se(%7.3f) p(%7.3f) stats(N) 
estimates table d60_60,keep(X) b(%7.6f) se(%7.6f) p(%7.3f) stats(N) 
