clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

* auto dataset 
use auto.dta, clear 

sort tu_trade_id rep_mon
by tu_trade_id: gen temp = (rep_mon - open_mon) if _n==1
tab temp

sort tu_trade_id rep_mon
by tu_trade_id: gen new_loan = (temp>=-2 & temp<=1) if rep_mon!=. & open_mon!=. & _n==1 & current_balance>1000 & current_balance!=.
tab new_loan
drop temp 

* delinquencies
gen d90 = (mop ==4)
gen d60 = (mop ==3)

* newauto and newauto_ba variables at tu_trade_id level
gen newauto_ba = 1 if new_loan==1 & current_balance!=.
replace newauto_ba = 0 if newauto_ba!=1 & current_balance!=.

gen newauto = current_balance if new_loan==1
replace newauto = 0 if new_loan!=1 & current_balance!=.

* newauto, newauto_ba, delinquencies and terms_amt at consumer level
sort tu_consumer_id rep_mon tu_trade_id 
by tu_consumer_id rep_mon: egen tterms_amt = sum(terms_amt)
replace tterms_amt=. if terms_amt==.
rename tterms_amt auto_terms

sort tu_consumer_id rep_mon
by tu_consumer_id rep_mon: egen temp = sum(newauto_ba)
by tu_consumer_id rep_mon: gen temp2 = (temp>=1)
replace newauto_ba = temp2
drop temp*

sort tu_consumer_id rep_mon
by tu_consumer_id rep_mon: egen temp = sum(newauto)
replace newauto = temp
drop temp*

* delinquencies
by tu_consumer_id rep_mon: egen temp = sum(d90)
by tu_consumer_id rep_mon: gen ai65_90 = (temp>=1)
drop temp*

by tu_consumer_id rep_mon: egen temp = sum(d60)
by tu_consumer_id rep_mon: gen ai65_60 = (temp>=1)
drop temp*

keep tu_consumer_id rep_mon auto_terms newauto newauto_ba ai65_60 ai65_90
sort tu_consumer_id rep_mon
by tu_consumer_id rep_mon: gen n=_n
tab n
keep if n==1
drop n

save, replace 

* install dataset 
use install.dta

sort tu_trade_id rep_mon
by tu_trade_id: gen temp = (rep_mon - open_mon) if _n==1
tab temp

sort tu_trade_id rep_mon
by tu_trade_id: gen new_loan = (temp>=-2 & temp<=1) if rep_mon!=. & open_mon!=. & _n==1 & current_balance>1000 & current_balance!=.
tab new_loan
drop temp 

* delinquencies
gen d90 = (mop ==4)
gen d60 = (mop ==3)

* newauto and newauto_ba variables at tu_trade_id level
gen newauto_ba = 1 if new_loan==1 & current_balance!=.
replace newauto_ba = 0 if newauto_ba!=1 & current_balance!=.

gen newauto = current_balance if new_loan==1
replace newauto = 0 if new_loan!=1 & current_balance!=.

* newauto, newauto_ba, delinquencies and terms_amt at consumer level
sort tu_consumer_id rep_mon tu_trade_id 
by tu_consumer_id rep_mon: egen tterms_amt = sum(terms_amt)
replace tterms_amt=. if terms_amt==.
rename tterms_amt auto_terms

sort tu_consumer_id rep_mon
by tu_consumer_id rep_mon: egen temp = sum(newauto_ba)
by tu_consumer_id rep_mon: gen temp2 = (temp>=1)
replace newauto_ba = temp2
drop temp*

sort tu_consumer_id rep_mon
by tu_consumer_id rep_mon: egen temp = sum(newauto)
replace newauto = temp
drop temp*

* delinquencies
by tu_consumer_id rep_mon: egen temp = sum(d90)
by tu_consumer_id rep_mon: gen ai65_90 = (temp>=1)
drop temp*

by tu_consumer_id rep_mon: egen temp = sum(d60)
by tu_consumer_id rep_mon: gen ai65_60 = (temp>=1)
drop temp*

keep tu_consumer_id rep_mon auto_terms newauto newauto_ba ai65_60 ai65_90
sort tu_consumer_id rep_mon
by tu_consumer_id rep_mon: gen n=_n
tab n
keep if n==1
drop n

save, replace 

* loc dataset 
use loc.dta, clear 

* delinquencies
gen d90 = (mop ==4)
gen d60 = (mop ==3)

* heloc 
gen hdummy = (credit_limit>=50000) if credit_limit!=. 

* total balances, total terms_amt, total credit limit 
sort tu_consumer_id rep_mon tu_trade_id 
by tu_consumer_id rep_mon: egen tcurrent_balance = sum(current_balance)
rename tcurrent_balance by33

sort tu_consumer_id rep_mon tu_trade_id 
by tu_consumer_id rep_mon: egen tterms_amt = sum(terms_amt)
rename tterms_amt loc_terms

sort tu_consumer_id hdummy rep_mon 
by tu_consumer_id hdummy rep_mon: egen tcurrent_balance = sum(current_balance) if hdummy==1
rename tcurrent_balance hby33 

sort tu_consumer_id rep_mon tu_trade_id 
by tu_consumer_id rep_mon: egen tcredit_limit = sum(credit_limit)
rename tcredit_limit by28

sort tu_consumer_id hdummy rep_mon 
by tu_consumer_id hdummy rep_mon: egen tcredit_limit = sum(credit_limit) if hdummy==1
rename tcredit_limit hby28 

* delinquencies
by tu_consumer_id rep_mon: egen temp = sum(d90)
by tu_consumer_id rep_mon: gen ai65_90 = (temp>=1)
drop temp*

by tu_consumer_id rep_mon: egen temp = sum(d60)
by tu_consumer_id rep_mon: gen ai65_60 = (temp>=1)
drop temp*

keep tu_consumer_id rep_mon loc_terms by33 hby33 by28 hby28 by65_60 by65_90
sort tu_consumer_id rep_mon
by tu_consumer_id rep_mon: gen n=_n
tab n
keep if n==1
drop n

save, replace 

* cc dataset 
use cc.dta, clear 

* delinquencies
gen d90 = (mop ==4)
gen d60 = (mop ==3)

* total balances, total terms_amt, total credit limit 
sort tu_consumer_id rep_mon tu_trade_id 
by tu_consumer_id rep_mon: egen tcurrent_balance = sum(current_balance)
rename tcurrent_balance bc33

sort tu_consumer_id rep_mon tu_trade_id 
by tu_consumer_id rep_mon: egen tterms_amt = sum(terms_amt)
rename tterms_amt cc_terms

sort tu_consumer_id rep_mon tu_trade_id 
by tu_consumer_id rep_mon: egen tcredit_limit = sum(credit_limit)
rename tcredit_limit bc28

* delinquencies
by tu_consumer_id rep_mon: egen temp = sum(d90)
by tu_consumer_id rep_mon: gen ai65_90 = (temp>=1)
drop temp*

by tu_consumer_id rep_mon: egen temp = sum(d60)
by tu_consumer_id rep_mon: gen ai65_60 = (temp>=1)
drop temp*

keep tu_consumer_id rep_mon cc_terms bc33 bc28 bc65_60 bc65_90
sort tu_consumer_id rep_mon
by tu_consumer_id rep_mon: gen n=_n
tab n
keep if n==1
drop n

save, replace

* combined dataset 
use mortgage_statistics_dataset_rate_decrease.dta, clear 

keep rep_mon tu_consumer_id 

sort rep_mon tu_consumer_id 
by rep_mon tu_consumer_id: keep if _n==1

count
merge 1:1 rep_mon tu_consumer_id using auto.dta
drop if _merge==2
drop _merge

count
merge 1:1 rep_mon tu_consumer_id using loc.dta
drop if _merge==2
drop _merge

count
merge 1:1 rep_mon tu_consumer_id using cc.dta
drop if _merge==2
drop _merge

count
merge 1:1 rep_mon tu_consumer_id using install.dta
drop if _merge==2
drop _merge

merge 1:m rep_mon tu_consumer_id using mortgage_statistics_dataset_rate_decrease.dta
drop _merge

* trim- according to balances
local names ="bc by"
foreach x of local names{
sum `x'33 if `x'33>0,d
gen `x'33_ub = r(p99) 

replace `x'33=. if `x'33>`x'33_ub

sum `x'28 if `x'28>0,d
gen `x'28_ub = r(p99) 

replace `x'28=. if `x'28>`x'28_ub
}
drop *_ub

drop month
rename rep_mon month

gen bcy33 = bc33 + by33 

save borrower_statistics_dataset_rate_decrease.dta, replace 

