clear all
cap close
set more off
set excelxlsxlargefile on

cd ""

* This file produces the loan-level results for the rate increasing period

use BNSdata.dta,clear

keep if month>=m(2012m7)
keep if month<=m(2019m8) 

* adjust (change maturity month)
sort tu_consumer_id open_mon tu_trade_id rep_mon
by tu_consumer_id open_mon tu_trade_id: gen adjust = (mat_mon!=mat_mon[_n-1] & _n!=1)

by tu_consumer_id open_mon tu_trade_id: replace adjust = 1 if adjust==0 & adjust[_n+1]==1 & month==m(2018m8) & mat_mon==m(2018m6)
by tu_consumer_id open_mon tu_trade_id: replace adjust = 0 if adjust==1 & adjust[_n-1]==1 & month==m(2018m9) & mat_mon[_n-1]==m(2018m6)
by tu_consumer_id open_mon tu_trade_id: replace mat_mon = mat_mon[_n+1] if mat_mon==m(2018m6) & adjust==1 & month==m(2018m8)
by tu_consumer_id open_mon tu_trade_id: replace terms_amt = terms_amt[_n+1] if mat_mon[_n-1]==m(2018m6) & adjust==1 & month==m(2018m8)

* renew (as scheduled)
sort tu_consumer_id open_mon tu_trade_id rep_mon
by tu_consumer_id open_mon tu_trade_id: gen renew = (adjust==1 & rep_mon>=mat_mon[_n-1]-6 & rep_mon<=mat_mon[_n-1]+6) 

* drop adjust out of renew range
gen temp =1 if adjust==1 & renew==0
by tu_consumer_id open_mon tu_trade_id: egen temp2 = mean(temp)
drop if temp2==1 
drop temp* 

* drop adjust out of renew range
gen temp =1 if adjust==1 & renew==0
by tu_consumer_id open_mon tu_trade_id: egen temp2 = mean(temp)
drop if temp2==1 
drop temp* 

* post-renew indicator
by tu_consumer_id open_mon tu_trade_id: gen postrenew = sum(renew) 

* vrm and frm
sort tu_consumer_id open_mon tu_trade_id postrenew rep_mon
  by tu_consumer_id open_mon tu_trade_id postrenew: gen vrmpay = (renew==0 & terms_amt!=terms_amt[_n-1] & terms_amt>0 & terms_amt!=. & terms_amt[_n-1]>0 & terms_amt[_n-1]!=. &_n!=1) 
by tu_consumer_id open_mon tu_trade_id postrenew: egen nvrmpay_within = sum(vrmpay)

gen vrm_within = (nvrmpay_within>0) 

by tu_consumer_id open_mon tu_trade_id postrenew: gen temp=(_n==1)
by tu_consumer_id open_mon tu_trade_id: egen nterm=sum(temp) 
drop temp 

by tu_consumer_id open_mon tu_trade_id postrenew: gen temp=(_n==1 & vrm_within==1)
by tu_consumer_id open_mon tu_trade_id: egen temp2 = sum(temp)

gen vrm=(nterm==temp2) 
gen frm=(temp2==0)
gen mixloan = 1-frm-vrm 

drop temp* vrmpay *within nterm 

* 3-step impute rates
  * (1) formula: b(t)=(1+r)b(t-1)-M (annualized effective rate)
by tu_consumer_id open_mon tu_trade_id:     gen imputer = 100*12*((current_ba+terms_amt)/current_ba[_n-1]-1) if current_ba>0 & terms_amt>0 & current_ba[_n-1]>0

// Case 1: current ba are either not changing or increase (imputer too high)
by tu_consumer_id open_mon tu_trade_id: gen test1 = (current_ba>=current_ba[_n-1] & current_ba!=. & current_ba[_n-1]!=. & current_ba>0 & current_ba[_n-1]>0)
replace imputer = . if test1==1 & rep_mon!=m(2018m6)

// Case 2: prepay too much (balance reduces more than 0.9*terms_amt)
by tu_consumer_id open_mon tu_trade_id: gen test2 = ((current_ba[_n-1]-current_ba)>0.9*terms_amt & terms_amt!=. & terms_amt>0 & current_ba!=. & current_ba[_n-1]!=. & current_ba>0 & current_ba[_n-1]>0)
replace imputer = . if test2==1

// Case 3: terms_amt =0.
replace imputer = . if terms_amt==0

  * (2) drop loans with median r too low or too high
sort tu_consumer_id open_mon tu_trade_id postrenew rep_mon 
  by tu_consumer_id open_mon tu_trade_id postrenew: egen medr = median(imputer)

  by tu_consumer_id open_mon tu_trade_id: egen minmed = min(medr) 
  by tu_consumer_id open_mon tu_trade_id: egen maxmed = max(medr) 

sum medr,d
gen lb = r(p1)  
gen ub = r(p99)  
drop if minmed<=lb 
drop if maxmed>=ub 

* Use medr for frm; use adjusted imputer for vrm
gen rate = round(medr,0.01) if frm==1
replace rate = round(imputer,0.01) if vrm==1
replace rate = round(medr,0.01) if (imputer<=lb|imputer>=ub) & vrm==1
replace rate =. if (test1==1 & rep_mon!=m(2018m6))
replace rate = . if terms_amt==.
gen rate2 = round(medr,0.01) if frm==1

sort tu_consumer_id open_mon tu_trade_id rep_mon
by tu_consumer_id open_mon tu_trade_id: replace current_balance = current_balance[_n-1] - (terms_amt - current_balance[_n-1]*rate/1200) if mat_mon[_n-1]==m(2018m6) & adjust==1 & rep_mon==m(2018m6)

drop minmed maxmed lb ub imputer medr test1 test2

table rep_mon, contents(med rate)

* recover actual payment
sort tu_consumer_id open_mon tu_trade_id rep_mon 
by tu_consumer_id open_mon tu_trade_id:     gen pay_amt = (1+rate/1200)*current_ba[_n-1]-current_ba if current_ba>0 & terms_amt>0 & current_ba[_n-1]>0
by tu_consumer_id open_mon tu_trade_id: replace pay_amt = (1+rate/1200)*high_credit_amt-current_ba if current_ba>0 & terms_amt>0 & high_credit_amt>0 & open_mon==rep_mon & frm==1

* # of renewals per account
by tu_consumer_id open_mon tu_trade_id: egen nrenew = sum(renew) 

* month of actual renew
gen temp =rep_mon if renew==1 & nrenew==1
by tu_consumer_id open_mon tu_trade_id: egen renew_mon = mean(temp) 
format renew_mon %tm
drop temp

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==2
by tu_consumer_id open_mon tu_trade_id: egen renew21_mon = mean(temp) 
format renew21_mon %tm
drop temp

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==2
by tu_consumer_id open_mon tu_trade_id: egen renew22_mon = mean(temp) 
format renew22_mon %tm
drop temp

gen temp =rep_mon if renew==1 & postrenew==1 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen renew31_mon = mean(temp) 
format renew31_mon %tm
drop temp

gen temp =rep_mon if renew==1 & postrenew==2 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen renew32_mon = mean(temp) 
format renew32_mon %tm
drop temp

gen temp =rep_mon if renew==1 & postrenew==3 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen renew33_mon = mean(temp) 
format renew33_mon %tm
drop temp

* month of scheduled renew
by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 & nrenew==1
by tu_consumer_id open_mon tu_trade_id: egen schrenew = mean(temp)
format schrenew %tm
drop temp

by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 &postrenew==1 & nrenew==2
by tu_consumer_id open_mon tu_trade_id: egen schrenew21 = mean(temp)
format schrenew21 %tm
drop temp

by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 &postrenew==2 & nrenew==2
by tu_consumer_id open_mon tu_trade_id: egen schrenew22 = mean(temp)
format schrenew22 %tm
drop temp

by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 &postrenew==1 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen schrenew31 = mean(temp)
format schrenew31 %tm
drop temp

by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 &postrenew==2 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen schrenew32 = mean(temp)
format schrenew32 %tm
drop temp

by tu_consumer_id open_mon tu_trade_id: gen temp = mat_mon[_n-1] if renew==1 &postrenew==3 & nrenew==3
by tu_consumer_id open_mon tu_trade_id: egen schrenew33 = mean(temp)
format schrenew33 %tm
drop temp

* month of next scheduled renew
by tu_consumer_id open_mon tu_trade_id: gen temp =mat_mon if _n==_N 
by tu_consumer_id open_mon tu_trade_id: egen nextrenew = mean(temp)
format nextrenew %tm
drop temp

* for figure (time diff between actual and scheduled renew)
gen diff = renew_mon-schrenew
replace diff = renew21_mon-schrenew21 if diff==.
replace diff = renew31_mon-schrenew31 if diff==.

gen diff2 = renew22_mon-schrenew22 
replace diff2 = renew32_mon-schrenew32 if diff2==.

gen diff3 = renew33_mon-schrenew33 


* Redefine reset and renew

drop if nrenew>3 
drop if closed_mon<m(2017m7) 
drop if distress<m(2017m7) 

drop if renew_mon<m(2012m7)  
drop if renew21_mon<m(2012m7)  
drop if renew31_mon<m(2012m7) 

drop if mixloan==1 

* classify all loans based on reset(open/renew) between 2012m7-2017m6
    gen type = 1 if open_mon>=m(2012m7) & open_mon<=m(2017m6) & nrenew==0
replace type = 2 if open_mon<m(2012m7) & nrenew==0
replace type = 15 if open_mon>=m(2017m7) & nrenew==0
    
replace type = 3 if open_mon>=m(2012m7) & open_mon<=m(2017m6) & renew_mon>=m(2017m7) & nrenew==1
replace type = 4 if open_mon<m(2012m7) & renew_mon>=m(2017m7) & nrenew==1
replace type = 5 if renew_mon>=m(2012m7) & renew_mon<=m(2017m6) & nrenew==1
replace type = 16 if open_mon>=m(2017m7) & nrenew==1

replace type = 6 if open_mon>=m(2012m7) & open_mon<=m(2017m6) & renew21_mon>=m(2017m7) & nrenew==2
replace type = 7 if open_mon<m(2012m7)  & renew21_mon>=m(2017m7) & nrenew==2
replace type = 8 if renew21_mon>=m(2012m7) & renew21_mon<=m(2017m6) & renew22_mon>=m(2017m7) & nrenew==2
replace type = 9 if renew22_mon>=m(2012m7) & renew22_mon<=m(2017m6) & nrenew==2
replace type = 17 if open_mon>=m(2017m7) & nrenew==2

replace type = 10 if open_mon>=m(2012m7) & open_mon<=m(2017m6) & renew31_mon>=m(2017m7) & nrenew==3
replace type = 11 if open_mon<m(2012m7) & renew31_mon>=m(2017m7) & nrenew==3
replace type = 12 if renew31_mon>=m(2012m7) & renew31_mon<=m(2017m6) & renew32_mon>=m(2017m7) & nrenew==3
replace type = 13 if renew32_mon>=m(2012m7) & renew32_mon<=m(2017m6) & renew33_mon>=m(2017m7) & nrenew==3
replace type = 14 if renew33_mon>=m(2012m7) & renew33_mon<=m(2017m6) & nrenew==3
replace type = 18 if open_mon>=m(2017m7) & nrenew==3

count if type==. 

* terms of these loans since reset
    gen term = nextrenew - open_mon    if inlist(type,1,2,15)
replace term = schrenew  - open_mon    if inlist(type,3,4,16)
replace term = nextrenew - renew_mon   if type==5
replace term = schrenew21- open_mon    if inlist(type,6,7,17)
replace term = schrenew22- renew21_mon if type==8
replace term = nextrenew - renew22_mon if type==9
replace term = schrenew31- open_mon    if inlist(type,10,11,18)
replace term = schrenew32- renew31_mon if type==12
replace term = schrenew33- renew32_mon if type==13
replace term = nextrenew - renew33_mon if type==14

keep if inlist(term,24,36,48,60,84,120) 

* drop loans that should be renewed before 2019.3 but not (mostly closed before renew)
drop if inlist(type,1,2,5,9,14,15) & nextrenew<=m(2019m8) 

* drop loans that renewed or scheduled to be renewed after 2019.4
drop if renew_mon>=m(2019m9)   & nrenew==1 
drop if renew21_mon>=m(2019m9) & nrenew==2 
drop if renew22_mon>=m(2019m9) & nrenew==2 
drop if renew31_mon>=m(2019m9) & nrenew==3 
drop if renew32_mon>=m(2019m9) & nrenew==3 
drop if renew33_mon>=m(2019m9) & nrenew==3 

drop if schrenew>=m(2019m9)   & nrenew==1 
drop if schrenew21>=m(2019m9) & nrenew==2 
drop if schrenew22>=m(2019m9) & nrenew==2 
drop if schrenew31>=m(2019m9) & nrenew==3 
drop if schrenew32>=m(2019m9) & nrenew==3 
drop if schrenew33>=m(2019m9) & nrenew==3 

* lifecycle of a loan since reset
drop if postrenew==0 & inlist(type,5,8,12) 
drop if postrenew<=1 & inlist(type,9,13) 
drop if postrenew<=2 & type==14 
drop postrenew

by tu_consumer_id open_mon tu_trade_id: gen lifecy = 3+_n-1 if !inlist(type,2,4,7,11)
replace lifecy = rep_mon-open_mon if inlist(type,2,4,7,11)

* recode the reset month
    gen reset_mon = open_mon  if inlist(type,1,2,3,4,6,7,10,11,15,16,17,18)
replace reset_mon = renew_mon if type==5
replace reset_mon = renew21_mon if type==8
replace reset_mon = renew22_mon if type==9
replace reset_mon = renew31_mon if type==12
replace reset_mon = renew32_mon if type==13
replace reset_mon = renew33_mon if type==14
 format reset_mon %tm

* recode the initial status (0:reset was an open; 1:reset was a renewal)
gen reset_status = 0 if inlist(type,1,2,3,4,6,7,10,11,15,16,17,18)
replace reset_status = 1 if !inlist(type,1,2,3,4,6,7,10,11,15,16,17,18)

* recode the renew (since last reset) indicator
    gen postrenew_reco =0 
replace postrenew_reco =1 if rep_mon>=renew_mon  & inlist(type,3,4,16)
replace postrenew_reco =1 if rep_mon>=renew21_mon & inlist(type,6,7,17)
replace postrenew_reco =1 if rep_mon>=renew22_mon & inlist(type,8)
replace postrenew_reco =1 if rep_mon>=renew31_mon & inlist(type,10,11,18)
replace postrenew_reco =1 if rep_mon>=renew32_mon & inlist(type,12)
replace postrenew_reco =1 if rep_mon>=renew33_mon & inlist(type,13)

* recode the diff based on the renew
gen diff_reco = renew_mon-schrenew if inlist(type,3,4,16)
replace diff_reco = renew21_mon-schrenew21 if inlist(type,6,7,17)
replace diff_reco = renew22_mon-schrenew22 if inlist(type,8)
replace diff_reco = renew31_mon-schrenew31 if inlist(type,10,11,18)
replace diff_reco = renew32_mon-schrenew32 if inlist(type,12)
replace diff_reco = renew33_mon-schrenew33 if inlist(type,13)

* recode the renew month (since last reset)
sort tu_consumer_id open_mon tu_trade_id rep_mon 
by tu_consumer_id open_mon tu_trade_id: gen temp = rep_mon if postrenew_reco ==1 & postrenew_reco[_n-1]==0
by tu_consumer_id open_mon tu_trade_id: egen reset_renew_mon = mean(temp)
format reset_renew_mon %tm
drop temp

* term after renew
    gen nextterm = nextrenew-renew_mon if inlist(type,3,4,16)
replace nextterm = schrenew22-renew21_mon if inlist(type,6,7,17)
replace nextterm = nextrenew-renew22_mon if type==8
replace nextterm = schrenew32-renew31_mon if inlist(type,10,11,18)
replace nextterm = schrenew33-renew32_mon if type==12
replace nextterm = nextrenew-renew33_mon if type==13

* current term
gen current_term = term
replace current_term = nextterm if inlist(type,3,4,6,7,8,10,11,12,13,16,17,18) & postrenew_reco ==1

* Remaining amortization period right before renew -- formular: T0 = -log(1-r0*b0/M0)/log(1+r0)
sort tu_consumer_id open_mon tu_trade_id rep_mon 
by tu_consumer_id open_mon tu_trade_id: gen temp = -log(1-(rate/1200)*current_ba/terms_amt)/log(1+rate/1200) if ((postrenew_reco==0 & postrenew_reco[_n+1] ==1)|(postrenew_reco==0 & _n==_N)) & current_ba>0 & terms_amt>0
gen temp2 = round(temp,1)
replace temp2=. if temp2>40*12
by tu_consumer_id open_mon tu_trade_id: egen T0 = mean(temp2)
drop temp* 

* Required payment amt after renew assuming balance the same as before  -- formular: M = r1*b0/(1-(1+r1)^(-T0))
by tu_consumer_id open_mon tu_trade_id: gen temp = ((rate/1200)*current_ba[_n-1])/(1-(1+rate/1200)^(-T0)) if postrenew_reco ==1 & postrenew_reco[_n-1] ==0 & current_ba[_n-1]>0
by tu_consumer_id open_mon tu_trade_id: egen req_amt = mean(temp)
replace req_amt = terms_amt if postrenew_reco==0
drop temp

* Implied amortization period with the req_amt
* Remaining amortization period right after renew -- formula: T1 = -log(1-r1*b0/M1)/log(1+r1)
sort tu_consumer_id open_mon tu_trade_id rep_mon 
by tu_consumer_id open_mon tu_trade_id: gen temp = -log(1-(rate/1200)*current_ba[_n-1]/terms_amt)/log(1+rate/1200) if (postrenew_reco==1 & postrenew_reco[_n-1] ==0) & current_ba[_n-1]>0 & terms_amt>0
gen temp2 = round(temp,1)
replace temp2=. if temp2>40*12
by tu_consumer_id open_mon tu_trade_id: egen T1 = mean(temp2)
drop temp* 

* loans that are renewed at least once since reset
gen reset_renew = (inlist(type,3,4,6,7,8,10,11,12,13)) 

* merge with FSA-level HP
gen quarter = qofd(dofm(rep_mon))
format quarter %tq

merge m:1 quarter fsa using /scratch/kart/zhou_folder/fsahp.dta
drop if _merge==2
drop _merge

* construct fsa median debt level and fsa LTV
sort fsa quarter rep_mon tu_consumer_id
by fsa quarter: egen fsab = median(current_ba)
gen fsaltv  = fsab/hp

replace age=. if age==0

replace cscore=. if cscore==0

xtset tu_trade_id rep_mon

gen lagcscore = l3.cscore

    * previous quarter ltv
gen miny = month(dofm(rep_mon))
    gen lagfsaltv = l.fsaltv if inlist(miny,1,4,7,10)
replace lagfsaltv = l2.fsaltv if inlist(miny,2,5,8,11)
replace lagfsaltv = l3.fsaltv if inlist(miny,3,6,9,12)

drop month
rename rep_mon month

save mortgage_statistics_dataset_rate_increase.dta, replace 

